/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csvUtils;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;

public class WorksheetUtils {
    public static String TYPE_EVALUE = "e-value;evalue";
    public static String TYPE_SCORE = "score";
    public static String TYPE_IDENTITIES = "identities";
    public static String TYPE_POSITIVES = "positives";
    public static String TYPE_SIMILARITY = "similarity";
    public static String TYPE_ALIGN_LEN = "align-len;align-length;align_len;align_length;align len;align length";
    public static String TYPE_COORD_FROM = "subject-from;hit-from;subject_from;hit_from;subject from;hit from;query-from;query from";
    public static String TYPE_COORD_TO = "subject-to;hit-to;subject_to;hit_to;subject to;hit to;query-to;query to";
    public static String TYPE_HSP_QUERY_HIT = "hsp/query;hsp/hit";
    private static String INNER_SEPARATOR = "\\|";
    private static String HEADER_NAMES_SEPARATOR = ";";

    public static Point parseHitCoordinatesValue(String hitFrom, String hitTo) {
        Point point = null;
        if (hitFrom.isEmpty() || hitTo.isEmpty()) {
            return point;
        }
        if (hitFrom.matches(".*" + INNER_SEPARATOR + ".*")) {
            int min = 10000000;
            int max = -1;
            String[] partsFrom = hitFrom.split(INNER_SEPARATOR);
            String[] partsTo = hitTo.split(INNER_SEPARATOR);
            int i = 0;
            while (i < partsFrom.length) {
                int start = Integer.parseInt(partsFrom[i].trim());
                int end = Integer.parseInt(partsTo[i].trim());
                if (end < start) {
                    int aux = start;
                    start = end;
                    end = aux;
                }
                if (start < min) {
                    min = start;
                }
                if (end > max) {
                    max = end;
                }
                ++i;
            }
            point = new Point(min, max);
        } else {
            int start = Integer.parseInt(hitFrom.trim());
            int end = Integer.parseInt(hitTo.trim());
            if (end < start) {
                int aux = start;
                start = end;
                end = aux;
            }
            point = new Point(start, end);
        }
        return point;
    }

    public static String parseEvalueColValue(String value) {
        return WorksheetUtils.getMeanFromColValue(value);
    }

    public static String parseScoreColValue(String value) {
        return WorksheetUtils.getMeanFromColValue(value);
    }

    public static String parseSimilarityColValue(String value) {
        return WorksheetUtils.getMeanFromColValue(value);
    }

    public static String parseHspQueryColValue(String value) {
        return WorksheetUtils.getSumFromColValue(value);
    }

    public static String parseHspHitColValue(String value) {
        return WorksheetUtils.getSumFromColValue(value);
    }

    public static String parseHitFromColValue(String value) {
        return WorksheetUtils.getMinFromColumn(value);
    }

    public static String parseHitToColValue(String value) {
        return WorksheetUtils.getMaxFromColumn(value);
    }

    public static String parseIdentitiesColValue(String value) {
        return WorksheetUtils.getSumFromColValue(value);
    }

    public static String parsePositivesColValue(String value) {
        return WorksheetUtils.getSumFromColValue(value);
    }

    public static String parseAlignLengthColValue(String value) {
        return WorksheetUtils.getSumFromColValue(value);
    }

    public static String getMinFromColumn(String value) {
        String returnValue = WorksheetUtils.sanitizeDecimalNumberString(value);
        if (value.matches(".*" + INNER_SEPARATOR + ".*")) {
            String[] values = value.split(INNER_SEPARATOR);
            ArrayList<Double> listDoubles = new ArrayList<Double>();
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String v = stringArray[n2];
                if (!v.trim().isEmpty()) {
                    try {
                        double d = Double.parseDouble(WorksheetUtils.sanitizeDecimalNumberString(v));
                        listDoubles.add(d);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++n2;
            }
            if (listDoubles.size() > 0) {
                double min = 1000000.0;
                int i = 0;
                while (i < listDoubles.size()) {
                    if ((Double)listDoubles.get(i) < min) {
                        min = (Double)listDoubles.get(i);
                    }
                    ++i;
                }
                returnValue = String.valueOf(min);
            }
        }
        return String.valueOf(returnValue);
    }

    public static String getMaxFromColumn(String value) {
        String returnValue = WorksheetUtils.sanitizeDecimalNumberString(value);
        if (value.matches(".*" + INNER_SEPARATOR + ".*")) {
            String[] values = value.split(INNER_SEPARATOR);
            ArrayList<Double> listDoubles = new ArrayList<Double>();
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String v = stringArray[n2];
                if (!v.trim().isEmpty()) {
                    try {
                        double d = Double.parseDouble(WorksheetUtils.sanitizeDecimalNumberString(v));
                        listDoubles.add(d);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++n2;
            }
            if (listDoubles.size() > 0) {
                double max = 0.0;
                int i = 0;
                while (i < listDoubles.size()) {
                    if ((Double)listDoubles.get(i) > max) {
                        max = (Double)listDoubles.get(i);
                    }
                    ++i;
                }
                returnValue = String.valueOf(max);
            }
        }
        return String.valueOf(returnValue);
    }

    public static String getSumFromColValue(String value) {
        String returnValue = WorksheetUtils.sanitizeDecimalNumberString(value);
        if (value.matches(".*" + INNER_SEPARATOR + ".*")) {
            String[] values = value.split(INNER_SEPARATOR);
            ArrayList<Double> listDoubles = new ArrayList<Double>();
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String v = stringArray[n2];
                if (!v.trim().isEmpty()) {
                    try {
                        double d = Double.parseDouble(v);
                        listDoubles.add(d);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++n2;
            }
            if (listDoubles.size() > 0) {
                double sum = 0.0;
                int i = 0;
                while (i < listDoubles.size()) {
                    sum += ((Double)listDoubles.get(i)).doubleValue();
                    ++i;
                }
                returnValue = String.valueOf(sum);
            }
        }
        return String.valueOf(returnValue);
    }

    public static String getMeanFromColValue(String value) {
        String returnValue = WorksheetUtils.sanitizeDecimalNumberString(value);
        if (value.matches(".*" + INNER_SEPARATOR + ".*")) {
            String[] values = value.split(INNER_SEPARATOR);
            ArrayList<Double> listDoubles = new ArrayList<Double>();
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String v = stringArray[n2];
                if (!v.trim().isEmpty()) {
                    try {
                        double d = Double.parseDouble(WorksheetUtils.sanitizeDecimalNumberString(v));
                        listDoubles.add(d);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++n2;
            }
            if (listDoubles.size() > 0) {
                double sum = 0.0;
                int i = 0;
                while (i < listDoubles.size()) {
                    sum += ((Double)listDoubles.get(i)).doubleValue();
                    ++i;
                }
                returnValue = String.valueOf(sum / (double)listDoubles.size());
            }
        }
        return String.valueOf(returnValue);
    }

    public static String getProductFromColValue(String value) {
        String returnValue = WorksheetUtils.sanitizeDecimalNumberString(value);
        if (value.matches(".*" + INNER_SEPARATOR + ".*")) {
            String[] values = value.split(INNER_SEPARATOR);
            ArrayList<Double> listDoubles = new ArrayList<Double>();
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String v = stringArray[n2];
                if (!v.trim().isEmpty()) {
                    double d;
                    block9: {
                        if (v.equals("0") || v.equals("0.0")) {
                            return "0";
                        }
                        d = Double.parseDouble(WorksheetUtils.sanitizeDecimalNumberString(v));
                        Double d2 = new Double("1.0E-180");
                        if (!(d <= d2)) break block9;
                        return "0";
                    }
                    try {
                        listDoubles.add(d);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++n2;
            }
            if (listDoubles.size() > 0) {
                double product = 1.0;
                int i = 0;
                while (i < listDoubles.size()) {
                    product *= ((Double)listDoubles.get(i)).doubleValue();
                    ++i;
                }
                returnValue = product <= new Double("1.0E-180") ? "0" : String.valueOf(product);
            }
        }
        return String.valueOf(returnValue);
    }

    public static String sanitizeDecimalNumberString(String insaneDecimalNumberString) {
        return insaneDecimalNumberString.replace(",", ".");
    }

    public static String parseColValueAuto(String columnName, String columnValue) {
        String returnValue = WorksheetUtils.sanitizeDecimalNumberString(columnValue);
        if (columnValue.matches(".*" + INNER_SEPARATOR + ".*")) {
            returnValue = Arrays.asList(TYPE_EVALUE.split(HEADER_NAMES_SEPARATOR)).contains(columnName) ? WorksheetUtils.parseEvalueColValue(columnValue) : (Arrays.asList(TYPE_SCORE.split(HEADER_NAMES_SEPARATOR)).contains(columnName) ? WorksheetUtils.parseScoreColValue(columnValue) : (Arrays.asList(TYPE_IDENTITIES.split(HEADER_NAMES_SEPARATOR)).contains(columnName) ? WorksheetUtils.parseIdentitiesColValue(columnValue) : (Arrays.asList(TYPE_POSITIVES.split(HEADER_NAMES_SEPARATOR)).contains(columnName) ? WorksheetUtils.parsePositivesColValue(columnValue) : (Arrays.asList(TYPE_SIMILARITY.split(HEADER_NAMES_SEPARATOR)).contains(columnName) ? WorksheetUtils.parseSimilarityColValue(columnValue) : (Arrays.asList(TYPE_ALIGN_LEN.split(HEADER_NAMES_SEPARATOR)).contains(columnName) ? WorksheetUtils.parseAlignLengthColValue(columnValue) : (Arrays.asList(TYPE_COORD_FROM.split(HEADER_NAMES_SEPARATOR)).contains(columnName) ? WorksheetUtils.parseHitFromColValue(columnValue) : (Arrays.asList(TYPE_COORD_TO.split(HEADER_NAMES_SEPARATOR)).contains(columnName) ? WorksheetUtils.parseHitToColValue(columnValue) : (Arrays.asList(TYPE_HSP_QUERY_HIT.split(HEADER_NAMES_SEPARATOR)).contains(columnName) ? WorksheetUtils.parseHspQueryColValue(columnValue) : WorksheetUtils.getMeanFromColValue(columnValue)))))))));
        }
        return String.valueOf(returnValue);
    }
}

