/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csvUtils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;

public class CsvWriter {
    private File fileOutput;
    public static final char SEPARATOR_TAB = '\t';
    public static final char SEPARATOR_SPACE = ' ';
    public static final char SEPARATOR_COLON = ':';
    public static final char SEPARATOR_SEMICOLON = ';';
    public static final char QUOTES_NONE = 'N';
    public static final char QUOTES_SINGLE = '\'';
    public static final char QUOTES_DOUBLE = '\"';
    private char separator = (char)59;
    private char quotes = (char)34;
    public static final char ESCAPE = '\\';
    private BufferedWriter writer;

    public CsvWriter(File fileOutput, char separator, char quotes) {
        this.fileOutput = fileOutput;
        this.separator = separator;
        this.quotes = quotes;
    }

    public void open() throws IOException {
        this.writer = new BufferedWriter(new FileWriter(this.fileOutput));
    }

    public void write(List<String> listColumns) throws IOException {
        if (this.writer == null) {
            this.open();
        }
        List<String> listSanitized = this.sanitizeColumns(listColumns);
        String joined = this.joinColumns(listSanitized);
        this.writer.append(String.valueOf(joined) + "\n");
    }

    private List<String> sanitizeColumns(List<String> listColumns) {
        int i = 0;
        while (i < listColumns.size()) {
            int pos;
            if (listColumns.get(i).indexOf(this.quotes) != -1 && (pos = listColumns.get(i).indexOf(this.quotes)) > 0 && listColumns.get(i).charAt(pos - 1) != '\\') {
                listColumns.set(i, String.valueOf(listColumns.get(i).substring(0, pos)) + '\\' + listColumns.get(i).substring(pos));
            }
            if (listColumns.get(i).contains(" ")) {
                listColumns.set(i, String.valueOf(this.quotes) + listColumns.get(i) + this.quotes);
            } else if (listColumns.get(i).contains(Character.toString(this.separator))) {
                listColumns.set(i, String.valueOf(this.quotes) + listColumns.get(i) + this.quotes);
            }
            ++i;
        }
        return listColumns;
    }

    private String joinColumns(List<String> listColumns) {
        StringBuilder sanitized = new StringBuilder();
        if (listColumns.size() > 0) {
            sanitized.append(listColumns.get(0));
            if (listColumns.size() > 1) {
                int i = 1;
                while (i < listColumns.size()) {
                    sanitized.append(String.valueOf(this.separator) + listColumns.get(i));
                    ++i;
                }
            }
        }
        return sanitized.toString();
    }

    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        }
    }
}

