/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.e3utils;

import com.biotechvana.commons.SharedImages;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public class ChatWidget {
    public static ChatWidget DEFAULT_CHATWIDGET;
    Shell background;
    Point dialogSizeMax = new Point(350, 450);
    Point dialogSizeMin = new Point(75, 75);
    boolean minSize = false;
    Rectangle backgroundSize = null;
    Shell widget;
    private Browser chatBrowser;
    boolean initilzed = false;
    boolean openStatus = false;
    boolean clearChat = true;
    boolean allDeactivated = false;
    private String productName;
    private boolean isWin = false;
    boolean loaded = false;
    ProgressListener p1;
    static String APP_NAME_PLACEHOLDER;
    BrowserFunction b1;
    BrowserFunction b2;

    static {
        APP_NAME_PLACEHOLDER = "__APP_NAME__";
    }

    public ChatWidget(final Shell background) {
        IProduct product = Platform.getProduct();
        if (product != null) {
            this.productName = product.getName();
        }
        this.background = background;
        this.backgroundSize = background.getBounds();
        this.dialogSizeMax = new Point(350, 450);
        if (System.getProperty("os.name").toLowerCase().contains("win")) {
            this.isWin = true;
        }
        background.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                ChatWidget.this.backgroundSize = background.getBounds();
                ChatWidget.this.reSize();
            }

            public void controlMoved(ControlEvent e) {
                ChatWidget.this.backgroundSize = background.getBounds();
                ChatWidget.this.reSize();
            }
        });
        background.addShellListener(new ShellListener(){
            boolean deiconifiedHappening = false;

            public void shellIconified(ShellEvent e) {
                if (ChatWidget.this.widget != null) {
                    ChatWidget.this.widget.setVisible(false);
                }
            }

            public void shellDeiconified(ShellEvent e) {
                if (ChatWidget.this.widget != null) {
                    ChatWidget.this.widget.setVisible(true);
                    ChatWidget.this.showWidget();
                }
            }

            public void shellDeactivated(ShellEvent e) {
            }

            public void shellClosed(ShellEvent e) {
                if (ChatWidget.this.widget != null) {
                    ChatWidget.this.widget.close();
                }
            }

            public void shellActivated(ShellEvent e) {
                if (this.deiconifiedHappening) {
                    this.deiconifiedHappening = false;
                    return;
                }
            }
        });
    }

    private void createWidget() {
        int style = 0x4000400C;
        if (this.isWin) {
            style = 16452;
        }
        this.widget = new Shell(this.background.getDisplay(), style);
        this.widget.setBackground(this.background.getDisplay().getSystemColor(15));
        this.widget.setBackgroundMode(1);
        this.widget.setLayout((Layout)new GridLayout(1, true));
        this.createDialogArea((Composite)this.widget);
        this.reSize();
    }

    void reSize() {
        if (this.widget == null || this.widget.isDisposed()) {
            return;
        }
        System.err.println("ReSize = backgroundSize :" + this.backgroundSize);
        Point dialogSize = this.dialogSizeMax;
        if (this.minSize) {
            dialogSize = this.dialogSizeMin;
        }
        this.widget.setVisible(false);
        this.widget.setSize(dialogSize);
        this.widget.setBounds(this.backgroundSize.width + this.backgroundSize.x - dialogSize.x - 10, this.backgroundSize.height + this.backgroundSize.y - dialogSize.y - 5, dialogSize.x, dialogSize.y);
        this.widget.redraw();
        this.widget.setVisible(true);
    }

    void minSize() {
        if (this.widget == null || this.widget.isDisposed()) {
            return;
        }
        Point loc = this.background.getLocation();
        Rectangle size = this.background.getBounds();
        this.widget.setBounds(size.width + size.x - this.dialogSizeMin.x - 10, size.height + size.y - this.dialogSizeMin.y + 5, this.dialogSizeMin.x, this.dialogSizeMin.y);
    }

    public void open() {
        this.openStatus = true;
        if (this.widget != null && !this.widget.isDisposed()) {
            this.close();
            return;
        }
        this.createWidget();
        this.widget.open();
        if (this.minSize) {
            this.openChat();
        }
        this.widget.setFocus();
    }

    public void close() {
        if (this.widget == null || this.widget.isDisposed()) {
            this.widget = null;
            return;
        }
        if (this.isWin) {
            this.chatBrowser.removeProgressListener(this.p1);
            this.chatBrowser.dispose();
            this.widget.dispose();
            return;
        }
        this.chatBrowser.dispose();
        this.widget.close();
        this.widget = null;
    }

    protected void createDialogArea(Composite parent) {
        int style = 0;
        if (this.isWin) {
            style = 262144;
        }
        this.chatBrowser = new Browser(parent, style);
        Menu menu = new Menu((Decorations)this.widget, 8);
        MenuItem closeMenuItem = new MenuItem(menu, 8);
        closeMenuItem.setText("Close");
        closeMenuItem.setImage(SharedImages.CANCEL);
        closeMenuItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ChatWidget.this.close();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ChatWidget.this.close();
            }
        });
        this.chatBrowser.setMenu(menu);
        GridData gd = new GridData(4, 4, true, true);
        this.chatBrowser.setLayoutData((Object)gd);
        this.loadData(this.chatBrowser);
    }

    public void showWidget() {
        if (this.openStatus) {
            this.widget.setVisible(true);
            this.reSize();
            this.widget.setActive();
        }
    }

    private void loadData(Browser text2) {
        if (this.isWin) {
            text2.setUrl("https://gpro.biotechvana.com/chatViewer_win.html");
        } else {
            text2.setUrl("https://gpro.biotechvana.com/chatViewer.html");
        }
        this.p1 = new ProgressListener(){

            public void completed(ProgressEvent event) {
                ChatWidget.this.loaded = true;
                StringBuffer script = new StringBuffer();
                script.append("init();  ");
                try {
                    if (ChatWidget.this.clearChat) {
                        ChatWidget.this.eval("clearChat();");
                        ChatWidget.this.clearChat = false;
                    }
                    ChatWidget.this.eval(script.toString());
                    if (!ChatWidget.this.isWin) {
                        ChatWidget.this.eval("waitForElementToDisplay('.rw-launcher', function () {openChat();},1000, 9000);");
                        ChatWidget.this.createBrowserFunctions();
                    }
                }
                catch (SWTException e) {
                    e.printStackTrace();
                }
            }

            public void changed(ProgressEvent event) {
            }
        };
        text2.addProgressListener(this.p1);
    }

    private void createBrowserFunctions() {
        this.b1 = new BrowserFunction(this.chatBrowser, "onChatClose"){

            public Object function(Object[] arguments) {
                System.err.println("onChatClose");
                if (ChatWidget.this.isWin) {
                    ChatWidget.this.close();
                    return null;
                }
                ChatWidget.this.minSize = true;
                ChatWidget.this.reSize();
                return null;
            }
        };
        this.b2 = new BrowserFunction(this.chatBrowser, "onChatOpen"){

            public Object function(Object[] arguments) {
                System.err.println("onChatOpen");
                if (!ChatWidget.this.initilzed && !ChatWidget.this.widget.isVisible()) {
                    ChatWidget.this.widget.setVisible(true);
                    ChatWidget.this.chatBrowser.setFocus();
                    ChatWidget.this.initilzed = true;
                }
                ChatWidget.this.minSize = false;
                ChatWidget.this.reSize();
                return null;
            }
        };
    }

    private void eval(String script) {
        try {
            this.chatBrowser.evaluate(script);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private void openChat() {
        if (this.minSize) {
            this.minSize = true;
            this.reSize();
        }
        this.eval("openChat();");
    }
}

