/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.experimental.chart.swt.editor;

import java.util.ResourceBundle;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.chart.util.ResourceBundleWrapper;
import org.jfree.experimental.swt.SWTPaintCanvas;
import org.jfree.experimental.swt.SWTUtils;

class SWTTitleEditor
extends Composite {
    private boolean showTitle;
    private Button showTitleCheckBox;
    private Text titleField;
    private FontData titleFont;
    private Text fontField;
    private Button selectFontButton;
    private Color titleColor;
    private Button selectColorButton;
    protected static ResourceBundle localizationResources = ResourceBundleWrapper.getBundle("org.jfree.chart.editor.LocalizationBundle");
    private Font font;

    SWTTitleEditor(Composite parent, int style, Title title) {
        super(parent, style);
        FillLayout layout = new FillLayout();
        layout.marginWidth = 4;
        layout.marginHeight = 4;
        this.setLayout((Layout)layout);
        TextTitle t = title != null ? (TextTitle)title : new TextTitle(localizationResources.getString("Title"));
        this.showTitle = title != null;
        this.titleFont = SWTUtils.toSwtFontData((Device)this.getDisplay(), t.getFont(), true);
        this.titleColor = SWTUtils.toSwtColor((Device)this.getDisplay(), t.getPaint());
        Group general = new Group((Composite)this, 0);
        general.setLayout((Layout)new GridLayout(3, false));
        general.setText(localizationResources.getString("General"));
        Label label = new Label((Composite)general, 0);
        label.setText(localizationResources.getString("Show_Title"));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.showTitleCheckBox = new Button((Composite)general, 32);
        this.showTitleCheckBox.setSelection(this.showTitle);
        this.showTitleCheckBox.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        this.showTitleCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SWTTitleEditor.this.showTitle = SWTTitleEditor.this.showTitleCheckBox.getSelection();
            }
        });
        new Label((Composite)general, 0).setText(localizationResources.getString("Text"));
        this.titleField = new Text((Composite)general, 2048);
        this.titleField.setText(t.getText());
        this.titleField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label((Composite)general, 0).setText("");
        new Label((Composite)general, 0).setText(localizationResources.getString("Font"));
        this.fontField = new Text((Composite)general, 2048);
        this.fontField.setText(this.titleFont.toString());
        this.fontField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.selectFontButton = new Button((Composite)general, 8);
        this.selectFontButton.setText(localizationResources.getString("Select..."));
        this.selectFontButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FontDialog dlg = new FontDialog(SWTTitleEditor.this.getShell());
                dlg.setText(localizationResources.getString("Font_Selection"));
                dlg.setFontList(new FontData[]{SWTTitleEditor.this.titleFont});
                if (dlg.open() != null) {
                    if (SWTTitleEditor.this.font != null) {
                        SWTTitleEditor.this.font.dispose();
                    }
                    SWTTitleEditor.this.font = new Font((Device)SWTTitleEditor.this.getShell().getDisplay(), dlg.getFontList());
                    SWTTitleEditor.this.fontField.setText(SWTTitleEditor.this.font.getFontData()[0].toString());
                    SWTTitleEditor.this.titleFont = SWTTitleEditor.this.font.getFontData()[0];
                }
            }
        });
        new Label((Composite)general, 0).setText(localizationResources.getString("Color"));
        final SWTPaintCanvas colorCanvas = new SWTPaintCanvas((Composite)general, 0, this.titleColor);
        GridData canvasGridData = new GridData(4, 0x1000000, true, false);
        canvasGridData.heightHint = 20;
        colorCanvas.setLayoutData(canvasGridData);
        this.selectColorButton = new Button((Composite)general, 8);
        this.selectColorButton.setText(localizationResources.getString("Select..."));
        this.selectColorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ColorDialog dlg = new ColorDialog(SWTTitleEditor.this.getShell());
                dlg.setText(localizationResources.getString("Title_Color"));
                dlg.setRGB(SWTTitleEditor.this.titleColor.getRGB());
                RGB rgb = dlg.open();
                if (rgb != null) {
                    SWTTitleEditor.this.titleColor = new Color((Device)SWTTitleEditor.this.getDisplay(), rgb);
                    colorCanvas.setColor(SWTTitleEditor.this.titleColor);
                }
            }
        });
    }

    public String getTitleText() {
        return this.titleField.getText();
    }

    public FontData getTitleFont() {
        return this.titleFont;
    }

    public Color getTitleColor() {
        return this.titleColor;
    }

    public void setTitleProperties(JFreeChart chart) {
        if (this.showTitle) {
            TextTitle title = chart.getTitle();
            if (title == null) {
                title = new TextTitle();
                chart.setTitle(title);
            }
            title.setText(this.getTitleText());
            title.setFont(SWTUtils.toAwtFont((Device)this.getDisplay(), this.getTitleFont(), true));
            title.setPaint(SWTUtils.toAwtColor(this.getTitleColor()));
        } else {
            chart.setTitle((TextTitle)null);
        }
    }
}

