/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.utils;

import org.eclipse.jface.window.ToolTip;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;

public class HTMLTooltip
extends ToolTip {
    private String text;
    private String backgroundColor = "#FFFF99";
    private String foregroundColor = "#000000";
    private int fontSize = 10;
    private String fontFamily = "sans-serif";
    private int width = 400;
    private int height = 100;

    public HTMLTooltip(Control control, String text) {
        super(control);
        this.text = text;
        this.setShift(new Point(-5, -5));
        this.setHideOnMouseDown(false);
    }

    public HTMLTooltip(Control control, String text, int width, int height) {
        super(control);
        this.text = text;
        this.width = width;
        this.height = height;
        this.setShift(new Point(-5, -5));
        this.setHideOnMouseDown(false);
    }

    public HTMLTooltip(Control control, String text, String backgroundColor, String foregroundColor, String fontFamily, int fontSize, int width, int height) {
        super(control);
        this.text = text;
        this.backgroundColor = backgroundColor;
        this.foregroundColor = foregroundColor;
        this.fontFamily = fontFamily;
        this.fontSize = fontSize;
        this.width = width;
        this.height = height;
        this.setShift(new Point(-5, -5));
        this.setHideOnMouseDown(false);
    }

    public HTMLTooltip(Control control, String text, String backgroundColor, String foregroundColor, String fontFamily, int fontSize) {
        super(control);
        this.text = text;
        this.backgroundColor = backgroundColor;
        this.foregroundColor = foregroundColor;
        this.fontFamily = fontFamily;
        this.fontSize = fontSize;
        this.setShift(new Point(-5, -5));
        this.setHideOnMouseDown(false);
    }

    protected Composite createToolTipContentArea(Event event, Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        Browser browser = new Browser(composite, 0);
        GridData layoutData = new GridData();
        layoutData.widthHint = this.width;
        layoutData.heightHint = this.height;
        browser.setLayoutData((Object)layoutData);
        StringBuilder sbuilder = new StringBuilder();
        sbuilder.append("<html>\n");
        sbuilder.append("<body style='");
        sbuilder.append("background-color:" + this.backgroundColor + ";");
        sbuilder.append("font-family:" + this.fontFamily + ";");
        sbuilder.append("font-size:" + this.fontSize + "pt;");
        sbuilder.append("font-color:" + this.foregroundColor + ";");
        sbuilder.append("'>\n");
        sbuilder.append(this.text + "\n");
        sbuilder.append("</body>\n");
        sbuilder.append("</html>");
        browser.setText(sbuilder.toString());
        return composite;
    }
}

