/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.sequenceTrimmer;

import com.biotechvana.csveditor.model.CSVUtils;
import com.biotechvana.javabiotoolkit.exceptions.FastaReaderNotParsedException;
import com.biotechvana.javabiotoolkit.io.FASTAFileRecord;
import com.biotechvana.javabiotoolkit.io.FASTAReader;
import com.biotechvana.sequenceTrimmer.SequenceTrimmerOperations;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

class SequenceTrimmer2 {
    private File inputFasta;
    private File inputCsv;
    private File outputDir;
    private int hspQueryIndex;
    private int hspHitIndex;
    private float hspQuery = 0.0f;
    private float hspHit = 0.0f;
    private int nameIndex;
    private int queryStartIndex;
    private int queryEndIndex;
    private int queryFrameIndex;
    private boolean verbose = false;
    private boolean negativeFrameAlreadyReversed = false;
    public static final String LABEL_FULL_LENGTH = "Full-length cDNA";
    public static final String LABEL_PARTIAL_SEQUENCE = "Partial sequence";
    public static final int OPTION_1 = 1;
    public static final int OPTION_2 = 2;
    private final int CODON_LENGTH = 3;
    private List<List<String>> csvModel;
    private List<FASTAFileRecord> fastaRecords;
    private RandomAccessFile raf;
    private BufferedWriter writerFasta;
    private BufferedWriter writerCsv;
    private BufferedWriter writerLog;
    private final char SEPARATOR = (char)59;
    private final char DELIMITER = (char)34;
    private NumberFormat decimalFormat = NumberFormat.getInstance();
    private SequenceTrimmerOperations operationFull;
    private SequenceTrimmerOperations operationPartial;
    private final String START_CODON_FORWARD = "ATG";
    private final String START_CODON_REVERSE = "CAT";
    private final String[] END_CODON_FORWARD = new String[]{"TAG", "TAA", "TGA"};
    private final String[] END_CODON_REVERSE = new String[]{"ATC", "TTA", "TCA"};
    private final String NOT_AVAILABLE = "N/A";
    private boolean keepFrame = false;

    public SequenceTrimmer2() {
    }

    public static void main(String[] args) {
        SequenceTrimmer2 trimmer = new SequenceTrimmer2();
        String sequence = "AAGCAGTGGTATCAACGCAGAGTACTTTTTTTTTAACAGAAGTCTGACTCAAGAAATATTCCCAGTGTGGTGTAGAAGCATTTTACAGTCATGGAAAACTCTAAAAAATTGTGCTAAACCTGCTAAACACACCAAACTCAACTTAACTGGAGTAAAATTGCTCTTGAAATATTTATGTCAACAAAATTGTTAAAGAATTTTGAATTTTGAGTCACTTTGGGCCAGTGCAACAAGATGTAATCACAATATTAAAGTACAATAAAATATCTGGCTCTTTACCTGCTAAACGCTCTCTGGGTCTGTCAGTAGTTTGATGCTGGGCAGGCAGCGTACAGTGACTTTATTAAAGCTAGTTGTCTGAAAACAGCTGCCTGCTGCTGCTGGAAACGAGGCTGAGTTATAAAACCAATCAATGCTCTAAACGAGGCTAAAATGCTCCGTAGAGCTGAAGGGAAAAAGTTGGGTGAATTCTTTGTGGGTTTGACCCTATTAGTGCCCCCTTTCCCATTTCACATAATCAATTGGTCCATTGTTAATATAAAAAATTATTTATTAGTGCAGCTTTAAATAGTATCACAATATATCAACTATTGGATGCTGCAATTGAAAATCCTTACTTATGGGTGATAACTTGATGAAAGTCGGCATTAAAAGGCACATCTCACGGTGATCAGTGTACACATGGTGGAAATAACACAAATAATCTGCTTTTTTATACAACTTTCAATTGAGGAAGATTTAGCAGACTCACCACAGACAAGTGTCCGTTCTAGCTTTGGCCACCAGTAGTTCTGATCCGGGCGTGAGTCATATGATCCCATCTTTCCCCTCTCGACCACCTGTAAACTTTATACTGGAGGAGGAACACAGGGATAGTCAGACACATCCTTCTGCTTTTTACCACTTTCTACCTGT";
        System.out.println("Sequence(" + sequence.length() + "):\n" + sequence);
        System.out.println("complement:\n" + trimmer.complementary(sequence));
        int queryStart = 769;
        int queryEnd = 852;
        int queryFrame = -1;
        int sPos = queryStart;
        int ePos = queryEnd;
        if (ePos < sPos) {
            sPos = queryEnd;
            ePos = queryStart;
            System.out.println("invertir");
        }
        String trimmed = "";
        trimmed = queryFrame < 0 ? trimmer.getTrimmedSequenceReverse(sequence, SequenceTrimmerOperations.TRIM_BOTH, sPos, ePos, queryFrame, true) : trimmer.getTrimmedSequenceForward(sequence, SequenceTrimmerOperations.TRIM_BOTH, sPos, ePos, queryFrame, true);
        System.out.println("Trimmed:\n" + trimmed);
    }

    public SequenceTrimmer2(File inputFasta, File inputCsv, File outputDir, int hspQueryIndex, int hspHitIndex, float hspQuery, float hspHit, int nameIndex, int queryStartIndex, int queryEndIndex, int queryFrameIndex, SequenceTrimmerOperations operationFull, SequenceTrimmerOperations operationPartial, boolean negativeAlreadyReversed, boolean keepFrame) {
        this.inputFasta = inputFasta;
        this.inputCsv = inputCsv;
        this.outputDir = outputDir;
        this.hspQueryIndex = hspQueryIndex;
        this.hspHitIndex = hspHitIndex;
        this.hspQuery = hspQuery;
        this.hspHit = hspHit;
        this.nameIndex = nameIndex;
        this.queryStartIndex = queryStartIndex;
        this.queryEndIndex = queryEndIndex;
        this.queryFrameIndex = queryFrameIndex;
        this.operationFull = operationFull;
        this.operationPartial = operationPartial;
        this.negativeFrameAlreadyReversed = negativeAlreadyReversed;
        this.keepFrame = keepFrame;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setNegativeFrameAlreadyReversed(boolean negativeFrameAlreadyReversed) {
        this.negativeFrameAlreadyReversed = negativeFrameAlreadyReversed;
    }

    public boolean validate() throws Exception {
        if (this.inputFasta == null || !this.inputFasta.isFile()) {
            throw new Exception("Invald FASTA file");
        }
        if (this.inputCsv == null || !this.inputCsv.isFile()) {
            throw new Exception("Invalid CSV file");
        }
        if (this.outputDir == null || !this.outputDir.isDirectory()) {
            throw new Exception("Invalid output folder");
        }
        if (this.hspQuery < 0.0f || this.hspQuery > 100.0f) {
            throw new Exception("Invalid hspQuery value");
        }
        if (this.hspHit < 0.0f || this.hspHit > 100.0f) {
            throw new Exception("Invalid hspHit value");
        }
        if (this.nameIndex < 0) {
            throw new Exception("Invalid name column");
        }
        if (this.queryStartIndex < 0) {
            throw new Exception("Invalid query start column");
        }
        if (this.queryEndIndex < 0) {
            throw new Exception("Invalid query end column");
        }
        if (this.queryFrameIndex < 0) {
            throw new Exception("Invalid query frame column");
        }
        if (this.hspQueryIndex < 0) {
            throw new Exception("Invalid HSP/Query column");
        }
        if (this.hspHitIndex < 0) {
            throw new Exception("Invalid HSP/Hit column");
        }
        return true;
    }

    public void run(IProgressMonitor monitor) throws IOException, InterruptedException, CSVUtils.ColumnCountNotDoneException, FastaReaderNotParsedException {
        try {
            monitor.beginTask("Sequence trimmer", 3);
            this.raf = new RandomAccessFile(this.inputFasta, "r");
            this.writerFasta = new BufferedWriter(new FileWriter(new File(this.outputDir, "trimmed.fasta")));
            this.writerCsv = new BufferedWriter(new FileWriter(new File(this.outputDir, "trimmed.csv")));
            this.writerLog = new BufferedWriter(new FileWriter(new File(this.outputDir, "log.csv")));
            if (this.verbose) {
                System.out.println("Parsing CSV file");
            }
            monitor.subTask("Reading worksheet file.");
            this.csvModel = this.parseCsvFile();
            monitor.worked(1);
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            if (this.verbose) {
                System.out.println("Finished Parsing CSV file");
            }
            if (this.verbose) {
                System.out.println("Parsing FASTA file");
            }
            monitor.subTask("Reading FASTA file. This may take a while...");
            this.fastaRecords = this.parseFastaFile();
            monitor.worked(1);
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            if (this.verbose) {
                System.out.println("Finished Parsing FASTA file");
            }
            if (this.verbose) {
                System.out.println("Parsing model");
            }
            monitor.subTask("Parsing data");
            this.scanModel(this.csvModel, this.fastaRecords, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (this.verbose) {
                System.out.println("Finished Parsing model");
            }
        }
        finally {
            this.raf.close();
            this.writerFasta.close();
            this.writerCsv.close();
            this.writerLog.close();
            monitor.done();
        }
    }

    private List<List<String>> parseCsvFile() throws IOException, InterruptedException, CSVUtils.ColumnCountNotDoneException {
        List<List<String>> model;
        String[] headers;
        char separator = CSVUtils.autodetectSeparator(this.inputCsv);
        char delimiter = CSVUtils.autodetectDelimiter(this.inputCsv, separator);
        CSVUtils csvUtils = new CSVUtils(this.inputCsv);
        int columnCount = 0;
        if (delimiter == 'N') {
            csvUtils.parseColumnCount(separator, (IProgressMonitor)new NullProgressMonitor());
            columnCount = csvUtils.getColumnCount();
            headers = csvUtils.getHeaders(separator, columnCount);
            model = csvUtils.getRowsBuffered(columnCount, separator, true, false, (IProgressMonitor)new NullProgressMonitor());
        } else {
            csvUtils.parseColumnCount(separator, delimiter, (IProgressMonitor)new NullProgressMonitor());
            columnCount = csvUtils.getColumnCount();
            headers = csvUtils.getHeaders(separator, delimiter, columnCount);
            model = csvUtils.getRowsBuffered(columnCount, separator, delimiter, true, false, (IProgressMonitor)new NullProgressMonitor());
        }
        String[] stringArray = headers;
        int n = headers.length;
        int n2 = 0;
        while (n2 < n) {
            String h = stringArray[n2];
            this.writerCsv.append("\"" + h.trim() + "\";");
            ++n2;
        }
        this.writerCsv.append("\"Annotation\"");
        this.writerCsv.newLine();
        return model;
    }

    private List<FASTAFileRecord> parseFastaFile() throws FileNotFoundException, IOException, FastaReaderNotParsedException {
        FASTAReader reader = new FASTAReader(this.inputFasta);
        reader.parse();
        List listRecords = reader.getFastaRecords();
        Collections.sort(listRecords, new Comparator<FASTAFileRecord>(){

            @Override
            public int compare(FASTAFileRecord arg0, FASTAFileRecord arg1) {
                return arg0.getDescriptionSB().toString().compareTo(arg1.getDescriptionSB().toString());
            }
        });
        return listRecords;
    }

    private void scanModel(List<List<String>> model, List<FASTAFileRecord> listRecords, IProgressMonitor monitor) throws IOException, InterruptedException {
        monitor.beginTask("Scan model", model.size());
        try {
            this.writerLog.append("\"index\";");
            this.writerLog.append("\"name\";");
            this.writerLog.append("\"ratio1\";");
            this.writerLog.append("\"ratio2\";");
            this.writerLog.append("\"annotation\"");
            this.writerLog.newLine();
            int i = 0;
            while (i < model.size()) {
                List<String> row = model.get(i);
                String lastColumn = "";
                String name = null;
                try {
                    String sequence;
                    name = row.get(this.nameIndex);
                    float hspQueryValue = Float.parseFloat(row.get(this.hspQueryIndex).replace(",", "."));
                    float hspHitValue = Float.parseFloat(row.get(this.hspHitIndex).replace(",", "."));
                    int queryStart = Integer.parseInt(row.get(this.queryStartIndex).replace(",", "."));
                    int queryEnd = Integer.parseInt(row.get(this.queryEndIndex));
                    int queryFrame = Integer.parseInt(row.get(this.queryFrameIndex));
                    if (hspQueryValue >= this.hspQuery && hspHitValue >= this.hspHit) {
                        lastColumn = LABEL_FULL_LENGTH;
                        sequence = this.operationFull.equals((Object)SequenceTrimmerOperations.TRIM_BOTH) || this.operationFull.equals((Object)SequenceTrimmerOperations.TRIM_UPSTREAM) || this.operationFull.equals((Object)SequenceTrimmerOperations.TRIM_DOWNSTREAM) ? this.trimSequence(name, queryStart, queryEnd, queryFrame, this.operationFull, this.keepFrame) : (this.operationFull.equals((Object)SequenceTrimmerOperations.MASK_BOTH) || this.operationFull.equals((Object)SequenceTrimmerOperations.MASK_UPSTREAM) || this.operationFull.equals((Object)SequenceTrimmerOperations.MASK_DOWNSTREAM) ? this.trimSequence(name, queryStart, queryEnd, queryFrame, this.operationFull, this.keepFrame) : (this.operationFull.equals((Object)SequenceTrimmerOperations.CORE_UPPERCASE) ? this.trimSequence(name, queryStart, queryEnd, queryFrame, this.operationFull, this.keepFrame) : this.getFullSequence(name)));
                    } else {
                        lastColumn = LABEL_PARTIAL_SEQUENCE;
                        sequence = this.operationPartial.equals((Object)SequenceTrimmerOperations.TRIM_BOTH) || this.operationPartial.equals((Object)SequenceTrimmerOperations.TRIM_UPSTREAM) || this.operationPartial.equals((Object)SequenceTrimmerOperations.TRIM_DOWNSTREAM) ? this.trimSequence(name, queryStart, queryEnd, queryFrame, this.operationPartial, this.keepFrame) : (this.operationPartial.equals((Object)SequenceTrimmerOperations.MASK_BOTH) || this.operationPartial.equals((Object)SequenceTrimmerOperations.MASK_UPSTREAM) || this.operationPartial.equals((Object)SequenceTrimmerOperations.MASK_DOWNSTREAM) ? this.trimSequence(name, queryStart, queryEnd, queryFrame, this.operationPartial, this.keepFrame) : (this.operationPartial.equals((Object)SequenceTrimmerOperations.CORE_UPPERCASE) ? this.trimSequence(name, queryStart, queryEnd, queryFrame, this.operationPartial, this.keepFrame) : this.getFullSequence(name)));
                    }
                    this.writerFasta.append(">" + name);
                    this.writerFasta.newLine();
                    this.writerFasta.append(sequence.trim());
                    this.writerFasta.newLine();
                    this.writerLog.append("\"" + this.decimalFormat.format(i + 1) + "\";");
                    this.writerLog.append("\"" + name + "\";");
                    this.writerLog.append("\"" + String.valueOf(hspQueryValue) + "\";");
                    this.writerLog.append("\"" + String.valueOf(hspHitValue) + "\";");
                    this.writerLog.append("\"" + lastColumn + "\"");
                    this.writerLog.newLine();
                }
                catch (Exception ex) {
                    lastColumn = "N/A";
                    try {
                        if (name != null) {
                            String sequence = this.getFullSequence(name);
                            this.writerFasta.append(">" + name);
                            this.writerFasta.newLine();
                            this.writerFasta.append(sequence.trim());
                            this.writerFasta.newLine();
                        } else {
                            this.writerLog.append("Error: cannot export sequence '" + name + "'");
                        }
                    }
                    catch (Exception e) {
                        this.writerLog.append("Error: cannot export sequence '" + name + "'");
                    }
                }
                for (String field : row) {
                    this.writerCsv.append("\"" + field + "\";");
                }
                this.writerCsv.append("\"" + lastColumn + "\"");
                this.writerCsv.newLine();
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean hasStartAndStop(String sequence, int queryFrame) {
        if (queryFrame > 0 || queryFrame < 0 && this.negativeFrameAlreadyReversed) {
            String startCodon = sequence.substring(0, 3);
            String endCodon = sequence.substring(sequence.length() - 3);
            if (!startCodon.equalsIgnoreCase("ATG")) return false;
            boolean found = false;
            String[] stringArray = this.END_CODON_FORWARD;
            int n = this.END_CODON_FORWARD.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (s.equalsIgnoreCase(endCodon)) {
                    found = true;
                }
                ++n2;
            }
            if (found) return true;
            return false;
        }
        String startCodon = sequence.substring(sequence.length() - 3);
        String endCodon = sequence.substring(0, 3);
        if (!startCodon.equalsIgnoreCase("CAT")) return false;
        boolean found = false;
        String[] stringArray = this.END_CODON_REVERSE;
        int n = this.END_CODON_REVERSE.length;
        int n3 = 0;
        while (n3 < n) {
            String s = stringArray[n3];
            if (s.equalsIgnoreCase(endCodon)) {
                found = true;
            }
            ++n3;
        }
        if (found) return true;
        return false;
    }

    private String getFullSequence(String sequenceName) throws Exception {
        int res = Collections.binarySearch(this.fastaRecords, sequenceName, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                String recordName = ((FASTAFileRecord)o1).getDescriptionSB().toString();
                String name = (String)o2;
                return recordName.compareTo(name);
            }
        });
        if (res >= 0) {
            FASTAFileRecord ffr = this.fastaRecords.get(res);
            this.raf.seek(ffr.sequenceOffset());
            byte[] buffer = new byte[(int)ffr.sequenceBytes()];
            int readBytes = this.raf.read(buffer);
            return new String(buffer).replaceAll("\\r|\\n", "");
        }
        throw new Exception("Sequennce not found");
    }

    private String clipSequence(String name, int queryStart, int queryEnd, int queryFrame, SequenceTrimmerOperations clipMode) throws Exception {
        String sequence = this.getFullSequence(name);
        if (this.negativeFrameAlreadyReversed) {
            sequence = this.reverseComplementary(sequence);
        }
        if (--queryStart > --queryEnd) {
            int tmp = queryStart;
            queryStart = queryEnd;
            queryEnd = tmp;
        }
        try {
            if (clipMode.equals((Object)SequenceTrimmerOperations.CLIP_BOTH)) {
                sequence = sequence.substring(queryStart, queryEnd);
            } else if (clipMode.equals((Object)SequenceTrimmerOperations.CLIP_DOWNSTREAM)) {
                sequence = sequence.substring(0, queryEnd);
            } else if (clipMode.equals((Object)SequenceTrimmerOperations.CLIP_UPSTREAM)) {
                sequence = sequence.substring(queryStart);
            }
        }
        catch (Exception ex) {
            if (this.negativeFrameAlreadyReversed) {
                return this.reverseComplementary(sequence);
            }
            return sequence;
        }
        if (this.negativeFrameAlreadyReversed) {
            return this.reverseComplementary(sequence);
        }
        return sequence;
    }

    private String maskSequence(String name, int queryStart, int queryEnd, int queryFrame, SequenceTrimmerOperations maskMode) throws Exception {
        String sequence = this.getFullSequence(name);
        if (this.negativeFrameAlreadyReversed) {
            sequence = this.reverseComplementary(sequence);
        }
        if (--queryStart > --queryEnd) {
            int tmp = queryStart;
            queryStart = queryEnd;
            queryEnd = tmp;
        }
        try {
            if (maskMode.equals((Object)SequenceTrimmerOperations.MASK_BOTH)) {
                StringBuilder builder = new StringBuilder();
                builder.append(this.fillForMasking('X', queryStart));
                builder.append(sequence.substring(queryStart, queryEnd));
                builder.append(this.fillForMasking('X', sequence.length() - queryEnd));
                sequence = builder.toString();
            } else if (maskMode.equals((Object)SequenceTrimmerOperations.MASK_DOWNSTREAM)) {
                StringBuilder builder = new StringBuilder();
                builder.append(sequence.substring(0, queryEnd));
                builder.append(this.fillForMasking('X', sequence.length() - queryEnd));
                sequence = builder.toString();
            } else if (maskMode.equals((Object)SequenceTrimmerOperations.MASK_UPSTREAM)) {
                StringBuilder builder = new StringBuilder();
                builder.append(this.fillForMasking('X', queryStart));
                builder.append(sequence.substring(queryStart));
                sequence = builder.toString();
            }
        }
        catch (Exception ex) {
            if (this.negativeFrameAlreadyReversed) {
                return this.reverseComplementary(sequence);
            }
            return sequence;
        }
        if (this.negativeFrameAlreadyReversed) {
            return this.reverseComplementary(sequence);
        }
        return sequence;
    }

    private String uppercaseCoreSequence(String name, int queryStart, int queryEnd, int queryFrame, SequenceTrimmerOperations maskMode) throws Exception {
        String sequence = this.getFullSequence(name);
        if (this.negativeFrameAlreadyReversed) {
            sequence = this.reverseComplementary(sequence);
        }
        if (--queryStart > --queryEnd) {
            int tmp = queryStart;
            queryStart = queryEnd;
            queryEnd = tmp;
        }
        try {
            StringBuilder builder = new StringBuilder();
            builder.append(sequence.substring(0, queryStart).toLowerCase());
            builder.append(sequence.substring(queryStart, queryEnd).toUpperCase());
            builder.append(sequence.substring(queryEnd).toLowerCase());
            sequence = builder.toString();
        }
        catch (Exception ex) {
            if (this.negativeFrameAlreadyReversed) {
                return this.reverseComplementary(sequence);
            }
            return sequence;
        }
        if (this.negativeFrameAlreadyReversed) {
            return this.reverseComplementary(sequence);
        }
        return sequence;
    }

    private String fillForMasking(char fillChar, int len) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < len) {
            builder.append(fillChar);
            ++i;
        }
        return builder.toString();
    }

    private String trimSequence(String sequenceName, int queryStart, int queryEnd, int queryFrame, SequenceTrimmerOperations trimMode, boolean keepFrame) throws Exception {
        int res = Collections.binarySearch(this.fastaRecords, sequenceName, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                String recordName = ((FASTAFileRecord)o1).getDescriptionSB().toString();
                String name = (String)o2;
                return recordName.compareTo(name);
            }
        });
        if (res >= 0) {
            FASTAFileRecord ffr = this.fastaRecords.get(res);
            this.raf.seek(ffr.sequenceOffset());
            byte[] buffer = new byte[(int)ffr.sequenceBytes()];
            int readBytes = this.raf.read(buffer);
            if (trimMode.equals((Object)SequenceTrimmerOperations.NONE)) {
                return new String(buffer);
            }
            if (readBytes != -1) {
                String sequence = new String(buffer).replaceAll("\\r|\\n", "").toUpperCase();
                int ePos = queryEnd;
                int sPos = queryStart;
                if (ePos < sPos) {
                    sPos = sequence.length() - ePos + 1;
                    ePos = sequence.length() - sPos + 1;
                }
                if (queryFrame < 0) {
                    sequence = this.reverseComplementary(sequence);
                    return this.reverseComplementary(this.getTrimmedSequenceForward(sequence, trimMode, sPos, ePos, Math.abs(queryFrame), keepFrame));
                }
                return this.getTrimmedSequenceForward(sequence, trimMode, sPos, ePos, queryFrame, keepFrame);
            }
        } else {
            throw new Exception("Sequennce not found");
        }
        return null;
    }

    public String getTrimmedSequenceForward(String sequence, SequenceTrimmerOperations operation, int startIndex, int endIndex, int queryFrame, boolean keepFrame) {
        List<Integer> listStartIndices = this.getStartCodonsForward(sequence, startIndex);
        List<Integer> listEndIndices = this.getEndCodonsForward(sequence, startIndex);
        int start = 0;
        int end = sequence.length();
        boolean endFound = false;
        boolean startFound = false;
        boolean startingEndFound = false;
        int startingEnd = this.getStartingEnd(listEndIndices, startIndex);
        if (listEndIndices.size() > 0) {
            int eIndex = 0;
            int ePos = listEndIndices.get(eIndex);
            while (eIndex < listEndIndices.size() - 1 && ePos < endIndex) {
                ePos = listEndIndices.get(++eIndex);
            }
            if (ePos >= endIndex) {
                endFound = true;
                end = ePos;
            }
        }
        if (listStartIndices.size() > 0) {
            int sIndex = 0;
            int sPos = listStartIndices.get(sIndex);
            while (sIndex < listStartIndices.size() && sPos > startIndex) {
                sPos = listStartIndices.get(++sIndex);
            }
            if (sPos <= startIndex) {
                startFound = true;
                start = sPos;
            }
            if (!startFound) {
                if (startingEnd != -1) {
                    start = startingEnd;
                    startingEndFound = true;
                }
            } else if (startingEnd != -1 && startingEnd > sPos && startingEnd <= startIndex) {
                start = startingEnd;
                startFound = false;
                startingEndFound = true;
            }
        } else if (startingEnd != -1) {
            start = startingEnd;
            startingEndFound = true;
        }
        if (keepFrame && !startFound && !startingEndFound) {
            if (queryFrame == 2) {
                start = start > 0 ? --start : ++start;
            } else if (queryFrame == 3) {
                start = start > 1 ? (start -= 2) : (start += 2);
            }
        }
        if (operation.equals((Object)SequenceTrimmerOperations.TRIM_BOTH)) {
            return sequence.substring(start, end);
        }
        if (operation.equals((Object)SequenceTrimmerOperations.TRIM_UPSTREAM)) {
            return sequence.substring(start);
        }
        if (operation.equals((Object)SequenceTrimmerOperations.TRIM_DOWNSTREAM)) {
            return sequence.substring(0, end);
        }
        if (operation.equals((Object)SequenceTrimmerOperations.MASK_BOTH)) {
            return this.fillForMasking('X', start) + sequence.substring(start, end) + this.fillForMasking('X', sequence.length() - end);
        }
        if (operation.equals((Object)SequenceTrimmerOperations.MASK_UPSTREAM)) {
            return this.fillForMasking('X', start) + sequence.substring(start, end) + sequence.substring(end);
        }
        if (operation.equals((Object)SequenceTrimmerOperations.MASK_DOWNSTREAM)) {
            return sequence.substring(start, end) + this.fillForMasking('X', sequence.length() - end);
        }
        if (operation.equals((Object)SequenceTrimmerOperations.CORE_UPPERCASE)) {
            return sequence.substring(0, start).toLowerCase() + sequence.substring(start, end).toUpperCase() + sequence.substring(end).toLowerCase();
        }
        return sequence.substring(start, end);
    }

    public String getTrimmedSequenceReverse(String sequence, SequenceTrimmerOperations trimMode, int startIndex, int endIndex, int queryFrame, boolean keepFrame) {
        List<Integer> listStartIndices = this.getStartCodonsReverse(sequence, startIndex);
        List<Integer> listEndIndices = this.getEndCodonsReverse(sequence, startIndex);
        int start = 0;
        int end = sequence.length();
        boolean endFound = false;
        boolean startFound = false;
        boolean startingEndFound = false;
        int startingEnd = this.getStartingEnd(listEndIndices, startIndex);
        if (listEndIndices.size() > 0) {
            int eIndex = 0;
            int ePos = listEndIndices.get(eIndex);
            while (eIndex < listEndIndices.size() - 1 && ePos < endIndex) {
                ePos = listEndIndices.get(++eIndex);
            }
            if (ePos >= endIndex) {
                endFound = true;
                end = ePos;
            }
        }
        if (listStartIndices.size() > 0) {
            int sIndex = 0;
            int sPos = listStartIndices.get(sIndex);
            while (sIndex < listStartIndices.size() && sPos > startIndex) {
                sPos = listStartIndices.get(++sIndex);
            }
            if (sPos <= startIndex) {
                startFound = true;
                start = sPos;
            }
            if (!startFound) {
                if (startingEnd != -1) {
                    start = startingEnd;
                    startingEndFound = true;
                }
            } else if (startingEnd != -1 && startingEnd > sPos && startingEnd <= startIndex) {
                start = startingEnd;
                startFound = false;
                startingEndFound = true;
            }
        } else if (startingEnd != -1) {
            start = startingEnd;
            startingEndFound = true;
        }
        if (keepFrame && !startFound && !startingEndFound) {
            if (queryFrame == 2) {
                start = start > 0 ? --start : ++start;
            } else if (queryFrame == 3) {
                start = start > 1 ? (start -= 2) : (start += 2);
            }
        }
        return sequence.substring(start, end);
    }

    private int getStartingEnd(List<Integer> listEndIndices, int startIndex) {
        int firstEnd = -1;
        Collections.sort(listEndIndices);
        if (listEndIndices.size() > 0) {
            int eIndex = listEndIndices.size() - 1;
            int ePos = listEndIndices.get(eIndex);
            while (eIndex > 0 && ePos > startIndex) {
                ePos = listEndIndices.get(--eIndex);
            }
            if (ePos <= startIndex) {
                firstEnd = ePos + 3;
            }
        }
        return firstEnd;
    }

    public List<Integer> getStartCodonsForward(String sequence, int qStart) {
        ArrayList<Integer> listStartIndices = new ArrayList<Integer>();
        int i = qStart - 1;
        while (i >= 0) {
            if (!(sequence.charAt(i) != 'A' && sequence.charAt(i) != 'a' || sequence.charAt(i + 1) != 'T' && sequence.charAt(i + 1) != 't' || sequence.charAt(i + 2) != 'G' && sequence.charAt(i + 2) != 'g')) {
                listStartIndices.add(i);
            }
            i -= 3;
        }
        return listStartIndices;
    }

    public List<Integer> getStartCodonsReverse(String sequence, int qStart) {
        ArrayList<Integer> listStartIndices = new ArrayList<Integer>();
        int i = qStart - 1;
        while (i >= 0) {
            if (!(sequence.charAt(i) != 'C' && sequence.charAt(i) != 'c' || sequence.charAt(i + 1) != 'A' && sequence.charAt(i + 1) != 'a' || sequence.charAt(i + 2) != 'T' && sequence.charAt(i + 2) != 't')) {
                listStartIndices.add(i);
            }
            i -= 3;
        }
        return listStartIndices;
    }

    public List<Integer> getEndCodonsForward(String sequence, int qStart) {
        int shift;
        ArrayList<Integer> listStartIndices = new ArrayList<Integer>();
        int i = shift = (qStart - 1) % 3;
        while (i < sequence.length() - 2) {
            if (sequence.charAt(i) == 'T' || sequence.charAt(i) == 't') {
                if (sequence.charAt(i + 1) == 'A' || sequence.charAt(i + 1) == 'a') {
                    if (sequence.charAt(i + 2) == 'G' || sequence.charAt(i + 2) == 'g' || sequence.charAt(i + 2) == 'A' || sequence.charAt(i + 2) == 'a') {
                        listStartIndices.add(i);
                    }
                } else if (!(sequence.charAt(i + 1) != 'G' && sequence.charAt(i + 1) != 'g' || sequence.charAt(i + 2) != 'A' && sequence.charAt(i + 2) != 'a')) {
                    listStartIndices.add(i);
                }
            }
            i += 3;
        }
        return listStartIndices;
    }

    public List<Integer> getEndCodonsReverse(String sequence, int qStart) {
        ArrayList<Integer> listStartIndices = new ArrayList<Integer>();
        int shift = (qStart - 1) % 3;
        int i = 0 + shift;
        while (i < sequence.length() - 3) {
            if (sequence.charAt(i) == 'T' || sequence.charAt(i) == 't') {
                if (sequence.charAt(i + 1) == 'T' || sequence.charAt(i + 1) == 't') {
                    if (sequence.charAt(i + 2) == 'A' || sequence.charAt(i + 2) == 'a') {
                        listStartIndices.add(i);
                    }
                } else if (!(sequence.charAt(i + 1) != 'C' && sequence.charAt(i + 1) != 'c' || sequence.charAt(i + 2) != 'A' && sequence.charAt(i + 2) != 'a')) {
                    listStartIndices.add(i);
                }
            } else if (!(sequence.charAt(i) != 'C' && sequence.charAt(i) != 'c' || sequence.charAt(i + 1) != 'T' && sequence.charAt(i + 1) != 't' || sequence.charAt(i + 2) != 'A' && sequence.charAt(i + 2) != 'a')) {
                listStartIndices.add(i);
            }
            i += 3;
        }
        Collections.sort(listStartIndices);
        return listStartIndices;
    }

    public void calculateIndices(String sequence, int frame) throws IOException {
        int startPos = sequence.length() - 1;
        if (frame == -2) {
            startPos = sequence.length() - 2;
        } else if (frame == -3) {
            startPos = sequence.length() - 3;
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(new File("/home/rfutami/Escritorio/indices.txt")));){
            int i = startPos;
            while (i >= 0) {
                writer.append(String.valueOf(i - 1));
                writer.newLine();
                i -= 3;
            }
        }
    }

    public String reverseComplementary(String sequence) {
        StringBuilder builder = new StringBuilder();
        int i = sequence.length() - 1;
        while (i >= 0) {
            char c = sequence.charAt(i);
            switch (c) {
                case 'a': {
                    builder.append('t');
                    break;
                }
                case 'A': {
                    builder.append('T');
                    break;
                }
                case 't': {
                    builder.append('a');
                    break;
                }
                case 'T': {
                    builder.append('A');
                    break;
                }
                case 'g': {
                    builder.append('c');
                    break;
                }
                case 'G': {
                    builder.append('C');
                    break;
                }
                case 'c': {
                    builder.append('g');
                    break;
                }
                case 'C': {
                    builder.append('G');
                    break;
                }
                case 'n': {
                    builder.append('n');
                    break;
                }
                case 'N': {
                    builder.append('N');
                    break;
                }
                case '-': {
                    builder.append('-');
                    break;
                }
                default: {
                    builder.append(c);
                }
            }
            --i;
        }
        return builder.toString();
    }

    public String complementary(String sequence) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < sequence.length()) {
            char c = sequence.charAt(i);
            switch (c) {
                case 'a': {
                    builder.append('t');
                    break;
                }
                case 'A': {
                    builder.append('T');
                    break;
                }
                case 't': {
                    builder.append('a');
                    break;
                }
                case 'T': {
                    builder.append('A');
                    break;
                }
                case 'g': {
                    builder.append('c');
                    break;
                }
                case 'G': {
                    builder.append('C');
                    break;
                }
                case 'c': {
                    builder.append('g');
                    break;
                }
                case 'C': {
                    builder.append('G');
                    break;
                }
                case 'n': {
                    builder.append('n');
                    break;
                }
                case 'N': {
                    builder.append('N');
                    break;
                }
                case '-': {
                    builder.append('-');
                    break;
                }
                default: {
                    builder.append(c);
                }
            }
            ++i;
        }
        return builder.toString();
    }
}

