/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.metabolicPathEditor.main;

import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.views.MetabolicPathsView;
import com.biotechvana.metabolicPathEditor.data.EnzymePathway;
import com.biotechvana.metabolicPathEditor.data.MetabolicGenerateDataset;
import com.biotechvana.metabolicPathEditor.data.SequenceEnzyme;
import com.biotechvana.metabolicPathEditor.main.CompositeForm;
import com.biotechvana.metabolicPathEditor.main.CompositeMenu;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class MetabolicPathMainComposite
extends Composite {
    private CompositeForm compositeForm;
    public static final int COLOR_EVIDENCE = 1;
    public static final int COLOR_ANNOTATION = 2;
    private int colorMode = 1;
    private CSVEditor csvEditor;
    private int sequenceColumnIndex;
    private int enzymeCodeColumnIndex;
    private int evidenceColumnIndex;
    private int speciesColumnIndex;
    private List<SequenceEnzyme> listEnzymes;

    public MetabolicPathMainComposite(Composite parent, CSVEditor csvEditor, int sequenceColumnIndex, int enzymeCodeColumnIndex, int evidenceColumnIndex, int speciesColumnIndex, int colorMode) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout(1, true));
        this.csvEditor = csvEditor;
        this.sequenceColumnIndex = sequenceColumnIndex;
        this.enzymeCodeColumnIndex = enzymeCodeColumnIndex;
        this.evidenceColumnIndex = evidenceColumnIndex;
        this.speciesColumnIndex = speciesColumnIndex;
        CompositeMenu compositeMenu = new CompositeMenu(this, 0);
        GridData layoutData = new GridData();
        compositeMenu.setLayoutData(layoutData);
        this.compositeForm = new CompositeForm(this, 0, MetabolicPathsView.getWorkspaceDirectory(), colorMode);
        layoutData = new GridData(1808);
        this.compositeForm.setLayoutData(layoutData);
    }

    public CompositeForm getCompositeForm() {
        return this.compositeForm;
    }

    public void setData() throws InvocationTargetException {
        File projectFolder = new File(this.getProjectPath());
        if (!projectFolder.exists() && !projectFolder.mkdir()) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Metabolic Paths", (String)("Cannot create project folder: " + projectFolder.getAbsolutePath()));
        }
        try {
            MetabolicGenerateDataset datasetRunnable = new MetabolicGenerateDataset(this.csvEditor, this.sequenceColumnIndex, this.enzymeCodeColumnIndex, this.evidenceColumnIndex, this.speciesColumnIndex);
            datasetRunnable.generateDataset();
            this.listEnzymes = datasetRunnable.getListSequenceEnzyme();
            if (this.listEnzymes == null || this.listEnzymes.size() == 0) {
                throw new InvocationTargetException(new NullPointerException("No valid pathways found"), "No valid pathways found");
            }
            this.compositeForm.getCompositePathway().setModel(this.listEnzymes, this.colorMode);
        }
        catch (MetabolicGenerateDataset.MetabolicDatasetNotParsed e) {
            throw new InvocationTargetException(e, "No valid pathways found");
        }
    }

    public int getSequenceColumnIndex() {
        return this.sequenceColumnIndex;
    }

    public int getEnzymeCodeColumnIndex() {
        return this.enzymeCodeColumnIndex;
    }

    public int getEvidenceColumnIndex() {
        return this.evidenceColumnIndex;
    }

    public int getSpeciesColumnIndex() {
        return this.speciesColumnIndex;
    }

    public CSVEditor getCsvEditor() {
        return this.csvEditor;
    }

    public String getProjectName() {
        return this.csvEditor.getTitle().replaceAll(".csv", "") + "_" + DigestUtils.md5Hex((String)(this.csvEditor.getCsvFile().getAbsolutePath() + this.getUniqeOptionString()));
    }

    private String getUniqeOptionString() {
        return "" + 1000 * this.sequenceColumnIndex + 1000 * this.enzymeCodeColumnIndex + 1000 * this.evidenceColumnIndex + 1000 * this.speciesColumnIndex;
    }

    public String getProjectPath() {
        return MetabolicPathsView.getWorkspaceDirectory().getAbsolutePath() + File.separator + "Metabolic_pathways" + File.separator + this.getProjectName();
    }

    public List<SequenceEnzyme> getListEnzymes() {
        return this.listEnzymes;
    }

    public Collection<EnzymePathway> getMapNameList() {
        return this.compositeForm.getCompositePathway().getModel();
    }

    public void setColorMode(int colorMode) {
        this.colorMode = colorMode != 1 && colorMode != 2 ? 1 : colorMode;
    }

    public int getColorMode() {
        return this.colorMode;
    }
}

