/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.metabolicPathEditor.main;

import com.biotechvana.metabolicPathEditor.main.CompositePathway;
import com.biotechvana.metabolicPathEditor.main.MetabolicKeyListener;
import com.biotechvana.utils.PreferenceManager;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EcWeightDialog
extends TitleAreaDialog {
    private Text textEXP;
    private Text textIDA;
    private Text textIPI;
    private Text textIMP;
    private Text textIGI;
    private Text textIEP;
    private Text textISS;
    private Text textISO;
    private Text textISA;
    private Text textISM;
    private Text textIGC;
    private Text textRCA;
    private Text textTAS;
    private Text textNAS;
    private Text textIC;
    private Text textND;
    private Text textIEA;
    private Text textNR;
    private Text textIBA;
    private final int TEXT_WIDTH = 150;

    public EcWeightDialog(Shell parentShell) {
        super(parentShell);
    }

    public void create() {
        super.create();
        this.setTitle("Evidence code weights");
        this.setMessage("Set custom values for evidence code weights");
    }

    protected Control createDialogArea(Composite parent) {
        Composite compositeParent = (Composite)super.createDialogArea(parent);
        this.getShell().setText("Evidence code weights");
        compositeParent.setLayoutData((Object)new GridData(1808));
        Composite composite = new Composite(compositeParent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label labelEXP = new Label(composite, 0);
        labelEXP.setText("EXP");
        this.textEXP = new Text(composite, 2112);
        this.textEXP.setText(CompositePathway.MAP_WEIGHTS.get("EXP").toString());
        GridData layoutData = new GridData();
        layoutData.widthHint = 150;
        this.textEXP.setLayoutData((Object)layoutData);
        Label labelIDA = new Label(composite, 0);
        labelIDA.setText("IDA");
        this.textIDA = new Text(composite, 2112);
        this.textIDA.setText(CompositePathway.MAP_WEIGHTS.get("IDA").toString());
        layoutData = new GridData();
        layoutData.widthHint = 150;
        this.textIDA.setLayoutData((Object)layoutData);
        Label labelIPI = new Label(composite, 0);
        labelIPI.setText("IDA");
        this.textIPI = new Text(composite, 2112);
        this.textIPI.setText(CompositePathway.MAP_WEIGHTS.get("IPI").toString());
        layoutData = new GridData();
        layoutData.widthHint = 150;
        this.textIPI.setLayoutData((Object)layoutData);
        Label labelIMP = new Label(composite, 0);
        labelIMP.setText("IMP");
        this.textIMP = new Text(composite, 2112);
        this.textIMP.setText(CompositePathway.MAP_WEIGHTS.get("IMP").toString());
        layoutData = new GridData();
        layoutData.widthHint = 150;
        this.textIMP.setLayoutData((Object)layoutData);
        Label labelIGI = new Label(composite, 0);
        labelIGI.setText("IGI");
        this.textIGI = new Text(composite, 2112);
        this.textIGI.setText(CompositePathway.MAP_WEIGHTS.get("IGI").toString());
        layoutData = new GridData();
        layoutData.widthHint = 150;
        this.textIGI.setLayoutData((Object)layoutData);
        Label labelIEP = new Label(composite, 0);
        labelIEP.setText("IEP");
        this.textIEP = new Text(composite, 2112);
        this.textIEP.setText(CompositePathway.MAP_WEIGHTS.get("IEP").toString());
        layoutData = new GridData();
        layoutData.widthHint = 150;
        this.textIEP.setLayoutData((Object)layoutData);
        Label labelISS = new Label(composite, 0);
        labelISS.setText("ISS");
        this.textISS = new Text(composite, 2112);
        this.textISS.setText(CompositePathway.MAP_WEIGHTS.get("ISS").toString());
        layoutData = new GridData();
        layoutData.widthHint = 150;
        this.textISS.setLayoutData((Object)layoutData);
        Label labelISO = new Label(composite, 0);
        labelISO.setText("ISO");
        this.textISO = new Text(composite, 2112);
        this.textISO.setText(CompositePathway.MAP_WEIGHTS.get("ISO").toString());
        layoutData = new GridData();
        layoutData.widthHint = 150;
        this.textISO.setLayoutData((Object)layoutData);
        Label labelISA = new Label(composite, 0);
        labelISA.setText("ISA");
        this.textISA = new Text(composite, 2112);
        this.textISA.setText(CompositePathway.MAP_WEIGHTS.get("ISA").toString());
        layoutData = new GridData();
        layoutData.widthHint = 150;
        this.textISA.setLayoutData((Object)layoutData);
        Label labelISM = new Label(composite, 0);
        labelISM.setText("ISM");
        this.textISM = new Text(composite, 2112);
        this.textISM.setText(CompositePathway.MAP_WEIGHTS.get("ISM").toString());
        layoutData = new GridData();
        layoutData.widthHint = 150;
        this.textISM.setLayoutData((Object)layoutData);
        Label labelIGC = new Label(composite, 0);
        labelIGC.setText("IGC");
        this.textIGC = new Text(composite, 2112);
        this.textIGC.setText(CompositePathway.MAP_WEIGHTS.get("IGC").toString());
        layoutData = new GridData();
        layoutData.widthHint = 150;
        this.textIGC.setLayoutData((Object)layoutData);
        Label labelRCA = new Label(composite, 0);
        labelRCA.setText("RCA");
        this.textRCA = new Text(composite, 2112);
        this.textRCA.setText(CompositePathway.MAP_WEIGHTS.get("RCA").toString());
        layoutData = new GridData();
        layoutData.widthHint = 150;
        this.textRCA.setLayoutData((Object)layoutData);
        Label labelTAS = new Label(composite, 0);
        labelTAS.setText("TAS");
        this.textTAS = new Text(composite, 2112);
        this.textTAS.setText(CompositePathway.MAP_WEIGHTS.get("TAS").toString());
        layoutData = new GridData();
        layoutData.widthHint = 150;
        this.textTAS.setLayoutData((Object)layoutData);
        Label labelNAS = new Label(composite, 0);
        labelNAS.setText("NAS");
        this.textNAS = new Text(composite, 2112);
        this.textNAS.setText(CompositePathway.MAP_WEIGHTS.get("NAS").toString());
        layoutData = new GridData();
        layoutData.widthHint = 150;
        this.textNAS.setLayoutData((Object)layoutData);
        Label labelIC = new Label(composite, 0);
        labelIC.setText("IC");
        this.textIC = new Text(composite, 2112);
        this.textIC.setText(CompositePathway.MAP_WEIGHTS.get("IC").toString());
        layoutData = new GridData();
        layoutData.widthHint = 150;
        this.textIC.setLayoutData((Object)layoutData);
        Label labelND = new Label(composite, 0);
        labelND.setText("ND");
        this.textND = new Text(composite, 2112);
        this.textND.setText(CompositePathway.MAP_WEIGHTS.get("ND").toString());
        layoutData = new GridData();
        layoutData.widthHint = 150;
        this.textND.setLayoutData((Object)layoutData);
        Label labelIEA = new Label(composite, 0);
        labelIEA.setText("IEA");
        this.textIEA = new Text(composite, 2112);
        this.textIEA.setText(CompositePathway.MAP_WEIGHTS.get("IEA").toString());
        layoutData = new GridData();
        layoutData.widthHint = 150;
        this.textIEA.setLayoutData((Object)layoutData);
        Label labelNR = new Label(composite, 0);
        labelNR.setText("NR");
        this.textNR = new Text(composite, 2112);
        this.textNR.setText(CompositePathway.MAP_WEIGHTS.get("NR").toString());
        layoutData = new GridData();
        layoutData.widthHint = 150;
        this.textNR.setLayoutData((Object)layoutData);
        Label labelIBA = new Label(composite, 0);
        labelIBA.setText("IBA");
        this.textIBA = new Text(composite, 2112);
        this.textIBA.setText(CompositePathway.MAP_WEIGHTS.get("IBA").toString());
        layoutData = new GridData();
        layoutData.widthHint = 150;
        this.textIBA.setLayoutData((Object)layoutData);
        this.loadPreferences();
        this.addListeners();
        return compositeParent;
    }

    private void addListeners() {
        Text[] arrayValues;
        Text[] textArray = arrayValues = new Text[]{this.textEXP, this.textIDA, this.textIPI, this.textIMP, this.textIGI, this.textIEP, this.textISS, this.textISO, this.textISA, this.textISM, this.textIGC, this.textRCA, this.textTAS, this.textNAS, this.textIC, this.textND, this.textIEA, this.textNR, this.textIBA};
        int n = arrayValues.length;
        int n2 = 0;
        while (n2 < n) {
            Text t = textArray[n2];
            t.addVerifyListener((VerifyListener)new MetabolicKeyListener(t));
            ++n2;
        }
    }

    protected void okPressed() {
        this.run();
        this.close();
    }

    private void run() {
        CompositePathway.MAP_WEIGHTS.put("EXP", Float.valueOf(Float.parseFloat(this.textEXP.getText())));
        CompositePathway.MAP_WEIGHTS.put("IDA", Float.valueOf(Float.parseFloat(this.textIDA.getText())));
        CompositePathway.MAP_WEIGHTS.put("IPI", Float.valueOf(Float.parseFloat(this.textIPI.getText())));
        CompositePathway.MAP_WEIGHTS.put("IMP", Float.valueOf(Float.parseFloat(this.textIMP.getText())));
        CompositePathway.MAP_WEIGHTS.put("IGI", Float.valueOf(Float.parseFloat(this.textIGI.getText())));
        CompositePathway.MAP_WEIGHTS.put("IEP", Float.valueOf(Float.parseFloat(this.textIEP.getText())));
        CompositePathway.MAP_WEIGHTS.put("ISS", Float.valueOf(Float.parseFloat(this.textISS.getText())));
        CompositePathway.MAP_WEIGHTS.put("ISO", Float.valueOf(Float.parseFloat(this.textISO.getText())));
        CompositePathway.MAP_WEIGHTS.put("ISA", Float.valueOf(Float.parseFloat(this.textISA.getText())));
        CompositePathway.MAP_WEIGHTS.put("ISM", Float.valueOf(Float.parseFloat(this.textISM.getText())));
        CompositePathway.MAP_WEIGHTS.put("IGC", Float.valueOf(Float.parseFloat(this.textIGC.getText())));
        CompositePathway.MAP_WEIGHTS.put("RCA", Float.valueOf(Float.parseFloat(this.textRCA.getText())));
        CompositePathway.MAP_WEIGHTS.put("TAS", Float.valueOf(Float.parseFloat(this.textTAS.getText())));
        CompositePathway.MAP_WEIGHTS.put("NAS", Float.valueOf(Float.parseFloat(this.textNAS.getText())));
        CompositePathway.MAP_WEIGHTS.put("IC", Float.valueOf(Float.parseFloat(this.textIC.getText())));
        CompositePathway.MAP_WEIGHTS.put("ND", Float.valueOf(Float.parseFloat(this.textND.getText())));
        CompositePathway.MAP_WEIGHTS.put("IEA", Float.valueOf(Float.parseFloat(this.textIEA.getText())));
        CompositePathway.MAP_WEIGHTS.put("NR", Float.valueOf(Float.parseFloat(this.textNR.getText())));
        CompositePathway.MAP_WEIGHTS.put("IBA", Float.valueOf(Float.parseFloat(this.textIBA.getText())));
        this.savePreferences();
    }

    private void savePreferences() {
        try {
            if (Float.parseFloat(this.textEXP.getText()) >= 0.0f && Float.parseFloat(this.textEXP.getText()) <= 1.0f) {
                PreferenceManager.getInstance().put("EC_EXP", this.textEXP.getText());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (Float.parseFloat(this.textIDA.getText()) >= 0.0f && Float.parseFloat(this.textIDA.getText()) <= 1.0f) {
                PreferenceManager.getInstance().put("EC_IDA", this.textIDA.getText());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (Float.parseFloat(this.textIPI.getText()) >= 0.0f && Float.parseFloat(this.textIPI.getText()) <= 1.0f) {
                PreferenceManager.getInstance().put("EC_IPI", this.textIPI.getText());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (Float.parseFloat(this.textIMP.getText()) >= 0.0f && Float.parseFloat(this.textIMP.getText()) <= 1.0f) {
                PreferenceManager.getInstance().put("EC_IMP", this.textIMP.getText());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (Float.parseFloat(this.textIGI.getText()) >= 0.0f && Float.parseFloat(this.textIGI.getText()) <= 1.0f) {
                PreferenceManager.getInstance().put("EC_IGI", this.textIGI.getText());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (Float.parseFloat(this.textIEP.getText()) >= 0.0f && Float.parseFloat(this.textIEP.getText()) <= 1.0f) {
                PreferenceManager.getInstance().put("EC_IEP", this.textIEP.getText());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (Float.parseFloat(this.textISS.getText()) >= 0.0f && Float.parseFloat(this.textISS.getText()) <= 1.0f) {
                PreferenceManager.getInstance().put("EC_ISS", this.textISS.getText());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (Float.parseFloat(this.textISO.getText()) >= 0.0f && Float.parseFloat(this.textISO.getText()) <= 1.0f) {
                PreferenceManager.getInstance().put("EC_ISO", this.textISO.getText());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (Float.parseFloat(this.textISA.getText()) >= 0.0f && Float.parseFloat(this.textISA.getText()) <= 1.0f) {
                PreferenceManager.getInstance().put("EC_ISA", this.textISA.getText());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (Float.parseFloat(this.textISM.getText()) >= 0.0f && Float.parseFloat(this.textISM.getText()) <= 1.0f) {
                PreferenceManager.getInstance().put("EC_ISM", this.textISM.getText());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (Float.parseFloat(this.textIGC.getText()) >= 0.0f && Float.parseFloat(this.textIGC.getText()) <= 1.0f) {
                PreferenceManager.getInstance().put("EC_IGC", this.textIGC.getText());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (Float.parseFloat(this.textRCA.getText()) >= 0.0f && Float.parseFloat(this.textRCA.getText()) <= 1.0f) {
                PreferenceManager.getInstance().put("EC_RCA", this.textRCA.getText());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (Float.parseFloat(this.textTAS.getText()) >= 0.0f && Float.parseFloat(this.textTAS.getText()) <= 1.0f) {
                PreferenceManager.getInstance().put("EC_TAS", this.textTAS.getText());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (Float.parseFloat(this.textNAS.getText()) >= 0.0f && Float.parseFloat(this.textNAS.getText()) <= 1.0f) {
                PreferenceManager.getInstance().put("EC_NAS", this.textNAS.getText());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (Float.parseFloat(this.textIC.getText()) >= 0.0f && Float.parseFloat(this.textIC.getText()) <= 1.0f) {
                PreferenceManager.getInstance().put("EC_IC", this.textIC.getText());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (Float.parseFloat(this.textND.getText()) >= 0.0f && Float.parseFloat(this.textND.getText()) <= 1.0f) {
                PreferenceManager.getInstance().put("EC_ND", this.textND.getText());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (Float.parseFloat(this.textIEA.getText()) >= 0.0f && Float.parseFloat(this.textIEA.getText()) <= 1.0f) {
                PreferenceManager.getInstance().put("EC_IEA", this.textIEA.getText());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (Float.parseFloat(this.textNR.getText()) >= 0.0f && Float.parseFloat(this.textNR.getText()) <= 1.0f) {
                PreferenceManager.getInstance().put("EC_NR", this.textNR.getText());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (Float.parseFloat(this.textIBA.getText()) >= 0.0f && Float.parseFloat(this.textIBA.getText()) <= 1.0f) {
                PreferenceManager.getInstance().put("EC_IBA", this.textIBA.getText());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadPreferences() {
        Map<String, String> hashValues = EcWeightDialog.getEcWeightValues();
        this.textEXP.setText(hashValues.get("EXP"));
        this.textIDA.setText(hashValues.get("IDA"));
        this.textIPI.setText(hashValues.get("IPI"));
        this.textIMP.setText(hashValues.get("IMP"));
        this.textIGI.setText(hashValues.get("IGI"));
        this.textIEP.setText(hashValues.get("IEP"));
        this.textISS.setText(hashValues.get("ISS"));
        this.textISO.setText(hashValues.get("ISO"));
        this.textISA.setText(hashValues.get("ISA"));
        this.textISM.setText(hashValues.get("ISM"));
        this.textIGC.setText(hashValues.get("IGC"));
        this.textRCA.setText(hashValues.get("RCA"));
        this.textTAS.setText(hashValues.get("TAS"));
        this.textNAS.setText(hashValues.get("NAS"));
        this.textIC.setText(hashValues.get("IC"));
        this.textND.setText(hashValues.get("ND"));
        this.textIEA.setText(hashValues.get("IEA"));
        this.textNR.setText(hashValues.get("NR"));
        this.textIBA.setText(hashValues.get("IBA"));
    }

    public static Map<String, String> getEcWeightValues() {
        HashMap<String, String> mapEcWeights = new HashMap<String, String>();
        if (PreferenceManager.getInstance().get("EC_EXP", "") != null && PreferenceManager.getInstance().get("EC_EXP", "").length() > 0) {
            mapEcWeights.put("EXP", PreferenceManager.getInstance().get("EC_EXP", ""));
        } else {
            mapEcWeights.put("EXP", CompositePathway.MAP_WEIGHTS.get("EXP").toString());
        }
        if (PreferenceManager.getInstance().get("EC_IDA", "") != null && PreferenceManager.getInstance().get("EC_IDA", "").length() > 0) {
            mapEcWeights.put("IDA", PreferenceManager.getInstance().get("EC_IDA", ""));
        } else {
            mapEcWeights.put("IDA", CompositePathway.MAP_WEIGHTS.get("IDA").toString());
        }
        if (PreferenceManager.getInstance().get("EC_IPI", "") != null && PreferenceManager.getInstance().get("EC_IPI", "").length() > 0) {
            mapEcWeights.put("IPI", PreferenceManager.getInstance().get("EC_IPI", ""));
        } else {
            mapEcWeights.put("IPI", CompositePathway.MAP_WEIGHTS.get("IPI").toString());
        }
        if (PreferenceManager.getInstance().get("EC_IMP", "") != null && PreferenceManager.getInstance().get("EC_IMP", "").length() > 0) {
            mapEcWeights.put("IMP", PreferenceManager.getInstance().get("EC_IMP", ""));
        } else {
            mapEcWeights.put("IMP", CompositePathway.MAP_WEIGHTS.get("IMP").toString());
        }
        if (PreferenceManager.getInstance().get("EC_IGI", "") != null && PreferenceManager.getInstance().get("EC_IGI", "").length() > 0) {
            mapEcWeights.put("IGI", PreferenceManager.getInstance().get("EC_IGI", ""));
        } else {
            mapEcWeights.put("IGI", CompositePathway.MAP_WEIGHTS.get("IGI").toString());
        }
        if (PreferenceManager.getInstance().get("EC_IEP", "") != null && PreferenceManager.getInstance().get("EC_IEP", "").length() > 0) {
            mapEcWeights.put("IEP", PreferenceManager.getInstance().get("EC_IEP", ""));
        } else {
            mapEcWeights.put("IEP", CompositePathway.MAP_WEIGHTS.get("IEP").toString());
        }
        if (PreferenceManager.getInstance().get("EC_ISS", "") != null && PreferenceManager.getInstance().get("EC_ISS", "").length() > 0) {
            mapEcWeights.put("ISS", PreferenceManager.getInstance().get("EC_ISS", ""));
        } else {
            mapEcWeights.put("ISS", CompositePathway.MAP_WEIGHTS.get("ISS").toString());
        }
        if (PreferenceManager.getInstance().get("EC_ISO", "") != null && PreferenceManager.getInstance().get("EC_ISO", "").length() > 0) {
            mapEcWeights.put("ISO", PreferenceManager.getInstance().get("EC_ISO", ""));
        } else {
            mapEcWeights.put("ISO", CompositePathway.MAP_WEIGHTS.get("ISO").toString());
        }
        if (PreferenceManager.getInstance().get("EC_ISA", "") != null && PreferenceManager.getInstance().get("EC_ISA", "").length() > 0) {
            mapEcWeights.put("ISA", PreferenceManager.getInstance().get("EC_ISA", ""));
        } else {
            mapEcWeights.put("ISA", CompositePathway.MAP_WEIGHTS.get("ISA").toString());
        }
        if (PreferenceManager.getInstance().get("EC_ISM", "") != null && PreferenceManager.getInstance().get("EC_ISM", "").length() > 0) {
            mapEcWeights.put("ISM", PreferenceManager.getInstance().get("EC_ISM", ""));
        } else {
            mapEcWeights.put("ISM", CompositePathway.MAP_WEIGHTS.get("ISM").toString());
        }
        if (PreferenceManager.getInstance().get("EC_IGC", "") != null && PreferenceManager.getInstance().get("EC_IGC", "").length() > 0) {
            mapEcWeights.put("IGC", PreferenceManager.getInstance().get("EC_IGC", ""));
        } else {
            mapEcWeights.put("IGC", CompositePathway.MAP_WEIGHTS.get("IGC").toString());
        }
        if (PreferenceManager.getInstance().get("EC_RCA", "") != null && PreferenceManager.getInstance().get("EC_RCA", "").length() > 0) {
            mapEcWeights.put("RCA", PreferenceManager.getInstance().get("EC_RCA", ""));
        } else {
            mapEcWeights.put("RCA", CompositePathway.MAP_WEIGHTS.get("RCA").toString());
        }
        if (PreferenceManager.getInstance().get("EC_TAS", "") != null && PreferenceManager.getInstance().get("EC_TAS", "").length() > 0) {
            mapEcWeights.put("TAS", PreferenceManager.getInstance().get("EC_TAS", ""));
        } else {
            mapEcWeights.put("TAS", CompositePathway.MAP_WEIGHTS.get("TAS").toString());
        }
        if (PreferenceManager.getInstance().get("EC_NAS", "") != null && PreferenceManager.getInstance().get("EC_NAS", "").length() > 0) {
            mapEcWeights.put("NAS", PreferenceManager.getInstance().get("EC_NAS", ""));
        } else {
            mapEcWeights.put("NAS", CompositePathway.MAP_WEIGHTS.get("NAS").toString());
        }
        if (PreferenceManager.getInstance().get("EC_IC", "") != null && PreferenceManager.getInstance().get("EC_IC", "").length() > 0) {
            mapEcWeights.put("IC", PreferenceManager.getInstance().get("EC_IC", ""));
        } else {
            mapEcWeights.put("IC", CompositePathway.MAP_WEIGHTS.get("IC").toString());
        }
        if (PreferenceManager.getInstance().get("EC_ND", "") != null && PreferenceManager.getInstance().get("EC_ND", "").length() > 0) {
            mapEcWeights.put("ND", PreferenceManager.getInstance().get("EC_ND", ""));
        } else {
            mapEcWeights.put("ND", CompositePathway.MAP_WEIGHTS.get("ND").toString());
        }
        if (PreferenceManager.getInstance().get("EC_IEA", "") != null && PreferenceManager.getInstance().get("EC_IEA", "").length() > 0) {
            mapEcWeights.put("IEA", PreferenceManager.getInstance().get("EC_IEA", ""));
        } else {
            mapEcWeights.put("IEA", CompositePathway.MAP_WEIGHTS.get("IEA").toString());
        }
        if (PreferenceManager.getInstance().get("EC_NR", "") != null && PreferenceManager.getInstance().get("EC_NR", "").length() > 0) {
            mapEcWeights.put("NR", PreferenceManager.getInstance().get("EC_NR", ""));
        } else {
            mapEcWeights.put("NR", CompositePathway.MAP_WEIGHTS.get("NR").toString());
        }
        if (PreferenceManager.getInstance().get("EC_IBA", "") != null && PreferenceManager.getInstance().get("EC_IBA", "").length() > 0) {
            mapEcWeights.put("IBA", PreferenceManager.getInstance().get("EC_IBA", ""));
        } else {
            mapEcWeights.put("IBA", CompositePathway.MAP_WEIGHTS.get("IBA").toString());
        }
        return mapEcWeights;
    }
}

