/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.metabolicPathEditor.main;

import com.biotechvana.metabolicPathEditor.data.EnzymePathway;
import com.biotechvana.metabolicPathEditor.data.MetabolicPathUtils;
import com.biotechvana.metabolicPathEditor.data.SequenceEnzyme;
import com.biotechvana.metabolicPathEditor.main.CompositeForm;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class CompositePathway
extends Composite {
    private Table table;
    private TableViewer tableViewer;
    private Map<String, EnzymePathway> model;
    private List<SequenceEnzyme> listSequenceEnzyme;
    private CompositeForm compositeForm;
    private MetabolicPathUtils metabolicUtils;
    private int colorMode = 1;
    public static Map<String, Float> MAP_WEIGHTS = new HashMap<String, Float>(){
        {
            this.put("EXP", Float.valueOf(1.0f));
            this.put("IDA", Float.valueOf(1.0f));
            this.put("IPI", Float.valueOf(1.0f));
            this.put("IMP", Float.valueOf(1.0f));
            this.put("IGI", Float.valueOf(1.0f));
            this.put("IEP", Float.valueOf(1.0f));
            this.put("ISS", Float.valueOf(0.8f));
            this.put("ISO", Float.valueOf(0.8f));
            this.put("ISA", Float.valueOf(0.8f));
            this.put("ISM", Float.valueOf(0.8f));
            this.put("IGC", Float.valueOf(0.7f));
            this.put("RCA", Float.valueOf(0.9f));
            this.put("TAS", Float.valueOf(0.9f));
            this.put("NAS", Float.valueOf(0.8f));
            this.put("IC", Float.valueOf(0.9f));
            this.put("ND", Float.valueOf(0.5f));
            this.put("IEA", Float.valueOf(0.7f));
            this.put("NR", Float.valueOf(0.0f));
            this.put("IBA", Float.valueOf(0.0f));
        }
    };
    public static List<String> MAP_COLORS = new ArrayList<String>(){
        {
            this.add("red");
            this.add("blue");
            this.add("brown");
            this.add("yellow");
            this.add("pink");
            this.add("green");
            this.add("cyan");
            this.add("violet");
            this.add("tan");
            this.add("magenta");
            this.add("coral");
            this.add("gold");
            this.add("azure");
            this.add("gray");
            this.add("orange");
            this.add("bisque");
            this.add("wheat");
            this.add("Turquoise");
            this.add("YellowGreen");
            this.add("thistle");
            this.add("salmon");
            this.add("DarkOrange");
            this.add("LightYellow");
            this.add("BlueViolet");
            this.add("DarkTurquoise");
            this.add("DarkSlateGray");
            this.add("DarkSlateBlue");
            this.add("DarkSeaGreen");
            this.add("DarkSalmon");
            this.add("CadetBlue");
            this.add("OrangeRed");
        }
    };

    public CompositePathway(Composite parent, int style, CompositeForm compositeForm, final int colorMode) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.compositeForm = compositeForm;
        this.colorMode = colorMode;
        this.metabolicUtils = new MetabolicPathUtils();
        this.table = new Table((Composite)this, 2060);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.tableViewer = new TableViewer(this.table);
        TableColumn col1 = new TableColumn(this.table, 16384);
        col1.setText("Pathways");
        col1.setWidth(260);
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ((Collection)inputElement).toArray();
            }
        });
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getColumnText(Object element, int columnIndex) {
                return (String)element;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }
        });
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompositePathway.this.showMap(CompositePathway.this.table.getSelectionIndex(), colorMode);
            }
        });
    }

    private void showMap(int index, int colorMode) {
        String selectedText = this.table.getItem(index).getText();
        List<SequenceEnzyme> matchingEnzymes = this.model.get(selectedText).getMatchingEnzymes();
        this.metabolicUtils.assignWeightsAndSort(matchingEnzymes);
        this.metabolicUtils.assignColors(matchingEnzymes, colorMode);
        this.compositeForm.getCompositeEnzymes().setModel(matchingEnzymes);
        try {
            this.compositeForm.getCompositeBrowser().setMap(this.model.get(selectedText));
        }
        catch (InvocationTargetException e) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Metabolic Paths", (String)"Cannot download map");
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void setModel(List<SequenceEnzyme> listSequenceEnzyme, int colorMode) {
        this.listSequenceEnzyme = listSequenceEnzyme;
        if (listSequenceEnzyme != null) {
            HashMap<String, EnzymePathway> newModel = this.metabolicUtils.getPathwaysModel(this.listSequenceEnzyme);
            if (newModel != null) {
                this.model = newModel;
                this.tableViewer.setInput(this.metabolicUtils.getSortedDescriptionList(newModel.keySet()));
            }
            if (listSequenceEnzyme.size() > 0) {
                this.showMap(0, colorMode);
            }
        }
    }

    public Collection<EnzymePathway> getModel() {
        return this.model.values();
    }
}

