/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.metabolicPathEditor.main;

import com.biotechvana.metabolicPathEditor.main.CompositeBrowser;
import com.biotechvana.metabolicPathEditor.main.CompositeEnzymes;
import com.biotechvana.metabolicPathEditor.main.CompositePathway;
import com.biotechvana.metabolicPathEditor.main.MetabolicPathMainComposite;
import java.io.File;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class CompositeForm
extends Composite {
    public static final String METABOLIC_FOLDER_NAME = "Metabolic_pathways";
    private MetabolicPathMainComposite metabolicPathMainComposite;
    private CompositeEnzymes compositeEnzymes;
    private CompositeBrowser compositeBrowser;
    private CompositePathway compositePathway;
    private File workspaceDirectory;

    public CompositeForm(MetabolicPathMainComposite metabolicPathMainComposite, int style, File workspaceDirectory, int colorMode) {
        super((Composite)metabolicPathMainComposite, style);
        this.workspaceDirectory = workspaceDirectory;
        this.metabolicPathMainComposite = metabolicPathMainComposite;
        this.setLayout((Layout)new FillLayout(4));
        SashForm sashForm1 = new SashForm((Composite)this, 512);
        SashForm sashForm2 = new SashForm((Composite)sashForm1, 256);
        this.compositeEnzymes = new CompositeEnzymes((Composite)sashForm1, 2048, metabolicPathMainComposite.getSpeciesColumnIndex() != -1);
        this.compositePathway = new CompositePathway((Composite)sashForm2, 2048, this, colorMode);
        this.compositeBrowser = new CompositeBrowser((Composite)sashForm2, 2048, this);
        sashForm1.setWeights(new int[]{80, 20});
        sashForm2.setWeights(new int[]{20, 80});
        File parentFolder = new File(String.valueOf(workspaceDirectory) + File.separator + METABOLIC_FOLDER_NAME);
        if (!parentFolder.exists()) {
            parentFolder.mkdir();
        }
    }

    public CompositeEnzymes getCompositeEnzymes() {
        return this.compositeEnzymes;
    }

    public CompositeBrowser getCompositeBrowser() {
        return this.compositeBrowser;
    }

    public CompositePathway getCompositePathway() {
        return this.compositePathway;
    }

    public File getWorkspaceDirectory() {
        return this.workspaceDirectory;
    }

    public MetabolicPathMainComposite getMetabolicView() {
        return this.metabolicPathMainComposite;
    }
}

