/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.metabolicPathEditor.main;

import com.biotechvana.metabolicPathEditor.data.EnzymePathway;
import com.biotechvana.metabolicPathEditor.data.KeggViewer;
import com.biotechvana.metabolicPathEditor.data.SequenceEnzyme;
import com.biotechvana.metabolicPathEditor.main.CompositeForm;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class CompositeBrowser
extends Composite {
    private Browser browser;
    private File workspaceDirectory;
    private CompositeForm compositeForm;

    public CompositeBrowser(Composite parent, int style, CompositeForm compositeForm) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.browser = new Browser((Composite)this, 0);
        this.compositeForm = compositeForm;
        this.workspaceDirectory = compositeForm.getWorkspaceDirectory();
    }

    public void setMap(EnzymePathway pathway) throws InvocationTargetException, InterruptedException {
        final List<SequenceEnzyme> model = pathway.getMatchingEnzymes();
        final String map = pathway.getMapID();
        final File imageFile = new File(this.compositeForm.getMetabolicView().getProjectPath() + File.separator + map + ".png");
        if (!imageFile.exists()) {
            new ProgressMonitorDialog(this.getShell()).run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask("Download KEGG map", -1);
                    monitor.subTask("Downloading map: " + map);
                    try {
                        try {
                            CompositeBrowser.this.downloadMap(map, imageFile, model);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            System.err.println("Cannot download image map");
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        try {
            URI imageURI = imageFile.toURI();
            this.browser.setUrl(imageURI.toURL().toString());
        }
        catch (MalformedURLException e) {
            throw new InvocationTargetException(e);
        }
    }

    public void downloadMap(String map, File imageFile, List<SequenceEnzyme> model) throws Exception {
        KeggViewer keggViewer = new KeggViewer();
        keggViewer.downloadMap(imageFile.getName().replaceAll(".png", ""), imageFile.getParent(), model);
    }
}

