/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.metabolicPathEditor.data;

import com.biotechvana.metabolicPathEditor.data.EnzymePathway;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;

public class ScanEnzymePathway {
    private String KEGG_URL = "https://www.genome.jp/kegg-bin/search_pathway_text?map=map&mode=1&viewImage=false&perPage=200&keyword=";
    private String KEGG_URL_IMAGE = "https://www.genome.jp";
    private String KEGG_URL_IMAGE3 = "https://www.kegg.jp";
    private EnzymePathway enzymePathway;

    public List<EnzymePathway> getListEnzymePathway(String enzyme, List<EnzymePathway> listEnzymePathway) throws IOException {
        URL pagina = new URL(this.KEGG_URL + enzyme + "%2C");
        try (BufferedReader inputReader = new BufferedReader(new InputStreamReader(pagina.openStream()));){
            try {
                String line;
                Pattern p1 = Pattern.compile("^<td bgcolor=\"#FFFFFF\">$");
                Pattern p2 = Pattern.compile("^</tr>$");
                Pattern p3 = Pattern.compile("^.*blank.*>(.*)<.*$");
                Pattern p4 = Pattern.compile("^<td class=\"data1\" bgcolor=\"#\\w+\">(.*)</td>$");
                while ((line = inputReader.readLine()) != null) {
                    boolean isPathway = true;
                    Matcher m = p1.matcher(line);
                    if (!m.find()) continue;
                    this.enzymePathway = new EnzymePathway();
                    while (isPathway) {
                        line = inputReader.readLine();
                        m = p2.matcher(line);
                        if (m.find()) {
                            isPathway = false;
                            continue;
                        }
                        m = p3.matcher(line);
                        if (m.find()) {
                            this.enzymePathway.setMapID(m.group(1));
                        }
                        if (!(m = p4.matcher(line = inputReader.readLine())).find()) continue;
                        String mapName = m.group(1);
                        String post = mapName.replaceAll("</font>", "");
                        post = post.replaceAll("<font color=\"\\w+\">", "");
                        this.enzymePathway.setMapName(post);
                        isPathway = false;
                    }
                    listEnzymePathway.add(this.enzymePathway);
                }
            }
            catch (PatternSyntaxException ex) {
                ex.printStackTrace();
                inputReader.close();
            }
        }
        return listEnzymePathway;
    }

    public String getURLimage(String url, String pathwayID) throws IOException {
        String codeImage = this.getCodeImage(url, pathwayID);
        boolean isPathway = true;
        String urlImage = "";
        if (codeImage != null) {
            return this.KEGG_URL_IMAGE3 + codeImage;
        }
        URL pagina = new URL(this.KEGG_URL_IMAGE3 + codeImage);
        String search = "<img src=";
        try (BufferedReader inputReader = new BufferedReader(new InputStreamReader(pagina.openStream()));){
            String entrada;
            while ((entrada = inputReader.readLine()) != null && isPathway) {
                String ext;
                if (!entrada.startsWith(search)) continue;
                int pos = entrada.indexOf(" ", search.length());
                urlImage = ext = entrada.substring(search.length() + 1, pos - 1);
            }
            String string = this.KEGG_URL_IMAGE + urlImage;
            return string;
        }
    }

    public String getURLimage2(String url, String pathwayID) throws IOException {
        String codeImage = this.getCodeImage(url, pathwayID);
        boolean isPathway = true;
        String urlImage = "";
        URL pagina = new URL(this.KEGG_URL_IMAGE + codeImage);
        Pattern p1 = Pattern.compile("^.*name=\"pathwayimage\".*$");
        Pattern p2 = Pattern.compile("^<img src=\"(.*)\" name=\"pathwayimage\".*$");
        try (BufferedReader inputReader = new BufferedReader(new InputStreamReader(pagina.openStream()));){
            String entrada;
            while ((entrada = inputReader.readLine()) != null && isPathway) {
                Matcher m = p1.matcher(entrada);
                if (!m.find()) continue;
                while (isPathway) {
                    m = p2.matcher(entrada);
                    if (!m.find()) continue;
                    urlImage = m.group(1);
                    isPathway = false;
                }
            }
            String string = this.KEGG_URL_IMAGE + urlImage;
            return string;
        }
    }

    public String getCodeImage(String url, String pathwayID) {
        String codeImage = "";
        boolean isPathway = true;
        Pattern p3 = Pattern.compile("src=\"(/kegg/pathway/map/" + pathwayID + "\\.png\\?\\d+)\"");
        try {
            URL pagina = new URL(url);
            InputStream is = pagina.openStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader in = new BufferedReader(isr);
            String entrada = in.lines().collect(Collectors.joining());
            Matcher m = p3.matcher(entrada);
            if (m.find()) {
                codeImage = m.group(1);
                isPathway = false;
            }
            in.close();
            return codeImage;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return codeImage;
    }
}

