/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.metabolicPathEditor.data;

import com.biotechvana.metabolicPathEditor.data.SequenceEnzyme;
import com.biotechvana.metabolicPathEditor.data.Species;
import com.biotechvana.pipelineCommander.PipelineCommanderQueryUtils;
import com.biotechvana.utils.IPrefs;
import com.biotechvana.utils.PreferenceManager;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class QuerySpeciesHTTPRunnable
implements IRunnableWithProgress {
    private List<SequenceEnzyme> listSequenceEnzyme;
    private Collection<Species> speciesList;
    private HashMap<String, Species> nameToSpecies = new HashMap();
    private HashMap<String, Species> orgCodeToSpeciesName = new HashMap();
    private final String QUERY_SPECIES_TAXON = "SELECT taxonomy_alias.taxon , taxonomy_alias.taxon_name , kegg_species.kegg_sym FROM taxonomy_alias \nleft join  kegg_species on taxonomy_alias.taxon = kegg_species.taxon_id  \nWHERE taxon_name in ";
    private final String QUERY_SPECIES_EC2MAP = "SELECT kegg_org2map.* FROM kegg_org2map \nWHERE kegg_org2map.org_code in ";
    private final String PIPELINE_USER = PreferenceManager.getInstance().get("ssh_user", "");
    private final String PIPELINE_PASS = PreferenceManager.getInstance().get("ssh_password", "");
    private final String DB_NAME = PreferenceManager.getInstance().get("DB_PIPELINE", "");
    private static HashMap<String, String> speciesNameToCode = null;
    private static HashMap<String, String> speciesNameToTaxon = null;
    private static int PATCH_SIZE_QNAME = 200;
    private static int PATCH_SIZE_MAPS = 50;

    QuerySpeciesHTTPRunnable(List<SequenceEnzyme> listSequenceEnzymes, Collection<Species> species) {
        this.listSequenceEnzyme = listSequenceEnzymes;
        this.speciesList = species;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.getSpecies(monitor);
    }

    private void loadAllSpeciesCodes() {
        if (speciesNameToCode == null) {
            speciesNameToCode = new HashMap();
            speciesNameToTaxon = new HashMap();
            String loadQuery = "SELECT kegg_sym,name,taxon_id FROM kegg_species ";
            List resultSet = PipelineCommanderQueryUtils.runQuery((IPrefs)PreferenceManager.getInstance(), (String)PreferenceManager.getInstance().get("ssh_host", ""), (String)this.PIPELINE_USER, (String)this.PIPELINE_PASS, (String)this.DB_NAME, (String)loadQuery);
            int i = 1;
            while (i < resultSet.size()) {
                List row = (List)resultSet.get(i);
                String kegg_sym = (String)row.get(0);
                String name = (String)row.get(1);
                String taxon_id = (String)row.get(2);
                speciesNameToCode.put(name, kegg_sym);
                speciesNameToTaxon.put(name, taxon_id);
                ++i;
            }
        }
    }

    private void getSpecies(IProgressMonitor monitor) throws InterruptedException {
        try {
            List resultSet;
            String preparedQuery;
            monitor.beginTask("Resolving Species", this.speciesList.size() * 2);
            monitor.subTask("Resolving Species Names");
            this.loadAllSpeciesCodes();
            int currentPatchSize = 0;
            Object wherePart = "";
            int resolvedCount = 0;
            int i = 0;
            for (Species species : this.speciesList) {
                ++i;
                String spName = species.getSpeciesName();
                this.nameToSpecies.put(spName, species);
                if (speciesNameToCode.containsKey(spName)) {
                    species.resolveTaxon(speciesNameToTaxon.get(spName), speciesNameToCode.get(spName));
                    ++resolvedCount;
                    this.orgCodeToSpeciesName.put(speciesNameToCode.get(spName), species);
                    continue;
                }
                if (currentPatchSize < PATCH_SIZE_QNAME) {
                    wherePart = (String)wherePart + "'" + spName.replace("'", "\\'") + "'";
                    ++currentPatchSize;
                }
                if (currentPatchSize == PATCH_SIZE_QNAME || i == this.speciesList.size()) {
                    preparedQuery = "SELECT taxonomy_alias.taxon , taxonomy_alias.taxon_name , kegg_species.kegg_sym FROM taxonomy_alias \nleft join  kegg_species on taxonomy_alias.taxon = kegg_species.taxon_id  \nWHERE taxon_name in (" + (String)wherePart + ")";
                    resultSet = PipelineCommanderQueryUtils.runQuery((IPrefs)PreferenceManager.getInstance(), (String)PreferenceManager.getInstance().get("ssh_host", ""), (String)this.PIPELINE_USER, (String)this.PIPELINE_PASS, (String)this.DB_NAME, (String)preparedQuery);
                    try {
                        for (List row : resultSet) {
                            if (((String)row.get(0)).equals("taxon")) continue;
                            String taxon = (String)row.get(0);
                            String taxon_name = (String)row.get(1);
                            String kegg_sym = (String)row.get(2);
                            if (this.nameToSpecies.get(taxon_name).resolveTaxon(taxon, kegg_sym)) {
                                ++resolvedCount;
                                this.orgCodeToSpeciesName.put(kegg_sym, this.nameToSpecies.get(taxon_name));
                            } else {
                                monitor.worked(1);
                            }
                            monitor.worked(1);
                        }
                    }
                    catch (Exception row) {
                        // empty catch block
                    }
                    wherePart = "";
                    currentPatchSize = 0;
                } else {
                    wherePart = (String)wherePart + " , ";
                }
                if (!monitor.isCanceled()) continue;
                throw new InterruptedException();
            }
            monitor.subTask("Resolving Pathways per Species");
            wherePart = "";
            currentPatchSize = 0;
            i = 0;
            for (Species species : this.orgCodeToSpeciesName.values()) {
                ++i;
                if (!species.isResolved()) continue;
                String spCode = species.getKeggCode();
                if (currentPatchSize < PATCH_SIZE_MAPS) {
                    wherePart = (String)wherePart + "'" + spCode.replace("'", "\\'") + "'";
                    ++currentPatchSize;
                }
                if (currentPatchSize == PATCH_SIZE_MAPS || i == resolvedCount) {
                    preparedQuery = "SELECT kegg_org2map.* FROM kegg_org2map \nWHERE kegg_org2map.org_code in (" + (String)wherePart + ")";
                    resultSet = PipelineCommanderQueryUtils.runQuery((IPrefs)PreferenceManager.getInstance(), (String)PreferenceManager.getInstance().get("ssh_host", ""), (String)this.PIPELINE_USER, (String)this.PIPELINE_PASS, (String)this.DB_NAME, (String)preparedQuery);
                    try {
                        for (List row : resultSet) {
                            if (((String)row.get(0)).equals("org_code")) continue;
                            String orgCode = (String)row.get(0);
                            String ec = (String)row.get(1);
                            String pathway = (String)row.get(2);
                            this.orgCodeToSpeciesName.get(orgCode).addEC2Map(ec, pathway);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    monitor.worked(currentPatchSize);
                    wherePart = "";
                    currentPatchSize = 0;
                    System.out.println("============");
                } else {
                    wherePart = (String)wherePart + " , ";
                }
                if (!monitor.isCanceled()) continue;
                throw new InterruptedException();
            }
        }
        finally {
            monitor.done();
        }
    }
}

