/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.metabolicPathEditor.data;

import com.biotechvana.metabolicPathEditor.data.SequenceEnzyme;
import com.biotechvana.pipelineCommander.PipelineCommanderQueryUtils;
import com.biotechvana.utils.IPrefs;
import com.biotechvana.utils.PreferenceManager;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class QueryEcMapsHTTPRunnable
implements IRunnableWithProgress {
    private List<SequenceEnzyme> listSequenceEnzyme;
    private final String QUERY_MAP = "SELECT map, description FROM ec2map WHERE ec LIKE ?";
    private final String PIPELINE_USER = PreferenceManager.getInstance().get("ssh_user", "");
    private final String PIPELINE_PASS = PreferenceManager.getInstance().get("ssh_password", "");
    private final String DB_NAME = PreferenceManager.getInstance().get("DB_PIPELINE", "");

    public QueryEcMapsHTTPRunnable(List<SequenceEnzyme> listSequenceEnzymes) {
        this.listSequenceEnzyme = listSequenceEnzymes;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.getMaps(monitor);
    }

    private void getMaps(IProgressMonitor monitor) throws InterruptedException {
        try {
            monitor.beginTask("Query EC maps", this.listSequenceEnzyme.size());
            monitor.subTask("Fetching maps for enzyme codes");
            int i = 0;
            while (i < this.listSequenceEnzyme.size()) {
                String code = this.listSequenceEnzyme.get(i).getEnzyme();
                List<String> cachedMaps = SequenceEnzyme.getEnzymeMaps(code);
                if (cachedMaps != null && !cachedMaps.isEmpty()) {
                    for (String mapId : cachedMaps) {
                        String mapDesc = SequenceEnzyme.getMapName(mapId);
                        this.listSequenceEnzyme.get(i).addPathway(mapId, mapDesc);
                    }
                } else {
                    String preparedQuery = PipelineCommanderQueryUtils.prepareQuery((String)"SELECT map, description FROM ec2map WHERE ec LIKE ?", (String[])new String[]{code}, (String[])new String[]{"s"});
                    List resultSet = PipelineCommanderQueryUtils.runQuery((IPrefs)PreferenceManager.getInstance(), (String)PreferenceManager.getInstance().get("ssh_host", ""), (String)this.PIPELINE_USER, (String)this.PIPELINE_PASS, (String)this.DB_NAME, (String)preparedQuery);
                    try {
                        for (List row : resultSet) {
                            if (((String)row.get(0)).equals("map")) continue;
                            String mapId = (String)row.get(0);
                            String mapName = (String)row.get(1);
                            this.listSequenceEnzyme.get(i).addPathway(mapId, mapName);
                            SequenceEnzyme.cacheEnzymeMap(code, mapId, mapName);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                }
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }
}

