/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.metabolicPathEditor.data;

import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.metabolicPathEditor.data.ExtractEcListRunnable;
import com.biotechvana.metabolicPathEditor.data.QueryEcDescriptionsHTTPRunnable;
import com.biotechvana.metabolicPathEditor.data.QueryEcMapsHTTPRunnable;
import com.biotechvana.metabolicPathEditor.data.QuerySpeciesHTTPRunnable;
import com.biotechvana.metabolicPathEditor.data.SequenceEnzyme;
import com.biotechvana.metabolicPathEditor.data.Species;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class MetabolicGenerateDataset {
    private CSVEditor csvEditor;
    private int sequenceColumnIndex;
    private int enzymeCodeColumnIndex;
    private int evidenceColumnIndex;
    private int speciesColumnIndex;
    private List<SequenceEnzyme> listSequenceEnzyme;
    private Shell shell;

    public MetabolicGenerateDataset(CSVEditor csvEditor, int sequenceColumnIndex, int enzymeCodeColumnIndex, int evidenceColumnIndex, int speciesColumnIndex) {
        this.csvEditor = csvEditor;
        this.sequenceColumnIndex = sequenceColumnIndex;
        this.enzymeCodeColumnIndex = enzymeCodeColumnIndex;
        this.evidenceColumnIndex = evidenceColumnIndex;
        this.speciesColumnIndex = speciesColumnIndex;
        this.shell = csvEditor.getSite().getShell();
    }

    public void generateDataset() {
        Collection<Species> speciesList;
        ExtractEcListRunnable ecRunnable = new ExtractEcListRunnable(this.csvEditor, this.sequenceColumnIndex, this.enzymeCodeColumnIndex, this.evidenceColumnIndex, this.speciesColumnIndex);
        try {
            new ProgressMonitorDialog(this.shell).run(true, true, (IRunnableWithProgress)ecRunnable);
        }
        catch (InvocationTargetException e) {
            if (this.csvEditor.getDebug()) {
                e.printStackTrace();
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        List<SequenceEnzyme> listSequenceEnzymes = ecRunnable.getListEC();
        QueryEcDescriptionsHTTPRunnable descriptionRunnable = new QueryEcDescriptionsHTTPRunnable(listSequenceEnzymes);
        try {
            new ProgressMonitorDialog(this.shell).run(true, true, (IRunnableWithProgress)descriptionRunnable);
        }
        catch (InvocationTargetException e1) {
            if (this.csvEditor.getDebug()) {
                e1.printStackTrace();
            }
        }
        catch (InterruptedException e1) {
            // empty catch block
        }
        if (this.speciesColumnIndex != -1 && !(speciesList = ecRunnable.getSpeciesList()).isEmpty()) {
            QuerySpeciesHTTPRunnable qSpeciesRunnable = new QuerySpeciesHTTPRunnable(listSequenceEnzymes, speciesList);
            try {
                new ProgressMonitorDialog(this.shell).run(true, true, (IRunnableWithProgress)qSpeciesRunnable);
            }
            catch (InvocationTargetException e1) {
                if (this.csvEditor.getDebug()) {
                    e1.printStackTrace();
                }
            }
            catch (InterruptedException e1) {
                // empty catch block
            }
        }
        QueryEcMapsHTTPRunnable queryMapsRunnable = new QueryEcMapsHTTPRunnable(listSequenceEnzymes);
        try {
            new ProgressMonitorDialog(this.shell).run(true, true, (IRunnableWithProgress)queryMapsRunnable);
        }
        catch (InvocationTargetException e) {
            if (this.csvEditor.getDebug()) {
                e.printStackTrace();
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        ArrayList<SequenceEnzyme> listFiltered = new ArrayList<SequenceEnzyme>();
        int i = 0;
        while (i < listSequenceEnzymes.size()) {
            SequenceEnzyme e = listSequenceEnzymes.get(i);
            e.applyFilterPathways();
            if (e.getPathwaysCount() > 0) {
                listFiltered.add(e);
            }
            ++i;
        }
        Collections.sort(listFiltered, new Comparator<SequenceEnzyme>(){

            @Override
            public int compare(SequenceEnzyme o1, SequenceEnzyme o2) {
                if (o1.getEnzymeName() == null) {
                    return 1;
                }
                if (o2.getEnzymeName() == null) {
                    return 0;
                }
                if (o1.getEnzymeName() == null && o2.getEnzymeName() == null) {
                    return 0;
                }
                return o1.getEnzymeName().compareTo(o2.getEnzymeName());
            }
        });
        this.listSequenceEnzyme = listFiltered;
    }

    public List<SequenceEnzyme> getListSequenceEnzyme() throws MetabolicDatasetNotParsed {
        if (this.listSequenceEnzyme == null || this.listSequenceEnzyme.size() == 0) {
            throw new MetabolicDatasetNotParsed();
        }
        return this.listSequenceEnzyme;
    }

    public class MetabolicDatasetNotParsed
    extends Exception {
    }
}

