/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.metabolicPathEditor.data;

import com.biotechvana.metabolicPathEditor.data.EnzymePathway;
import com.biotechvana.metabolicPathEditor.data.MetabolicPathUtils;
import com.biotechvana.metabolicPathEditor.data.SequenceEnzyme;
import com.biotechvana.metabolicPathEditor.main.MetabolicPathMainComposite;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;

public class MetabolicDownloadMapsRunnable
implements IRunnableWithProgress {
    private MetabolicPathMainComposite metabolicView;
    private List<SequenceEnzyme> listSequenceEnzyme;
    private Collection<EnzymePathway> listMapNames;
    private MetabolicPathUtils metabolicUtils;
    private DecimalFormat decimalFormat = new DecimalFormat("###,###");
    private int counter = 1;

    public MetabolicDownloadMapsRunnable(MetabolicPathMainComposite metabolicView, List<SequenceEnzyme> listSequenceEnzyme, Collection<EnzymePathway> listMapNames) {
        this.metabolicView = metabolicView;
        this.listSequenceEnzyme = listSequenceEnzyme;
        this.listMapNames = listMapNames;
        this.metabolicUtils = new MetabolicPathUtils();
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.beginTask("Download metabolic maps", this.listMapNames.size());
        for (EnzymePathway mapName : this.listMapNames) {
            monitor.subTask("Downloading map (" + this.decimalFormat.format(this.counter++) + "/" + this.decimalFormat.format(this.listMapNames.size()) + "): " + mapName.getMapID());
            final EnzymePathway pathway = mapName;
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    List<SequenceEnzyme> matchingEnzymes = pathway.getMatchingEnzymes();
                    MetabolicDownloadMapsRunnable.this.metabolicUtils.assignWeightsAndSort(matchingEnzymes);
                    MetabolicDownloadMapsRunnable.this.metabolicUtils.assignColors(matchingEnzymes, MetabolicDownloadMapsRunnable.this.metabolicView.getColorMode());
                    String map = pathway.getMapID();
                    File imageFile = new File(MetabolicDownloadMapsRunnable.this.metabolicView.getProjectPath() + File.separator + map + ".png");
                    if (!imageFile.exists()) {
                        try {
                            MetabolicDownloadMapsRunnable.this.metabolicView.getCompositeForm().getCompositeBrowser().downloadMap(map, imageFile, matchingEnzymes);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
            monitor.worked(1);
            if (!monitor.isCanceled()) continue;
            throw new InterruptedException();
        }
    }
}

