/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.metabolicPathEditor.data;

import com.biotechvana.metabolicPathEditor.data.ScanEnzymePathway;
import com.biotechvana.metabolicPathEditor.data.SequenceEnzyme;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;

public class KeggViewer {
    public static final String ID = "com.biotechvana.gydbpro.views.KeggViewer";
    public static final String KEGG_URL = "https://www.genome.jp/kegg-bin/show_pathway?";
    public static final String KEGG_DOWNLOAD = "https://www.genome.jp/kegg/pathway/map/";
    public static final String KEGG_EXTENSION = ".png";
    private static final String KEGG_DOWNLOAD_2 = "https://www.genome.jp/kegg-bin/color_pathway_object?org_name=ec&other_dbs=&reference=white&unclassified=";
    private static final String KEGG_DOWNLOAD_3 = "https://www.kegg.jp/kegg-bin/show_pathway?";

    public void downloadMap(String mapId, String outputFolder, List<SequenceEnzyme> model) throws Exception {
        File fileNew;
        if (outputFolder == null) {
            throw new Exception("Output folder does not exist");
        }
        String urlImage = "";
        StringBuilder params = new StringBuilder();
        for (SequenceEnzyme mo : model) {
            String color = mo.getColorName();
            if (color != null) {
                color = color.replaceAll(" ", "%20");
            }
            params.append(mo.getEnzyme().replaceAll("EC:", "") + "%09," + color + "/");
        }
        URL url_2 = new URL(KEGG_DOWNLOAD_3 + mapId + "/" + params.toString());
        ScanEnzymePathway scanEnzymePathway = new ScanEnzymePathway();
        urlImage = scanEnzymePathway.getURLimage(url_2.toString(), mapId);
        File folder = new File(outputFolder);
        if (!folder.exists()) {
            folder.mkdir();
        }
        if (!(fileNew = new File(outputFolder + File.separator + mapId + KEGG_EXTENSION)).exists() && !fileNew.createNewFile()) {
            throw new Exception("Cannot create file");
        }
        URLConnection connection = new URL(urlImage).openConnection();
        connection.setConnectTimeout(300000);
        connection.setReadTimeout(300000);
        InputStream in = connection.getInputStream();
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(fileNew));
        try {
            int b;
            while ((b = in.read()) != -1) {
                ((OutputStream)out).write(b);
            }
        }
        finally {
            in.close();
            ((OutputStream)out).close();
        }
    }
}

