/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.views.statistics;

import com.biotechvana.utils.PreferenceManager;
import com.lowagie.text.Document;
import com.lowagie.text.PageSize;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.experimental.chart.swt.ChartComposite;

public class StatisticsView
extends ViewPart {
    public static final String ID = "com.biotechvana.gydbpro.views.statistics.StatisticsView";
    private static final boolean DEBUG = true;
    private CTabItem tab2;
    private CTabItem tab1;
    private Text text;
    private JFreeChart chart1;
    private JFreeChart chart2;
    private JFreeChart chartGO1;
    private JFreeChart chartGO2;
    private JFreeChart chartGO3;
    private CTabFolder tabfolder;

    public void generateBlastCharts(int[] eValueXmatrixInt, int[] evalueYmatrixInt, int[] simXmatrixInt, int[] simYmatrixInt, String xLabel) {
        this.chart1 = this.createXYChart(this.createXYDataset(eValueXmatrixInt, evalueYmatrixInt), "eValue Distribution", xLabel);
        this.chart2 = this.createXYChart(this.createXYDataset(simXmatrixInt, simYmatrixInt), "Similarity Distribution", xLabel);
        this.tab1 = new CTabItem(this.tabfolder, 64);
        this.tab1.setText("Taxonomy Statistics output");
        Group group = new Group((Composite)this.tabfolder, 0);
        this.text = new Text((Composite)this.tabfolder, 2816);
        int i = 0;
        while (i < 600) {
            this.text.append(i + "-This is a line of text of Statistics analysis-" + i + "\n");
            ++i;
        }
        this.tab1.setControl((Control)this.text);
        this.tab2 = new CTabItem(this.tabfolder, 64);
        this.tab2.setText("Graphics ouput");
        SashForm sashForm = new SashForm((Composite)this.tabfolder, 256);
        FillLayout fillLayout1 = new FillLayout();
        fillLayout1.type = 256;
        sashForm.setLayout((Layout)fillLayout1);
        this.createSaveAsPdfMenu(sashForm);
        new ChartComposite((Composite)sashForm, 0, this.chart1, true);
        new ChartComposite((Composite)sashForm, 0, this.chart2, true);
        this.tab2.setControl((Control)sashForm);
        this.tabfolder.redraw();
    }

    public void generateGOcharts(String[] categoryXmatrix1, Integer[] valuesYmatrix1, String[] categoryXmatrix2, Integer[] valuesYmatrix2, String[] categoryXmatrix3, Integer[] valuesYmatrix3, String tabTitle, ArrayList<String> graphOptions) {
        System.out.println(" Generando el output ...");
        this.tab2 = new CTabItem(this.tabfolder, 64);
        this.tab2.setText(tabTitle);
        SashForm sashForm = new SashForm((Composite)this.tabfolder, 256);
        FillLayout fillLayout1 = new FillLayout();
        fillLayout1.type = 256;
        sashForm.setLayout((Layout)fillLayout1);
        if (categoryXmatrix1 != null) {
            this.chartGO1 = this.createBarChart(this.createBarDataset(categoryXmatrix1, valuesYmatrix1), "Biological process distribution", "GO terms by domain:[P]", graphOptions, null);
            new ChartComposite((Composite)sashForm, 0, this.chartGO1, true);
        }
        if (categoryXmatrix1 != null) {
            this.chartGO2 = this.createBarChart(this.createBarDataset(categoryXmatrix2, valuesYmatrix2), "Molecular function distribution", "GO terms by domain:[F]", graphOptions, null);
            new ChartComposite((Composite)sashForm, 0, this.chartGO2, true);
        }
        if (categoryXmatrix1 != null) {
            this.chartGO3 = this.createBarChart(this.createBarDataset(categoryXmatrix3, valuesYmatrix3), "Cellular component distribution", "GO terms by domain:[C]", graphOptions, null);
            new ChartComposite((Composite)sashForm, 0, this.chartGO3, true);
        }
        this.tab2.setControl((Control)sashForm);
        this.createSaveAsPdfMenu(sashForm);
        this.tabfolder.redraw();
        this.tabfolder.setFocus();
        this.tabfolder.setVisible(true);
        this.tabfolder.setSelection(this.tab2);
    }

    public void generateXYChart(int[] eValueXmatrixInt, int[] evalueYmatrixInt, String chartTitle, String chartXlabel) {
        this.chart1 = this.createXYChart(this.createXYDataset(eValueXmatrixInt, evalueYmatrixInt), chartTitle, chartXlabel);
        this.tab2 = new CTabItem(this.tabfolder, 64);
        this.tab2.setText(chartXlabel + " Chart");
        SashForm sashForm = new SashForm((Composite)this.tabfolder, 256);
        FillLayout fillLayout1 = new FillLayout();
        fillLayout1.type = 256;
        sashForm.setLayout((Layout)fillLayout1);
        this.createSaveAsPdfMenu(sashForm);
        Label l2 = new Label((Composite)sashForm, 0);
        l2.setText("");
        this.tab2.setControl((Control)sashForm);
        this.tabfolder.redraw();
        this.tabfolder.setFocus();
        this.tabfolder.setVisible(true);
        this.tabfolder.setSelection(this.tab2);
    }

    public void generateBarChart(String[] categoryXmatrix, Integer[] valuesYmatrix, String chartTitle, String chartXlabel, ArrayList<String> graphOptions, Paint[] barColors) {
        this.chart1 = this.createBarChart(this.createBarDataset(categoryXmatrix, valuesYmatrix), chartTitle, chartXlabel, graphOptions, barColors);
        this.tab2 = new CTabItem(this.tabfolder, 64);
        this.tab2.setText(chartXlabel + "Chart");
        SashForm sashForm = new SashForm((Composite)this.tabfolder, 256);
        FillLayout fillLayout1 = new FillLayout();
        fillLayout1.type = 256;
        sashForm.setLayout((Layout)fillLayout1);
        this.createSaveAsPdfMenu(sashForm);
        Label l2 = new Label((Composite)sashForm, 0);
        l2.setText("....");
        this.tab2.setControl((Control)sashForm);
        this.tabfolder.redraw();
        this.tabfolder.setFocus();
        this.tabfolder.setVisible(true);
        this.tabfolder.setSelection(this.tab2);
    }

    private void createSaveAsPdfMenu(SashForm sashForm) {
        ChartComposite myChartComposite = new ChartComposite((Composite)sashForm, 0, this.chart1, false){

            protected Menu createPopupMenu(boolean properties, boolean save, boolean print, boolean zoom) {
                Menu menu = super.createPopupMenu(properties, save, print, zoom);
                new MenuItem(menu, 2);
                MenuItem newItem = new MenuItem(menu, 0);
                newItem.setText("Save as pdf");
                newItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        try {
                            FileDialog dialog = new FileDialog(StatisticsView.this.getSite().getShell(), 8192);
                            dialog.setFileName((this).StatisticsView.this.chart1.getTitle().getText() + ".pdf");
                            String prefSaveLocation = PreferenceManager.getInstance().get("workspace", "");
                            if (prefSaveLocation == null || prefSaveLocation.isEmpty()) {
                                dialog.setFilterPath(prefSaveLocation);
                            } else {
                                dialog.setFilterPath(prefSaveLocation);
                            }
                            String fileName = dialog.open();
                            StatisticsView.this.saveChartToPDF((this).StatisticsView.this.chart1, fileName, 480, 480);
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                });
                return menu;
            }
        };
    }

    private XYDataset createXYDataset(int[] Xmatrix, int[] Ymatrix) {
        XYSeries series1 = new XYSeries((Comparable)((Object)"First"));
        int i = 0;
        while (i < Xmatrix.length) {
            series1.add((double)Xmatrix[i], (double)Ymatrix[i]);
            ++i;
        }
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(series1);
        return dataset;
    }

    private CategoryDataset createBarDataset(String[] categoriesMatrix, Integer[] integers) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        String series1 = new String("First");
        int i = 0;
        while (i < categoriesMatrix.length) {
            dataset.addValue((Number)integers[i], (Comparable)((Object)series1), (Comparable)((Object)categoriesMatrix[i]));
            ++i;
        }
        return dataset;
    }

    private JFreeChart createXYChart(XYDataset xyDataset, String title, String xLabel) {
        JFreeChart chart = ChartFactory.createXYAreaChart((String)title, (String)xLabel, (String)"Sequences", (XYDataset)xyDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setDomainGridlinePaint((Paint)Color.lightGray);
        plot.setRangeGridlinePaint((Paint)Color.lightGray);
        plot.setForegroundAlpha(0.6f);
        plot.setBackgroundAlpha(1.0f);
        XYItemRenderer renderer = plot.getRenderer();
        renderer.setSeriesPaint(0, (Paint)Color.red);
        return chart;
    }

    private JFreeChart createBarChart(CategoryDataset BarDataset, String title, String chartXlabel, ArrayList<String> graphOptions, Paint[] barColors) {
        PlotOrientation graphOrientation = PlotOrientation.VERTICAL;
        if (graphOptions == null) {
            graphOrientation = PlotOrientation.VERTICAL;
        } else {
            for (String options : graphOptions) {
                if (!options.contains("Horizontal bars")) continue;
                graphOrientation = PlotOrientation.HORIZONTAL;
            }
        }
        JFreeChart chart = ChartFactory.createBarChart((String)title, (String)chartXlabel, (String)"Sequences", (CategoryDataset)BarDataset, (PlotOrientation)graphOrientation, (boolean)false, (boolean)true, (boolean)false);
        CategoryPlot plot = chart.getCategoryPlot();
        if (barColors != null) {
            CustomRenderer renderer = new CustomRenderer(barColors);
            plot.setRenderer((CategoryItemRenderer)renderer);
        }
        plot.setBackgroundPaint((Paint)Color.lightGray);
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setDomainGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.white);
        Font labelFont = new Font("Sans serif", 0, 12);
        Font titleFont = new Font("Sans serif", 1, 14);
        CategoryAxis domainAxis = plot.getDomainAxis();
        domainAxis.setLabelFont(labelFont);
        Font fuente = domainAxis.getLabelFont();
        return chart;
    }

    private JFreeChart createPieChart(CategoryDataset pieDataset, String title, Paint[] barColors) {
        JFreeChart chart = ChartFactory.createPieChart((String)title, (PieDataset)((PieDataset)pieDataset), (boolean)true, (boolean)true, (boolean)false);
        CategoryPlot plot = chart.getCategoryPlot();
        if (barColors != null) {
            CustomRenderer renderer = new CustomRenderer(barColors);
            plot.setRenderer((CategoryItemRenderer)renderer);
        }
        plot.setBackgroundPaint((Paint)Color.lightGray);
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setDomainGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.white);
        return chart;
    }

    public void createPartControl(Composite parent) {
        this.tabfolder = new CTabFolder(parent, 0);
        this.tabfolder.setSimple(false);
    }

    public void setFocus() {
    }

    public void saveChartToPDF(JFreeChart chart, String fileName, int width, int height) throws Exception {
        if (chart != null) {
            Document document = new Document(PageSize.A4);
            try {
                PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(fileName));
                writer.setMargins(20.0f, 20.0f, 20.0f, 20.0f);
                document.open();
                PdfContentByte cb = writer.getDirectContent();
                PdfTemplate tp = cb.createTemplate((float)width, (float)height);
                Graphics2D g2 = tp.createGraphics((float)width, (float)height, (FontMapper)new DefaultFontMapper());
                Rectangle2D.Double r2D = new Rectangle2D.Double(0.0, 0.0, width, height);
                chart.draw(g2, (Rectangle2D)r2D, null);
                g2.dispose();
                cb.addTemplate(tp, 0.0f, 0.0f);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            document.close();
        }
    }

    class CustomRenderer
    extends BarRenderer {
        private Paint[] colors;

        public CustomRenderer(Paint[] colors) {
            this.colors = colors;
        }

        public Paint getItemPaint(int row, int column) {
            return this.colors[column % this.colors.length];
        }
    }
}

