/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.views;

import com.biotechvana.utils.PreferenceManager;
import java.awt.Color;
import java.awt.Paint;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.ViewPart;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.experimental.chart.swt.ChartComposite;
import org.jfree.util.Rotation;

public class StatsView
extends ViewPart {
    public static final String ID = "com.biotechvana.gydbpro.views.StatsView";
    private CTabFolder tabFolder;
    private final String KEY_TEXT = "KEY";
    private final String VALUE_TEXT = "COUNT";
    private final String DELIMITER = "\"";
    private final String SEPARATOR = ";";
    private final String NEW_LINE = "\n";
    private String lastSelectedFile = null;

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        GridData layoutData = new GridData(1808);
        composite.setLayoutData((Object)layoutData);
        this.tabFolder = new CTabFolder(composite, 2048);
        layoutData = new GridData(1808);
        this.tabFolder.setLayoutData((Object)layoutData);
    }

    public void setFocus() {
    }

    public void addXYGraph(String windowTitle, String[] graphName, final XYDataset[] xyDataset, String[] xLabel, String[] yLabel, PlotOrientation orientation, boolean legend, boolean tooltips, boolean urls) {
        CTabItem tabItem = new CTabItem(this.tabFolder, 0);
        tabItem.setText(windowTitle);
        tabItem.setShowClose(true);
        SashForm sashForm = new SashForm((Composite)this.tabFolder, 0);
        int i = 0;
        while (i < xyDataset.length) {
            JFreeChart chart = ChartFactory.createXYAreaChart((String)graphName[i], (String)xLabel[i], (String)yLabel[i], (XYDataset)xyDataset[i], (PlotOrientation)orientation, (boolean)legend, (boolean)tooltips, (boolean)urls);
            XYPlot plot = (XYPlot)chart.getPlot();
            plot.setBackgroundPaint((Paint)Color.WHITE);
            plot.setDomainGridlinePaint((Paint)Color.LIGHT_GRAY);
            plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
            plot.setForegroundAlpha(0.6f);
            plot.setBackgroundAlpha(1.0f);
            XYItemRenderer renderer = plot.getRenderer();
            renderer.setSeriesPaint(0, (Paint)Color.RED);
            final int c = i++;
            new ChartComposite((Composite)sashForm, 0, chart, true){

                protected Menu createPopupMenu(boolean properties, boolean save, boolean print, boolean zoom) {
                    Menu menu = super.createPopupMenu(properties, save, print, zoom);
                    new MenuItem(menu, 2);
                    MenuItem newItem = new MenuItem(menu, 0);
                    newItem.setText("Export data matrix");
                    newItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            File fileSelection = StatsView.this.selectFile();
                            if (StatsView.this.exportXYDatasetMatrix(xyDataset[c], fileSelection)) {
                                MessageDialog.openInformation((Shell)this.getShell(), (String)"Export data matrix", (String)"Exported successfully");
                            } else {
                                MessageDialog.openError((Shell)this.getShell(), (String)"Export data matrix", (String)"Error exporting data matrix");
                            }
                        }
                    });
                    return menu;
                }
            };
        }
        tabItem.setControl((Control)sashForm);
        this.tabFolder.showItem(tabItem);
        this.tabFolder.setSelection(tabItem);
    }

    public void addXYGraph(String windowTitle, String graphName, final XYDataset xyDataset, String xLabel, String yLabel, PlotOrientation orientation, boolean legend, boolean tooltips, boolean urls, RGB rgbRow) throws NullPointerException {
        CTabItem tabItem = new CTabItem(this.tabFolder, 0);
        tabItem.setText(windowTitle);
        tabItem.setShowClose(true);
        JFreeChart chart = ChartFactory.createXYAreaChart((String)graphName, (String)xLabel, (String)yLabel, (XYDataset)xyDataset, (PlotOrientation)orientation, (boolean)legend, (boolean)tooltips, (boolean)urls);
        if (chart == null) {
            throw new NullPointerException("Chart is null");
        }
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setDomainGridlinePaint((Paint)Color.LIGHT_GRAY);
        plot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
        Color barColor = new Color(255, 80, 80);
        if (rgbRow != null) {
            barColor = new Color(rgbRow.red, rgbRow.green, rgbRow.blue);
        }
        plot.setForegroundAlpha(0.6f);
        plot.setBackgroundAlpha(1.0f);
        XYItemRenderer renderer = plot.getRenderer();
        renderer.setSeriesPaint(0, (Paint)barColor);
        ChartComposite chartComposite = new ChartComposite((Composite)this.tabFolder, 0, chart, true){

            protected Menu createPopupMenu(boolean properties, boolean save, boolean print, boolean zoom) {
                Menu menu = super.createPopupMenu(properties, save, print, zoom);
                new MenuItem(menu, 2);
                MenuItem newItem = new MenuItem(menu, 0);
                newItem.setText("Export data matrix");
                newItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        File fileSelection = StatsView.this.selectFile();
                        if (StatsView.this.exportXYDatasetMatrix(xyDataset, fileSelection)) {
                            MessageDialog.openInformation((Shell)this.getShell(), (String)"Export data matrix", (String)"Exported successfully");
                        } else {
                            MessageDialog.openError((Shell)this.getShell(), (String)"Export data matrix", (String)"Error exporting data matrix");
                        }
                    }
                });
                return menu;
            }
        };
        tabItem.setControl((Control)chartComposite);
        tabItem.setControl((Control)chartComposite);
        this.tabFolder.showItem(tabItem);
        this.tabFolder.setSelection(tabItem);
    }

    public void addBarGraph(String windowTitle, String graphName, final CategoryDataset categoryDataset, String xLabel, String yLabel, PlotOrientation orientation, boolean legend, boolean tooltips, boolean urls, boolean chart3D, RGB rgbRow) {
        Color barColor = new Color(255, 80, 80);
        if (rgbRow != null) {
            barColor = new Color(rgbRow.red, rgbRow.green, rgbRow.blue);
        }
        CTabItem tabItem = new CTabItem(this.tabFolder, 0);
        tabItem.setText(graphName);
        tabItem.setShowClose(true);
        JFreeChart chart = null;
        chart = chart3D ? ChartFactory.createBarChart3D((String)graphName, (String)xLabel, (String)yLabel, (CategoryDataset)categoryDataset, (PlotOrientation)orientation, (boolean)legend, (boolean)tooltips, (boolean)urls) : ChartFactory.createBarChart((String)graphName, (String)xLabel, (String)yLabel, (CategoryDataset)categoryDataset, (PlotOrientation)orientation, (boolean)legend, (boolean)tooltips, (boolean)urls);
        CategoryPlot categoryPlot = (CategoryPlot)chart.getPlot();
        ValueAxis axis = categoryPlot.getRangeAxis();
        if (axis instanceof NumberAxis) {
            ((NumberAxis)axis).setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        }
        if (chart3D) {
            renderer = (BarRenderer3D)categoryPlot.getRenderer();
            renderer.setBarPainter((BarPainter)new StandardBarPainter());
            renderer.setShadowVisible(false);
            renderer.setItemMargin(0.1);
            renderer.setDrawBarOutline(false);
            renderer.setSeriesPaint(0, (Paint)barColor);
        } else {
            renderer = (BarRenderer)categoryPlot.getRenderer();
            renderer.setBarPainter((BarPainter)new StandardBarPainter());
            renderer.setShadowVisible(false);
            renderer.setItemMargin(0.1);
            renderer.setDrawBarOutline(false);
            renderer.setSeriesPaint(0, (Paint)barColor);
        }
        if (orientation == PlotOrientation.VERTICAL) {
            CategoryAxis domainAxis = categoryPlot.getDomainAxis();
            domainAxis.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)1.5707963267948966));
        }
        ChartComposite chartComposite = new ChartComposite((Composite)this.tabFolder, 0, chart, true){

            protected Menu createPopupMenu(boolean properties, boolean save, boolean print, boolean zoom) {
                Menu menu = super.createPopupMenu(properties, save, print, zoom);
                new MenuItem(menu, 2);
                MenuItem newItem = new MenuItem(menu, 0);
                newItem.setText("Export data matrix");
                newItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        File fileSelection = StatsView.this.selectFile();
                        if (StatsView.this.exportBarDatasetMatrix(categoryDataset, fileSelection)) {
                            MessageDialog.openInformation((Shell)this.getShell(), (String)"Export data matrix", (String)"Exported successfully");
                        } else {
                            MessageDialog.openError((Shell)this.getShell(), (String)"Export data matrix", (String)"Error exporting data matrix");
                        }
                    }
                });
                return menu;
            }
        };
        tabItem.setControl((Control)chartComposite);
        this.tabFolder.showItem(tabItem);
        this.tabFolder.setSelection(tabItem);
    }

    public void addBarGraph(String windowTitle, final CategoryDataset[] categoryDataset, String[] graphNames, String[] xLabels, String[] yLabels, PlotOrientation orientation, boolean legend, boolean tooltips, boolean urls, boolean chart3D) {
        CTabItem tabItem = new CTabItem(this.tabFolder, 0);
        tabItem.setText(windowTitle);
        tabItem.setShowClose(true);
        SashForm sashForm = new SashForm((Composite)this.tabFolder, 256);
        sashForm.setLayout((Layout)new FillLayout());
        sashForm.setSashWidth(categoryDataset.length);
        int i = 0;
        while (i < categoryDataset.length) {
            JFreeChart chart = null;
            if (chart3D) {
                ChartFactory.createBarChart3D((String)graphNames[i], (String)xLabels[i], (String)yLabels[i], (CategoryDataset)categoryDataset[i], (PlotOrientation)orientation, (boolean)legend, (boolean)tooltips, (boolean)urls);
            } else {
                ChartFactory.createBarChart((String)graphNames[i], (String)xLabels[i], (String)yLabels[i], (CategoryDataset)categoryDataset[i], (PlotOrientation)orientation, (boolean)legend, (boolean)tooltips, (boolean)urls);
            }
            CategoryPlot categoryPlot = new CategoryPlot();
            if (chart3D) {
                renderer = (BarRenderer3D)categoryPlot.getRenderer();
                renderer.setBarPainter((BarPainter)new StandardBarPainter());
                renderer.setShadowVisible(false);
                renderer.setItemMargin(0.1);
                renderer.setDrawBarOutline(false);
                renderer.setSeriesPaint(0, (Paint)new Color(255, 80, 80));
            } else {
                renderer = new BarRenderer();
                renderer.setShadowVisible(false);
                renderer.setGradientPaintTransformer(null);
                categoryPlot.setRenderer((CategoryItemRenderer)renderer);
            }
            if (orientation == PlotOrientation.VERTICAL) {
                CategoryAxis domainAxis = categoryPlot.getDomainAxis();
                domainAxis.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)1.5707963267948966));
            }
            final int c = i++;
            new ChartComposite((Composite)sashForm, 0, chart, true){

                protected Menu createPopupMenu(boolean properties, boolean save, boolean print, boolean zoom) {
                    Menu menu = super.createPopupMenu(properties, save, print, zoom);
                    new MenuItem(menu, 2);
                    MenuItem newItem = new MenuItem(menu, 0);
                    newItem.setText("Export data matrix");
                    newItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            File fileSelection = StatsView.this.selectFile();
                            if (StatsView.this.exportBarDatasetMatrix(categoryDataset[c], fileSelection)) {
                                MessageDialog.openInformation((Shell)this.getShell(), (String)"Export data matrix", (String)"Exported successfully");
                            } else {
                                MessageDialog.openError((Shell)this.getShell(), (String)"Export data matrix", (String)"Error exporting data matrix");
                            }
                        }
                    });
                    return menu;
                }
            };
        }
        tabItem.setControl((Control)sashForm);
        this.tabFolder.showItem(tabItem);
        this.tabFolder.setSelection(tabItem);
    }

    public void addPieGraph(String windowTitle, final PieDataset pieDataset, String graphName, boolean legend, boolean tooltips, boolean urls, boolean chart3D) {
        CTabItem tabItem = new CTabItem(this.tabFolder, 0);
        tabItem.setText(graphName);
        tabItem.setShowClose(true);
        JFreeChart chart = null;
        if (chart3D) {
            chart = ChartFactory.createPieChart3D((String)graphName, (PieDataset)pieDataset, (boolean)legend, (boolean)tooltips, (boolean)urls);
            plot = (PiePlot3D)chart.getPlot();
            plot.setStartAngle(290.0);
            plot.setDirection(Rotation.CLOCKWISE);
            plot.setForegroundAlpha(0.7f);
            plot.setNoDataMessage("No data to display");
            plot.setLabelGenerator(null);
        } else {
            chart = ChartFactory.createPieChart((String)graphName, (PieDataset)pieDataset, (boolean)legend, (boolean)tooltips, (boolean)urls);
            plot = (PiePlot)chart.getPlot();
            plot.setSimpleLabels(false);
            StandardPieSectionLabelGenerator labels = new StandardPieSectionLabelGenerator("{0} ({1})");
            plot.setLabelGenerator((PieSectionLabelGenerator)labels);
        }
        ChartComposite chartComposite = new ChartComposite((Composite)this.tabFolder, 0, chart, true){

            protected Menu createPopupMenu(boolean properties, boolean save, boolean print, boolean zoom) {
                Menu menu = super.createPopupMenu(properties, save, print, zoom);
                new MenuItem(menu, 2);
                MenuItem newItem = new MenuItem(menu, 0);
                newItem.setText("Export data matrix");
                newItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        File fileSelection = StatsView.this.selectFile();
                        if (StatsView.this.exportPieDatasetMatrix(pieDataset, fileSelection)) {
                            MessageDialog.openInformation((Shell)this.getShell(), (String)"Export data matrix", (String)"Exported successfully");
                        } else {
                            MessageDialog.openError((Shell)this.getShell(), (String)"Export data matrix", (String)"Error exporting data matrix");
                        }
                    }
                });
                return menu;
            }
        };
        tabItem.setControl((Control)chartComposite);
        this.tabFolder.showItem(tabItem);
        this.tabFolder.setSelection(tabItem);
    }

    public void addPieGraph(String windowTitle, final PieDataset[] pieDataset, String[] graphName, boolean legend, boolean tooltips, boolean urls, boolean chart3D) {
        CTabItem tabItem = new CTabItem(this.tabFolder, 0);
        tabItem.setText(windowTitle);
        tabItem.setShowClose(true);
        SashForm sashForm = new SashForm((Composite)this.tabFolder, 256);
        sashForm.setLayout((Layout)new FillLayout());
        sashForm.setSashWidth(pieDataset.length);
        int i = 0;
        while (i < pieDataset.length) {
            JFreeChart chart = null;
            if (chart3D) {
                chart = ChartFactory.createPieChart3D((String)graphName[i], (PieDataset)pieDataset[i], (boolean)legend, (boolean)tooltips, (boolean)urls);
                plot = (PiePlot3D)chart.getPlot();
                plot.setStartAngle(290.0);
                plot.setDirection(Rotation.CLOCKWISE);
                plot.setForegroundAlpha(0.7f);
                plot.setNoDataMessage("No data to display");
                plot.setLabelGenerator(null);
            } else {
                chart = ChartFactory.createPieChart((String)graphName[i], (PieDataset)pieDataset[i], (boolean)legend, (boolean)tooltips, (boolean)urls);
                plot = (PiePlot)chart.getPlot();
                plot.setSimpleLabels(false);
                StandardPieSectionLabelGenerator labels = new StandardPieSectionLabelGenerator("{0} ({1})");
                plot.setLabelGenerator((PieSectionLabelGenerator)labels);
            }
            final int c = i++;
            new ChartComposite((Composite)sashForm, 0, chart, true){

                protected Menu createPopupMenu(boolean properties, boolean save, boolean print, boolean zoom) {
                    Menu menu = super.createPopupMenu(properties, save, print, zoom);
                    new MenuItem(menu, 2);
                    MenuItem newItem = new MenuItem(menu, 0);
                    newItem.setText("Export data matrix");
                    newItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            File fileSelection = StatsView.this.selectFile();
                            if (StatsView.this.exportPieDatasetMatrix(pieDataset[c], fileSelection)) {
                                MessageDialog.openInformation((Shell)this.getShell(), (String)"Export data matrix", (String)"Exported successfully");
                            } else {
                                MessageDialog.openError((Shell)this.getShell(), (String)"Export data matrix", (String)"Error exporting data matrix");
                            }
                        }
                    });
                    return menu;
                }
            };
        }
        tabItem.setControl((Control)sashForm);
        this.tabFolder.showItem(tabItem);
        this.tabFolder.setSelection(tabItem);
    }

    private File selectFile() {
        FileDialog dialog = new FileDialog(this.getSite().getShell(), 8192);
        dialog.setFilterNames(new String[]{"Comma separated values(CSV", "All files"});
        dialog.setFilterExtensions(new String[]{"*.csv", "*.*"});
        dialog.setFileName(".csv");
        if (this.lastSelectedFile == null) {
            this.lastSelectedFile = PreferenceManager.getInstance().get("workspace", "");
        }
        dialog.setFilterPath(this.lastSelectedFile);
        Object selection = dialog.open();
        if (selection != null) {
            if (!((String)selection).endsWith(".csv")) {
                selection = (String)selection + ".csv";
            }
        } else {
            return null;
        }
        this.lastSelectedFile = selection;
        return new File((String)selection);
    }

    private boolean exportPieDatasetMatrix(PieDataset pieDataset, File outputFile) {
        int itemCount = pieDataset.getItemCount();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile));){
            writer.append("\"KEY\";\"COUNT\";\n");
            int i = 0;
            while (i < itemCount) {
                writer.append("\"" + String.valueOf(pieDataset.getKey(i)) + "\";\"" + String.valueOf(pieDataset.getValue(i)) + "\";\n");
                ++i;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    private boolean exportBarDatasetMatrix(CategoryDataset categoryDataset, File outputFile) {
        int itemCount = categoryDataset.getColumnCount();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile));){
            writer.append("\"KEY\";\"COUNT\";\n");
            int i = 0;
            while (i < itemCount) {
                writer.append("\"" + String.valueOf(categoryDataset.getColumnKey(i)) + "\";\"" + String.valueOf(categoryDataset.getValue(0, i)) + "\";\n");
                ++i;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    private boolean exportXYDatasetMatrix(XYDataset xyDataset, File outputFile) {
        int itemCount = xyDataset.getItemCount(0);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputFile));){
            writer.append("\"VALUE\";\"COUNT\";\n");
            int i = 0;
            while (i < itemCount) {
                writer.append("\"" + (int)xyDataset.getXValue(0, i) + "\";\"" + (int)xyDataset.getYValue(0, i) + "\";\n");
                ++i;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    class CustomBarRenderer
    extends BarRenderer {
        private static final long serialVersionUID = 535083166512960717L;
        private Paint[] colors = new Paint[]{Color.red, Color.blue, Color.green, Color.yellow, Color.orange, Color.cyan, Color.magenta, Color.blue, Color.LIGHT_GRAY, Color.CYAN, Color.ORANGE, Color.PINK};

        public Paint getItemPaint(int row, int column) {
            return this.colors[column % this.colors.length];
        }
    }
}

