/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.views;

import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.metabolicPathEditor.main.MetabolicPathMainComposite;
import com.biotechvana.utils.PreferenceManager;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;

public class MetabolicPathsView
extends ViewPart {
    public static final String ID = "com.biotechvana.gydbpro.views.MetabolicPathsView";
    public static final String TITLE = "Metabolic Paths";
    private static File workspaceDirectory;
    private CTabFolder tabFolder;

    public static File getWorkspaceDirectory() {
        String workspacePath;
        if (workspaceDirectory == null && (workspacePath = PreferenceManager.getInstance().get("workspace", "")) != null && workspacePath.length() > 0) {
            workspaceDirectory = new File(workspacePath);
        }
        return workspaceDirectory;
    }

    public void createPartControl(Composite parent) {
        this.tabFolder = new CTabFolder(parent, 2048);
        this.tabFolder.setLayout((Layout)new FillLayout());
    }

    public void setFocus() {
    }

    public void addData(CSVEditor csvEditor, int sequenceColumnIndex, int enzymeCodeColumnIndex, int evidenceColumnIndex, int speciesColumnIndex, int colorMode) throws InvocationTargetException, InterruptedException {
        MetabolicPathMainComposite metabolicComposite = new MetabolicPathMainComposite((Composite)this.tabFolder, csvEditor, sequenceColumnIndex, enzymeCodeColumnIndex, evidenceColumnIndex, speciesColumnIndex, colorMode);
        metabolicComposite.setData();
        CTabItem tabItem = new CTabItem(this.tabFolder, 0);
        tabItem.setControl((Control)metabolicComposite);
        tabItem.setText(csvEditor.getTitle().replaceAll(".csv", ""));
        tabItem.setShowClose(true);
        this.tabFolder.showItem(tabItem);
        this.tabFolder.setSelection(tabItem);
    }
}

