/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.model;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WorksheetXmlManager {
    private File worksheetFile;
    private DocumentBuilderFactory domFactory;
    private DocumentBuilder builder;
    private Document doc;

    public WorksheetXmlManager() throws ParserConfigurationException, SAXException, IOException {
        String userHome = System.getProperty("user.home");
        this.worksheetFile = new File(userHome + File.separator + "GPRO_worksheet.xml");
        if (!this.worksheetFile.exists()) {
            this.createNewWorksheetFile();
        }
        this.domFactory = DocumentBuilderFactory.newInstance();
        this.domFactory.setNamespaceAware(true);
        this.builder = this.domFactory.newDocumentBuilder();
        this.doc = this.builder.parse(this.worksheetFile.getAbsolutePath());
    }

    private boolean createNewWorksheetFile() {
        try {
            this.worksheetFile.createNewFile();
            FileUtils.writeStringToFile((File)this.worksheetFile, (String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><worksheets></worksheets>");
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public String[] getSiteList() {
        ArrayList<String> listSites = new ArrayList<String>();
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        String expression = "/worksheets/worksheet/@id";
        try {
            XPathExpression expr = xpath.compile(expression);
            Object result = expr.evaluate(this.doc, XPathConstants.NODESET);
            NodeList nodes = (NodeList)result;
            int i = 0;
            while (i < nodes.getLength()) {
                listSites.add(nodes.item(i).getTextContent());
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return listSites.toArray(new String[listSites.size()]);
    }

    public int getIndexForWorksheetFile(String fileName) {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        String expression = "/worksheets/worksheet/@id";
        try {
            XPathExpression expr = xpath.compile(expression);
            Object result = expr.evaluate(this.doc, XPathConstants.NODESET);
            NodeList nodes = (NodeList)result;
            int i = 0;
            while (i < nodes.getLength()) {
                if (nodes.item(i).getTextContent().equalsIgnoreCase(fileName)) {
                    return i;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return -1;
    }

    public int getIndexForAssociatedFile(String fileName) {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        String expression = "/worksheets/worksheet/fasta";
        try {
            XPathExpression expr = xpath.compile(expression);
            Object result = expr.evaluate(this.doc, XPathConstants.NODESET);
            NodeList nodes = (NodeList)result;
            int i = 0;
            while (i < nodes.getLength()) {
                if (nodes.item(i).getTextContent().equalsIgnoreCase(fileName)) {
                    return i;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return -1;
    }

    public String getSiteInfoByName(String worksheetPath, String tag) {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        String expression = "/worksheets/worksheet[@id='" + worksheetPath + "']/" + tag;
        try {
            XPathExpression expr = xpath.compile(expression);
            Object result = expr.evaluate(this.doc, XPathConstants.STRING);
            return result.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getSiteInfoByIndex(int index, String tag) {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        String expression = "/worksheets/worksheet[" + (index + 1) + "]/" + tag;
        try {
            XPathExpression expr = xpath.compile(expression);
            Object result = expr.evaluate(this.doc, XPathConstants.STRING);
            return result.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public int[] getAssociatedColumnIndices(String worksheetName) {
        ArrayList<Integer> listIndices = new ArrayList<Integer>();
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        String expression = "/worksheets/worksheet[@id='" + worksheetName + "']/associatedIndices/associatedIndex";
        try {
            XPathExpression expr = xpath.compile(expression);
            Object result = expr.evaluate(this.doc, XPathConstants.NODESET);
            NodeList nodes = (NodeList)result;
            int i = 0;
            while (i < nodes.getLength()) {
                listIndices.add(Integer.parseInt(nodes.item(i).getTextContent()));
                ++i;
            }
            int[] arrayIndices = new int[listIndices.size()];
            int c = 0;
            Iterator iterator = listIndices.iterator();
            while (iterator.hasNext()) {
                int i2 = (Integer)iterator.next();
                arrayIndices[c++] = i2;
            }
            return arrayIndices;
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean saveSiteInfo(String worksheetName, String worksheetNameNew, String path, int[] associatedColumnIndices) {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        String expression = "/worksheets/worksheet[@id='" + worksheetName + "']/path";
        try {
            XPathExpression expr = xpath.compile(expression);
            Object result = expr.evaluate(this.doc, XPathConstants.NODE);
            Node n = (Node)result;
            n.setTextContent(path);
            expression = "/worksheets/worksheet[@id='" + worksheetName + "']/fasta";
            expr = xpath.compile(expression);
            result = expr.evaluate(this.doc, XPathConstants.NODE);
            n = (Node)result;
            expression = "/worksheets/worksheet[@id='" + worksheetName + "']";
            expr = xpath.compile(expression);
            result = expr.evaluate(this.doc, XPathConstants.NODE);
            n = (Node)result;
            Element e = (Element)n;
            e.setAttribute("id", worksheetNameNew);
            return this.saveXmlFile(this.doc);
        }
        catch (Exception e2) {
            return false;
        }
    }

    public boolean saveSiteTagByIndex(int index, String tag, String value) {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        String expression = "/worksheets/worksheet[" + (index + 1) + "]/" + tag;
        try {
            XPathExpression expr = xpath.compile(expression);
            Node node = (Node)expr.evaluate(this.doc, XPathConstants.NODE);
            node.setTextContent(value);
            if (!this.saveXmlFile(this.doc)) {
                System.err.println("saveSiteTagByIndex() -> Failed saving xml file");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean saveXmlFile(Document doc) {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(this.worksheetFile);
            transformer.transform(source, result);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean deleteSite(String worksheetName) {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        String expression = "/worksheets/worksheet[@id='" + worksheetName + "']";
        try {
            XPathExpression expr = xpath.compile(expression);
            Object result = expr.evaluate(this.doc, XPathConstants.NODE);
            Node n = (Node)result;
            Node parent = n.getParentNode();
            parent.removeChild(n);
            if (!this.saveXmlFile(this.doc)) {
                System.err.println("Error in WorkskeetXmlManager.deleteSite()");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean addSite(String worksheetPath, String fastaPath, int[] associatedColumnIndices, String separator) {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        String expression = "/worksheets";
        try {
            XPathExpression expr = xpath.compile(expression);
            Object result = expr.evaluate(this.doc, XPathConstants.NODE);
            Node parent = (Node)result;
            Element worksheetElement = this.doc.createElement("worksheet");
            worksheetElement.setAttribute("id", worksheetPath);
            worksheetElement.setAttribute("default", "false");
            parent.appendChild(worksheetElement);
            Element fastaElement = this.doc.createElement("fasta");
            fastaElement.setTextContent(fastaPath);
            worksheetElement.appendChild(fastaElement);
            Element associatedIndicesElement = this.doc.createElement("associatedIndices");
            worksheetElement.appendChild(associatedIndicesElement);
            int[] nArray = associatedColumnIndices;
            int n = associatedColumnIndices.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                Element associatedIndexElement = this.doc.createElement("associatedIndex");
                associatedIndexElement.setTextContent(String.valueOf(i));
                associatedIndicesElement.appendChild(associatedIndexElement);
                ++n2;
            }
            Element separatorElement = this.doc.createElement("separator");
            separatorElement.setTextContent(separator);
            worksheetElement.appendChild(separatorElement);
            return this.saveXmlFile(this.doc);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean setDefaultSite(String worksheetName) {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        Object expression = "/worksheets/worksheet";
        try {
            XPathExpression expr = xpath.compile((String)expression);
            Object nodeset = expr.evaluate(this.doc, XPathConstants.NODESET);
            NodeList nodeList = (NodeList)nodeset;
            int i = 0;
            while (i < nodeList.getLength()) {
                Node n = nodeList.item(i);
                Element e1 = (Element)n;
                e1.setAttribute("default", "false");
                ++i;
            }
            expression = "/worksheets/worksheet[@id='" + worksheetName + "']";
            expr = xpath.compile((String)expression);
            Object result = expr.evaluate(this.doc, XPathConstants.NODE);
            Node parent = (Node)result;
            Element e2 = (Element)parent;
            e2.setAttribute("default", "true");
            if (!this.saveXmlFile(this.doc)) {
                System.err.println("WorksheetXmlManager.setDefaultSite()");
                return false;
            }
            return true;
        }
        catch (Exception e3) {
            return false;
        }
    }

    public String getDefaultSite() {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        String expression = "/worksheets/worksheet[@default='true']";
        try {
            XPathExpression expr = xpath.compile(expression);
            Object node = expr.evaluate(this.doc, XPathConstants.NODE);
            if (node == null) {
                return this.setFirstAsDefault();
            }
            Node nodeDefault = (Node)node;
            Element e = (Element)nodeDefault;
            return e.getAttribute("id");
        }
        catch (Exception e1) {
            return null;
        }
    }

    public File getSiteFile() {
        return this.worksheetFile;
    }

    private String setFirstAsDefault() {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        String expression = "/worksheets/worksheet[1]";
        try {
            XPathExpression expr = xpath.compile(expression);
            Object node = expr.evaluate(this.doc, XPathConstants.NODE);
            if (node != null) {
                Element e = (Element)node;
                e.setAttribute("default", "true");
                return e.getAttribute("id");
            }
            return null;
        }
        catch (Exception e1) {
            return null;
        }
    }
}

