/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.model;

import com.biotechvana.csvUtils.WorksheetUtils;
import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.goAnnotation.GOGraphModel;
import com.biotechvana.csveditor.goAnnotation.GOTerm;
import com.biotechvana.csveditor.model.GoLevel;
import com.biotechvana.csveditor.views.statistics.StatisticsView;
import com.biotechvana.e3utils.WorkspaceUtils;
import com.biotechvana.utils.PreferenceManager;
import java.awt.Color;
import java.awt.Paint;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class StatisticsModel {
    public static int MAX_EVALUE_EXPONENT = 180;
    private static final String CATEGORY_CC = "CC";
    private static final String CATEGORY_BP = "BP";
    private static final String CATEGORY_MF = "MF";
    private final Pattern patternCC = Pattern.compile("^(\\[?C\\])?\\s*(GO:)?(\\d+)(:\\s*(.+)(\\(w+\\))?)?$");
    private final Pattern patternMF = Pattern.compile("^(\\[?F\\])?\\s*(GO:)?(\\d+)(:\\s*(.+)(\\(w+\\))?)?$");
    private final Pattern patternBP = Pattern.compile("^(\\[?P\\])?\\s*(GO:)?(\\d+)(:\\s*(.+)(\\(w+\\))?)?$");

    public static XYDataset createXYDataset(int[] Xmatrix, int[] Ymatrix) {
        XYSeries series1 = new XYSeries((Comparable)((Object)"First"));
        int i = 0;
        while (i < Xmatrix.length) {
            series1.add((double)Xmatrix[i], (double)Ymatrix[i]);
            ++i;
        }
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(series1);
        return dataset;
    }

    public CategoryDataset createBarDataset(String[] categoriesMatrix, Integer[] integers) {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        int i = 0;
        while (i < categoriesMatrix.length) {
            dataset.addValue((Number)integers[i], (Comparable)((Object)categoriesMatrix[i]), (Comparable)((Object)categoriesMatrix[i]));
            ++i;
        }
        return dataset;
    }

    public XYDataset generateEValueDataset(List<List<String>> csvModel, int columnEvalue, double smoothFactor, IProgressMonitor monitor) throws NumberFormatException, NullPointerException, InterruptedException {
        ArrayList<String> eValueOrigDataStr = new ArrayList<String>();
        ArrayList<Double> eValueOrigData = new ArrayList<Double>();
        ArrayList<Integer> eValueLogData = new ArrayList<Integer>();
        if (csvModel == null) {
            throw new NullPointerException("Model is null");
        }
        monitor.beginTask("Generating evalue dataset...", csvModel.size() * 4);
        monitor.subTask("Reading column values...");
        int colCount = 0;
        for (List<String> l : csvModel) {
            String value = l.get(columnEvalue).trim();
            if (value.length() > 0) {
                eValueOrigDataStr.add(l.get(columnEvalue));
                ++colCount;
            }
            monitor.worked(1);
            if (!monitor.isCanceled()) continue;
            throw new InterruptedException();
        }
        monitor.subTask("Parsing values as double...");
        colCount = 0;
        for (String data : eValueOrigDataStr) {
            if (data.trim().length() < 0) continue;
            try {
                eValueOrigData.add(colCount, Double.parseDouble(WorksheetUtils.parseEvalueColValue((String)data.trim())));
            }
            catch (Exception ex) {
                throw new NumberFormatException("Not a numeric value '" + data + "'");
            }
            int exp = (int)Math.round(Math.log10((Double)eValueOrigData.get(colCount)));
            if (-exp >= MAX_EVALUE_EXPONENT) {
                exp = -MAX_EVALUE_EXPONENT;
            }
            if ((Double)eValueOrigData.get(colCount) == 0.0) {
                exp = -MAX_EVALUE_EXPONENT;
            }
            if (exp >= 0) {
                exp = -exp;
            }
            try {
                eValueLogData.add(colCount, -exp);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++colCount;
            monitor.worked(1);
            if (!monitor.isCanceled()) continue;
            throw new InterruptedException();
        }
        int[] xValues = new int[MAX_EVALUE_EXPONENT + 1];
        int[] yValues = new int[MAX_EVALUE_EXPONENT + 1];
        monitor.subTask("Initializing dataset matrix...");
        int i = 0;
        while (i < xValues.length) {
            xValues[i] = i;
            yValues[i] = 0;
            monitor.worked(1);
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            ++i;
        }
        monitor.subTask("Counting values...");
        i = 0;
        while (i < eValueLogData.size()) {
            int yscale;
            int n = yscale = ((Integer)eValueLogData.get(i)).intValue();
            yValues[n] = yValues[n] + 1;
            monitor.worked(1);
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            ++i;
        }
        monitor.subTask("Finished");
        monitor.done();
        return StatisticsModel.createXYDataset(xValues, yValues);
    }

    public XYDataset generateSimpleDistributionDataset(List<List<String>> csvModel, String xLabel, int column, double smoothfactor, String columnName, IProgressMonitor monitor) throws NumberFormatException, NullPointerException, InterruptedException, StatisticsTooSmallNumberException {
        ArrayList<String> origDataStr = new ArrayList<String>();
        if (monitor != null) {
            monitor.beginTask("Creating statistics...", csvModel.size());
        }
        if (monitor != null) {
            monitor.subTask("Reading column contents...");
        }
        int colCount = 0;
        colCount = 0;
        for (List<String> l : csvModel) {
            String data = l.get(column);
            if (data != null && !data.isEmpty()) {
                origDataStr.add(l.get(column));
                ++colCount;
            }
            if (monitor == null) continue;
            monitor.worked(1);
            if (!monitor.isCanceled()) continue;
            throw new InterruptedException();
        }
        if (monitor != null) {
            monitor.subTask("Parsing data to double...");
        }
        double[] similOrigData = new double[colCount + 1];
        int[] similIntData = new int[colCount + 1];
        colCount = 0;
        for (String data : origDataStr) {
            if (data.length() == 0) {
                data = "0";
            }
            try {
                similOrigData[colCount] = Double.parseDouble(WorksheetUtils.parseColValueAuto((String)columnName, (String)data.trim()));
                if (similOrigData[colCount] < 0.001) {
                    throw new StatisticsTooSmallNumberException();
                }
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
                throw new NumberFormatException("Invalid numerical value '" + data + "'");
            }
            ++colCount;
        }
        Double maxValueReal = StatisticsModel.getMaxValue(similOrigData);
        Double minValueReal = StatisticsModel.getMinValue(similOrigData);
        int ampFactor = 1;
        if (maxValueReal < 1.0) {
            int i = 1;
            while (maxValueReal < 80.0) {
                ampFactor = 0xA ^ i;
                maxValueReal = maxValueReal * (double)ampFactor;
                ++i;
            }
        }
        int j = 0;
        while (j < similOrigData.length) {
            int lclint;
            similOrigData[j] = similOrigData[j] * (double)ampFactor;
            similIntData[j] = lclint = (int)Math.round(similOrigData[j]);
            ++j;
        }
        int maxValue = StatisticsModel.getMaxValue(similIntData);
        int minValue = StatisticsModel.getMinValue(similIntData);
        if (ampFactor != 1) {
            maxValueReal = StatisticsModel.getMaxValue(similOrigData);
            minValueReal = StatisticsModel.getMinValue(similOrigData);
            maxValue = StatisticsModel.getMaxValue(similIntData);
            minValue = StatisticsModel.getMinValue(similIntData);
        }
        int catSize = maxValue + 1;
        int[] xValues = new int[catSize];
        int[] yValues = new int[catSize];
        if (monitor != null) {
            monitor.subTask("Initializing dataset matrix...");
        }
        int i = 0;
        while (i < xValues.length) {
            xValues[i] = i;
            yValues[i] = 0;
            ++i;
        }
        if (monitor != null) {
            monitor.subTask("Counting values");
        }
        i = 0;
        while (i < similIntData.length) {
            int yscale;
            int n = yscale = similIntData[i];
            yValues[n] = yValues[n] + 1;
            ++i;
        }
        if (ampFactor != 1) {
            xLabel = (String)xLabel + " x10e" + ampFactor;
        }
        if (monitor != null) {
            monitor.done();
        }
        return StatisticsModel.createXYDataset(xValues, yValues);
    }

    public static int getMaxValue(int[] numbers) {
        int maxValue = numbers[0];
        int i = 1;
        while (i < numbers.length) {
            if (numbers[i] > maxValue) {
                maxValue = numbers[i];
            }
            ++i;
        }
        return maxValue;
    }

    public static int getMaxValue(Integer[] numbers) {
        int maxValue = numbers[0];
        int i = 1;
        while (i < numbers.length) {
            if (numbers[i] > maxValue) {
                maxValue = numbers[i];
            }
            ++i;
        }
        return maxValue;
    }

    public static double getMaxValue(double[] numbers) throws NullPointerException {
        if (numbers == null || numbers.length < 2) {
            throw new NullPointerException("Null values or comparing less than 2 values");
        }
        double maxValue = numbers[0];
        int i = 1;
        while (i < numbers.length) {
            if (numbers[i] > maxValue) {
                maxValue = numbers[i];
            }
            ++i;
        }
        return maxValue;
    }

    public static int getMinValue(int[] numbers) throws NullPointerException {
        if (numbers == null || numbers.length < 2) {
            throw new NullPointerException("Null values or comparing less than 2 values");
        }
        int minValue = numbers[0];
        int i = 1;
        while (i < numbers.length) {
            if (numbers[i] < minValue) {
                minValue = numbers[i];
            }
            ++i;
        }
        return minValue;
    }

    public static double getMinValue(double[] numbers) {
        double minValue = numbers[0];
        int i = 1;
        while (i < numbers.length) {
            if (numbers[i] < minValue) {
                minValue = numbers[i];
            }
            ++i;
        }
        return minValue;
    }

    public void generateAnnotationDistrStatistics(int goDataColumn, int ecDataColumn, CSVEditor csvEditor, String graphTitle, List<String> graphOptions, List<String> statisticsTypeOptions) {
        String[] clasesAnnotations;
        int evalueCol;
        boolean withECcodes = false;
        double evalueThreshold = 1.0E-4;
        Integer counterBlastNoHits = 0;
        Integer counterBlastNoSig = 0;
        Integer counterBlastSigNOGO = 0;
        Integer counterBlastSigGO = 0;
        Integer counterBlastSigGOEC = 0;
        Integer counterTotal = 0;
        for (String ops : statisticsTypeOptions) {
            if (!ops.contains("with EC codes")) continue;
            withECcodes = true;
        }
        String v = PreferenceManager.getInstance().get("evalueThreshold", "");
        if (!v.isEmpty()) {
            evalueThreshold = Double.parseDouble(v);
        }
        if ((evalueCol = csvEditor.getColumnIndexForName("e-value")) < 0) {
            return;
        }
        for (List l : (List)csvEditor.getModel()) {
            String eValueStr;
            String GOstr = (String)l.get(goDataColumn);
            String ECstr = "";
            if (withECcodes) {
                ECstr = (String)l.get(ecDataColumn);
            }
            if (!(eValueStr = (String)l.get(evalueCol)).isEmpty()) {
                Double eValue = Double.parseDouble(eValueStr.trim().replace(',', '.'));
                if (eValue < evalueThreshold) {
                    if (GOstr != null || !GOstr.contains("--UD--")) {
                        String[] splitedDataGO = GOstr.split(";");
                        int cuentaGos = 0;
                        String[] stringArray = splitedDataGO;
                        int n = splitedDataGO.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String d = stringArray[n2];
                            if (!d.contains("--UD--")) {
                                ++cuentaGos;
                            }
                            ++n2;
                        }
                        if (cuentaGos > 0) {
                            counterBlastSigGO = counterBlastSigGO + 1;
                            String[] splitedDataEC = ECstr.split(";");
                            int cuentaECs = 0;
                            String[] stringArray2 = splitedDataEC;
                            int n3 = splitedDataEC.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                String e = stringArray2[n4];
                                if (!e.contains("--UD--")) {
                                    ++cuentaECs;
                                }
                                ++n4;
                            }
                            if (cuentaECs > 0) {
                                counterBlastSigGOEC = counterBlastSigGOEC + 1;
                            }
                        } else {
                            counterBlastSigNOGO = counterBlastSigNOGO + 1;
                        }
                    } else {
                        counterBlastSigNOGO = counterBlastSigNOGO + 1;
                    }
                } else {
                    counterBlastNoSig = counterBlastNoSig + 1;
                }
            } else {
                counterBlastNoHits = counterBlastNoHits + 1;
            }
            counterTotal = counterTotal + 1;
        }
        Integer[] countAnnotations = new Integer[]{counterBlastNoHits, counterBlastNoSig, counterBlastSigNOGO, counterBlastSigGO, counterBlastSigGOEC, counterTotal};
        if (withECcodes) {
            clasesAnnotations = new String[]{"NoBlastHits", "NoSigBlastHits", "Mapped", "GO Annot.", "GO+EC Annot", "Total"};
            countAnnotations = new Integer[]{counterBlastNoHits, counterBlastNoSig, counterBlastSigNOGO, counterBlastSigGO, counterBlastSigGOEC, counterTotal};
        } else {
            clasesAnnotations = new String[]{"NoBlastHits", "NoSigBlastHits", "Mapped", "GO Annot.", "Total"};
            countAnnotations = new Integer[]{counterBlastNoHits, counterBlastNoSig, counterBlastSigNOGO, counterBlastSigGO, counterBlastSigGOEC, counterTotal};
        }
        StatisticsView statisticsView = (StatisticsView)WorkspaceUtils.findView((String)"com.biotechvana.gydbpro.views.statistics.StatisticsView");
        String xLabel = "";
        String chartTitle = graphTitle;
        Paint[] barColors = new Color[]{Color.red, Color.pink, Color.blue, Color.green, Color.yellow};
        statisticsView.generateBarChart(clasesAnnotations, countAnnotations, chartTitle, xLabel, null, barColors);
    }

    public CategoryDataset generateCategoryDataset(List<List<String>> model, int columnIndex, int maxCategories, int minPercent, IProgressMonitor monitor) throws NullPointerException, IndexOutOfBoundsException, InterruptedException {
        int modelLength = model.size();
        DefaultCategoryDataset categoryDataset = new DefaultCategoryDataset();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (model == null) {
            throw new NullPointerException("Model is null");
        }
        monitor.beginTask("Category statistics", modelLength);
        monitor.subTask("Reading data column");
        int i = 0;
        while (i < modelLength) {
            String key = model.get(i).get(columnIndex);
            if (key != null && key.length() != 0) {
                if (map.containsKey(key)) {
                    Integer value = (Integer)map.get(key);
                    value = value + 1;
                    map.put(key, value);
                } else {
                    map.put(key, 1);
                }
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
            }
            ++i;
        }
        monitor.subTask("Sorting categories");
        List<String> sortedKeys = StatisticsModel.sortByValue(map);
        int countCategories = map.size();
        int countItems = 0;
        int minItems = 0;
        int countOthers = 0;
        int i2 = 0;
        while (i2 < sortedKeys.size()) {
            countItems += ((Integer)map.get(sortedKeys.get(i2))).intValue();
            ++i2;
        }
        minItems = countItems / 100 * minPercent;
        if (countCategories > maxCategories) {
            i2 = countCategories - 1;
            while (i2 > countCategories - maxCategories) {
                if ((Integer)map.get(sortedKeys.get(i2)) >= minItems) {
                    categoryDataset.addValue((Number)map.get(sortedKeys.get(i2)), (Comparable)((Object)"Sequences"), (Comparable)((Object)sortedKeys.get(i2)));
                } else {
                    countOthers += ((Integer)map.get(sortedKeys.get(i2))).intValue();
                }
                --i2;
            }
            i2 = countCategories - maxCategories;
            while (i2 > 0) {
                countOthers += ((Integer)map.get(sortedKeys.get(i2))).intValue();
                --i2;
            }
            categoryDataset.addValue((double)countOthers, (Comparable)((Object)"Sequences"), (Comparable)((Object)"Others"));
        } else {
            i2 = countCategories - 1;
            while (i2 >= 0) {
                categoryDataset.addValue((Number)map.get(sortedKeys.get(i2)), (Comparable)((Object)"Sequences"), (Comparable)((Object)sortedKeys.get(i2)));
                --i2;
            }
        }
        monitor.done();
        return categoryDataset;
    }

    public PieDataset[] generateGoPieDataset(List<List<String>> model, int column, int maxCategories, int minPercent, IProgressMonitor monitor) throws NullPointerException, IndexOutOfBoundsException, InterruptedException, ClassNotFoundException, SQLException {
        return this.generateGoPieDataset(model, column, maxCategories, minPercent, 0, monitor);
    }

    private PieDataset[] generateGoPieDataset(List<List<String>> model, int column, int maxCategories, int minPercent, int level, IProgressMonitor monitor) throws NullPointerException, IndexOutOfBoundsException, InterruptedException, ClassNotFoundException, SQLException {
        try {
            DefaultPieDataset[] dataset = new DefaultPieDataset[3];
            int modelLength = model.size();
            Map<String, Integer> mapCC = new HashMap<String, Integer>();
            Map<String, Integer> mapMF = new HashMap<String, Integer>();
            Map<String, Integer> mapBP = new HashMap<String, Integer>();
            dataset[0] = new DefaultPieDataset();
            dataset[1] = new DefaultPieDataset();
            dataset[2] = new DefaultPieDataset();
            if (model == null) {
                throw new NullPointerException("Model is null");
            }
            int taskLength = modelLength + 3;
            if (level > 0) {
                ++taskLength;
            }
            monitor.beginTask("GO pie dataset", taskLength);
            monitor.subTask("Reading column data");
            int i = 0;
            while (i < modelLength) {
                String key = model.get(i).get(column);
                if (key != null && key.length() != 0) {
                    String[] tokens = key.trim().split(";");
                    StringBuilder builder = new StringBuilder();
                    String[] stringArray = tokens;
                    int n = tokens.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Integer value;
                        String t;
                        String token = stringArray[n2];
                        token = token.trim();
                        builder = new StringBuilder();
                        Matcher matcherCC = this.patternCC.matcher(token);
                        Matcher matcherMF = this.patternMF.matcher(token);
                        Matcher matcherBP = this.patternBP.matcher(token);
                        if (matcherCC.matches()) {
                            builder.append(matcherCC.group(2));
                            builder.append(matcherCC.group(3));
                            if (matcherCC.group(5) != null && matcherCC.group(5).length() > 0 && matcherCC.group(5) != "null") {
                                builder.append(" " + matcherCC.group(5));
                            }
                            if (mapCC.containsKey(t = builder.toString())) {
                                value = mapCC.get(t);
                                value = value + 1;
                                mapCC.put(t, value);
                            } else {
                                mapCC.put(t, 1);
                            }
                        }
                        if (matcherMF.matches()) {
                            builder.append(matcherMF.group(2));
                            builder.append(matcherMF.group(3));
                            if (matcherMF.group(5) != null && matcherMF.group(5).length() > 0 && matcherMF.group(5) != "null") {
                                builder.append(" " + matcherMF.group(5));
                            }
                            if (mapMF.containsKey(t = builder.toString())) {
                                value = mapMF.get(t);
                                value = value + 1;
                                mapMF.put(t, value);
                            } else {
                                mapMF.put(t, 1);
                            }
                        }
                        if (matcherBP.matches()) {
                            builder.append(matcherBP.group(2));
                            builder.append(matcherBP.group(3));
                            if (matcherBP.group(5) != null && matcherBP.group(5).length() > 0 && matcherBP.group(5) != "null") {
                                builder.append(" " + matcherBP.group(5));
                            }
                            if (mapBP.containsKey(t = builder.toString())) {
                                value = mapBP.get(t);
                                value = value + 1;
                                mapBP.put(t, value);
                            } else {
                                mapBP.put(t, 1);
                            }
                        }
                        ++n2;
                    }
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                }
                ++i;
            }
            if (level > 0 && level < 16) {
                monitor.subTask("Filtering by level");
                GoLevel goLevel = new GoLevel();
                goLevel.initConnection();
                try {
                    mapMF = goLevel.filterByLevel(mapMF, level);
                    mapBP = goLevel.filterByLevel(mapBP, level);
                    mapCC = goLevel.filterByLevel(mapCC, level);
                }
                catch (GoLevel.GoLevelConnectionNotStarted key) {
                    // empty catch block
                }
                goLevel.closeConnection();
                monitor.worked(1);
            }
            monitor.subTask("Parsing Mollecular Function");
            List<String> sortedKeysMF = StatisticsModel.sortByValue(mapMF);
            int countCategoriesMF = mapMF.size();
            int countItemsMF = 0;
            int minItemsMF = 0;
            int countOthersMF = 0;
            int i2 = 0;
            while (i2 < sortedKeysMF.size()) {
                countItemsMF += mapMF.get(sortedKeysMF.get(i2)).intValue();
                ++i2;
            }
            minItemsMF = countItemsMF / 100 * minPercent;
            if (countCategoriesMF > maxCategories) {
                i2 = countCategoriesMF - 1;
                while (i2 > countCategoriesMF - maxCategories) {
                    if (mapMF.get(sortedKeysMF.get(i2)) >= minItemsMF) {
                        dataset[0].setValue((Comparable)((Object)sortedKeysMF.get(i2)), (Number)mapMF.get(sortedKeysMF.get(i2)));
                    } else {
                        countOthersMF += mapMF.get(sortedKeysMF.get(i2)).intValue();
                    }
                    --i2;
                }
                i2 = countCategoriesMF - maxCategories;
                while (i2 > 0) {
                    countOthersMF += mapMF.get(sortedKeysMF.get(i2)).intValue();
                    --i2;
                }
                dataset[0].setValue((Comparable)((Object)"Others"), (double)countOthersMF);
            } else {
                i2 = countCategoriesMF - 1;
                while (i2 > 0) {
                    dataset[0].setValue((Comparable)((Object)sortedKeysMF.get(i2)), (Number)mapMF.get(sortedKeysMF.get(i2)));
                    --i2;
                }
            }
            monitor.worked(1);
            monitor.subTask("Parsing Cellular Component");
            List<String> sortedKeysCC = StatisticsModel.sortByValue(mapCC);
            int countCategoriesCC = mapCC.size();
            int countItemsCC = 0;
            int minItemsCC = 0;
            int countOthersCC = 0;
            int i3 = 0;
            while (i3 < sortedKeysCC.size()) {
                countItemsCC += mapCC.get(sortedKeysCC.get(i3)).intValue();
                ++i3;
            }
            minItemsCC = countItemsCC / 100 * minPercent;
            if (countCategoriesCC > maxCategories) {
                i3 = countCategoriesCC - 1;
                while (i3 > countCategoriesCC - maxCategories) {
                    if (mapCC.get(sortedKeysCC.get(i3)) >= minItemsCC) {
                        dataset[1].setValue((Comparable)((Object)sortedKeysCC.get(i3)), (Number)mapCC.get(sortedKeysCC.get(i3)));
                    } else {
                        countOthersCC += mapCC.get(sortedKeysCC.get(i3)).intValue();
                    }
                    --i3;
                }
                i3 = countCategoriesCC - maxCategories;
                while (i3 > 0) {
                    countOthersCC += mapCC.get(sortedKeysCC.get(i3)).intValue();
                    --i3;
                }
                dataset[1].setValue((Comparable)((Object)"Others"), (double)countOthersCC);
            } else {
                i3 = countCategoriesCC - 1;
                while (i3 > 0) {
                    dataset[1].setValue((Comparable)((Object)sortedKeysCC.get(i3)), (Number)mapCC.get(sortedKeysCC.get(i3)));
                    --i3;
                }
            }
            monitor.worked(1);
            monitor.subTask("Parsing Biological Process");
            List<String> sortedKeysBP = StatisticsModel.sortByValue(mapBP);
            int countCategoriesBP = mapBP.size();
            int countItemsBP = 0;
            int minItemsBP = 0;
            int countOthersBP = 0;
            int i4 = 0;
            while (i4 < sortedKeysBP.size()) {
                countItemsBP += mapBP.get(sortedKeysBP.get(i4)).intValue();
                ++i4;
            }
            minItemsBP = countItemsBP / 100 * minPercent;
            if (countCategoriesBP > maxCategories) {
                i4 = countCategoriesBP - 1;
                while (i4 > countCategoriesBP - maxCategories) {
                    if (mapBP.get(sortedKeysBP.get(i4)) >= minItemsBP) {
                        dataset[2].setValue((Comparable)((Object)sortedKeysBP.get(i4)), (Number)mapBP.get(sortedKeysBP.get(i4)));
                    } else {
                        countOthersBP += mapBP.get(sortedKeysBP.get(i4)).intValue();
                    }
                    --i4;
                }
                i4 = countCategoriesBP - maxCategories;
                while (i4 > 0) {
                    countOthersBP += mapBP.get(sortedKeysBP.get(i4)).intValue();
                    --i4;
                }
                dataset[2].setValue((Comparable)((Object)"Others"), (double)countOthersBP);
            } else {
                i4 = countCategoriesBP - 1;
                while (i4 > 0) {
                    dataset[2].setValue((Comparable)((Object)sortedKeysBP.get(i4)), (Number)mapBP.get(sortedKeysBP.get(i4)));
                    --i4;
                }
            }
            monitor.worked(1);
            DefaultPieDataset[] defaultPieDatasetArray = dataset;
            return defaultPieDatasetArray;
        }
        finally {
            monitor.done();
        }
    }

    public PieDataset generateGoTotalPieDataset(List<List<String>> model, int column, IProgressMonitor monitor) throws InterruptedException, ClassNotFoundException, SQLException {
        return this.generateGoTotalPieDataset(model, column, 0, monitor);
    }

    private PieDataset generateGoTotalPieDataset(List<List<String>> model, int column, int level, IProgressMonitor monitor) throws InterruptedException, ClassNotFoundException, SQLException {
        GoLevel goLevel = new GoLevel();
        try {
            DefaultPieDataset dataset = new DefaultPieDataset();
            int modelLength = model.size();
            HashMap<String, Integer> mapCategory = new HashMap<String, Integer>();
            String CC = "[C]";
            String MF = "[F]";
            String BP = "[P]";
            goLevel.initConnection();
            mapCategory.put(CATEGORY_CC, 0);
            mapCategory.put(CATEGORY_MF, 0);
            mapCategory.put(CATEGORY_BP, 0);
            monitor.beginTask("GO overall dataset", modelLength);
            monitor.subTask("Reading data column");
            int i = 0;
            while (i < modelLength) {
                String key = model.get(i).get(column);
                if (key != null && key.length() != 0) {
                    String[] tokens;
                    String[] stringArray = tokens = key.trim().split(";");
                    int n = tokens.length;
                    int n2 = 0;
                    while (n2 < n) {
                        block22: {
                            String token = stringArray[n2];
                            if ((token = token.trim()).length() > 0) {
                                if (level > 0) {
                                    try {
                                        int termLevel = goLevel.getLevel(token);
                                        if (termLevel != level) break block22;
                                        if (token.indexOf("[C]") == 0) {
                                            value = (Integer)mapCategory.get(CATEGORY_CC);
                                            value = value + 1;
                                            mapCategory.put(CATEGORY_CC, value);
                                        } else if (token.indexOf("[F]") == 0) {
                                            value = (Integer)mapCategory.get(CATEGORY_MF);
                                            value = value + 1;
                                            mapCategory.put(CATEGORY_MF, value);
                                        } else if (token.indexOf("[P]") == 0) {
                                            value = (Integer)mapCategory.get(CATEGORY_BP);
                                            value = value + 1;
                                            mapCategory.put(CATEGORY_BP, value);
                                        }
                                    }
                                    catch (GoLevel.GoLevelConnectionNotStarted e) {
                                        e.printStackTrace();
                                    }
                                } else if (token.indexOf("[C]") == 0) {
                                    Integer value = (Integer)mapCategory.get(CATEGORY_CC);
                                    value = value + 1;
                                    mapCategory.put(CATEGORY_CC, value);
                                } else if (token.indexOf("[F]") == 0) {
                                    Integer value = (Integer)mapCategory.get(CATEGORY_MF);
                                    value = value + 1;
                                    mapCategory.put(CATEGORY_MF, value);
                                } else if (token.indexOf("[P]") == 0) {
                                    Integer value = (Integer)mapCategory.get(CATEGORY_BP);
                                    value = value + 1;
                                    mapCategory.put(CATEGORY_BP, value);
                                }
                            }
                        }
                        ++n2;
                    }
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                }
                ++i;
            }
            dataset.setValue((Comparable)((Object)"Cellular Component"), (Number)mapCategory.get(CATEGORY_CC));
            dataset.setValue((Comparable)((Object)"Molecular Function"), (Number)mapCategory.get(CATEGORY_MF));
            dataset.setValue((Comparable)((Object)"Biological Process"), (Number)mapCategory.get(CATEGORY_BP));
            DefaultPieDataset defaultPieDataset = dataset;
            return defaultPieDataset;
        }
        finally {
            goLevel.closeConnection();
            monitor.done();
        }
    }

    public CategoryDataset generateGoTotalBarDataset(List<List<String>> model, int column, IProgressMonitor monitor) throws InterruptedException, ClassNotFoundException, SQLException {
        return this.generateGoTotalBarDataset(model, column, 0, monitor);
    }

    private CategoryDataset generateGoTotalBarDataset(List<List<String>> model, int column, int level, IProgressMonitor monitor) throws InterruptedException, ClassNotFoundException, SQLException {
        GoLevel goLevel = new GoLevel();
        try {
            DefaultCategoryDataset dataset = new DefaultCategoryDataset();
            int modelLength = model.size();
            HashMap<String, Integer> mapCategories = new HashMap<String, Integer>();
            String CC = "[C]";
            String MF = "[F]";
            String BP = "[P]";
            goLevel.initConnection();
            monitor.beginTask("GO overall bar dataset", modelLength);
            mapCategories.put(CATEGORY_CC, 0);
            mapCategories.put(CATEGORY_MF, 0);
            mapCategories.put(CATEGORY_BP, 0);
            int i = 0;
            while (i < modelLength) {
                String key = model.get(i).get(column);
                if (key != null && key.length() != 0) {
                    String[] tokens;
                    String[] stringArray = tokens = key.trim().split(";");
                    int n = tokens.length;
                    int n2 = 0;
                    while (n2 < n) {
                        block22: {
                            String token = stringArray[n2];
                            if ((token = token.trim()).length() > 0) {
                                if (level > 0) {
                                    try {
                                        int termLevel = goLevel.getLevel(token);
                                        if (termLevel != level) break block22;
                                        if (token.indexOf("[C]") == 0) {
                                            value = (Integer)mapCategories.get(CATEGORY_CC);
                                            value = value + 1;
                                            mapCategories.put(CATEGORY_CC, value);
                                        } else if (token.indexOf("[F]") == 0) {
                                            value = (Integer)mapCategories.get(CATEGORY_MF);
                                            value = value + 1;
                                            mapCategories.put(CATEGORY_MF, value);
                                        } else if (token.indexOf("[P]") == 0) {
                                            value = (Integer)mapCategories.get(CATEGORY_BP);
                                            value = value + 1;
                                            mapCategories.put(CATEGORY_BP, value);
                                        }
                                    }
                                    catch (GoLevel.GoLevelConnectionNotStarted e) {
                                        e.printStackTrace();
                                    }
                                } else if (token.indexOf("[C]") == 0) {
                                    Integer value = (Integer)mapCategories.get(CATEGORY_CC);
                                    value = value + 1;
                                    mapCategories.put(CATEGORY_CC, value);
                                } else if (token.indexOf("[F]") == 0) {
                                    Integer value = (Integer)mapCategories.get(CATEGORY_MF);
                                    value = value + 1;
                                    mapCategories.put(CATEGORY_MF, value);
                                } else if (token.indexOf("[P]") == 0) {
                                    Integer value = (Integer)mapCategories.get(CATEGORY_BP);
                                    value = value + 1;
                                    mapCategories.put(CATEGORY_BP, value);
                                }
                            }
                        }
                        ++n2;
                    }
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                }
                ++i;
            }
            dataset.addValue((Number)mapCategories.get(CATEGORY_CC), (Comparable)((Object)"GO domains"), (Comparable)((Object)"Cellular Component"));
            dataset.addValue((Number)mapCategories.get(CATEGORY_MF), (Comparable)((Object)"GO domains"), (Comparable)((Object)"Molecular Function"));
            dataset.addValue((Number)mapCategories.get(CATEGORY_BP), (Comparable)((Object)"GO domains"), (Comparable)((Object)"Biological Process"));
            DefaultCategoryDataset defaultCategoryDataset = dataset;
            return defaultCategoryDataset;
        }
        finally {
            goLevel.closeConnection();
            monitor.done();
        }
    }

    public CategoryDataset[] generateGoBarDataset(List<List<String>> model, int column, int maxCategories, int minPercent, IProgressMonitor monitor) throws NullPointerException, IndexOutOfBoundsException, ClassNotFoundException, SQLException {
        return this.generateGoBarDataset(model, column, maxCategories, minPercent, 0, monitor);
    }

    private CategoryDataset[] generateGoBarDataset(List<List<String>> model, int column, int maxCategories, int minPercent, int level, IProgressMonitor monitor) throws NullPointerException, IndexOutOfBoundsException, ClassNotFoundException, SQLException {
        DefaultCategoryDataset[] dataset = new DefaultCategoryDataset[3];
        Map<String, Integer> mapCC = new HashMap<String, Integer>();
        Map<String, Integer> mapMF = new HashMap<String, Integer>();
        Map<String, Integer> mapBP = new HashMap<String, Integer>();
        int modelLength = model.size();
        dataset[0] = new DefaultCategoryDataset();
        dataset[1] = new DefaultCategoryDataset();
        dataset[2] = new DefaultCategoryDataset();
        if (model == null) {
            throw new NullPointerException("Model is null");
        }
        int taskLength = model.size() + 3;
        if (level > 0) {
            ++taskLength;
        }
        monitor.beginTask("Category statistics", taskLength);
        monitor.subTask("Reading column data");
        int i = 0;
        while (i < modelLength) {
            String key = model.get(i).get(column);
            if (key != null && key.length() != 0) {
                String[] tokens = key.trim().split(";");
                StringBuilder builder = new StringBuilder();
                String[] stringArray = tokens;
                int n = tokens.length;
                int n2 = 0;
                while (n2 < n) {
                    Integer value;
                    String t;
                    String token = stringArray[n2];
                    token = token.trim();
                    builder = new StringBuilder();
                    Matcher matcherCC = this.patternCC.matcher(token);
                    Matcher matcherMF = this.patternMF.matcher(token);
                    Matcher matcherBP = this.patternBP.matcher(token);
                    if (matcherCC.matches()) {
                        builder.append(matcherCC.group(2));
                        builder.append(matcherCC.group(3));
                        if (matcherCC.group(5) != null && matcherCC.group(5).length() > 0 && matcherCC.group(5) != "null") {
                            builder.append(" " + matcherCC.group(5));
                        }
                        if (mapCC.containsKey(t = builder.toString())) {
                            value = mapCC.get(t);
                            value = value + 1;
                            mapCC.put(t, value);
                        } else {
                            mapCC.put(t, 1);
                        }
                    }
                    if (matcherMF.matches()) {
                        builder.append(matcherMF.group(2));
                        builder.append(matcherMF.group(3));
                        if (matcherMF.group(5) != null && matcherMF.group(5).length() > 0 && matcherMF.group(5) != "null") {
                            builder.append(" " + matcherMF.group(5));
                        }
                        if (mapMF.containsKey(t = builder.toString())) {
                            value = mapMF.get(t);
                            value = value + 1;
                            mapMF.put(t, value);
                        } else {
                            mapMF.put(t, 1);
                        }
                    }
                    if (matcherBP.matches()) {
                        builder.append(matcherBP.group(2));
                        builder.append(matcherBP.group(3));
                        if (matcherBP.group(5) != null && matcherBP.group(5).length() > 0 && matcherBP.group(5) != "null") {
                            builder.append(" " + matcherBP.group(5));
                        }
                        if (mapBP.containsKey(t = builder.toString())) {
                            value = mapBP.get(t);
                            value = value + 1;
                            mapBP.put(t, value);
                        } else {
                            mapBP.put(t, 1);
                        }
                    }
                    ++n2;
                }
                monitor.worked(1);
            }
            ++i;
        }
        if (level > 0 && level < 16) {
            monitor.subTask("Filtering by level");
            GoLevel goLevel = new GoLevel();
            goLevel.initConnection();
            try {
                mapMF = goLevel.filterByLevel(mapMF, level);
                mapBP = goLevel.filterByLevel(mapBP, level);
                mapCC = goLevel.filterByLevel(mapCC, level);
            }
            catch (GoLevel.GoLevelConnectionNotStarted key) {
                // empty catch block
            }
            goLevel.closeConnection();
            monitor.worked(1);
        }
        monitor.subTask("Generating Mollecular Function dataset");
        List<String> sortedKeysMF = StatisticsModel.sortByValue(mapMF);
        int countCategoriesMF = mapMF.size();
        int countItemsMF = 0;
        int minItemsMF = 0;
        int countOthersMF = 0;
        int i2 = 0;
        while (i2 < sortedKeysMF.size()) {
            countItemsMF += mapMF.get(sortedKeysMF.get(i2)).intValue();
            ++i2;
        }
        minItemsMF = countItemsMF / 100 * minPercent;
        if (countCategoriesMF > maxCategories) {
            i2 = countCategoriesMF - 1;
            while (i2 > countCategoriesMF - maxCategories) {
                if (mapMF.get(sortedKeysMF.get(i2)) >= minItemsMF) {
                    dataset[0].addValue((Number)mapMF.get(sortedKeysMF.get(i2)), (Comparable)((Object)CATEGORY_MF), (Comparable)((Object)sortedKeysMF.get(i2)));
                } else {
                    countOthersMF += mapMF.get(sortedKeysMF.get(i2)).intValue();
                }
                --i2;
            }
            i2 = countCategoriesMF - maxCategories;
            while (i2 > 0) {
                countOthersMF += mapMF.get(sortedKeysMF.get(i2)).intValue();
                --i2;
            }
            dataset[0].addValue((double)countOthersMF, (Comparable)((Object)CATEGORY_MF), (Comparable)((Object)"Others"));
        } else {
            i2 = countCategoriesMF - 1;
            while (i2 > 0) {
                dataset[0].addValue((Number)mapMF.get(sortedKeysMF.get(i2)), (Comparable)((Object)CATEGORY_MF), (Comparable)((Object)sortedKeysMF.get(i2)));
                --i2;
            }
        }
        monitor.worked(1);
        monitor.subTask("Generating Cellular Component dataset");
        List<String> sortedKeysCC = StatisticsModel.sortByValue(mapCC);
        int countCategoriesCC = mapCC.size();
        int countItemsCC = 0;
        int minItemsCC = 0;
        int countOthersCC = 0;
        int i3 = 0;
        while (i3 < sortedKeysCC.size()) {
            countItemsCC += mapCC.get(sortedKeysCC.get(i3)).intValue();
            ++i3;
        }
        minItemsCC = countItemsCC / 100 * minPercent;
        if (countCategoriesCC > maxCategories) {
            i3 = countCategoriesCC - 1;
            while (i3 > countCategoriesCC - maxCategories) {
                if (mapCC.get(sortedKeysCC.get(i3)) >= minItemsCC) {
                    dataset[1].addValue((Number)mapCC.get(sortedKeysCC.get(i3)), (Comparable)((Object)CATEGORY_CC), (Comparable)((Object)sortedKeysCC.get(i3)));
                } else {
                    countOthersCC += mapCC.get(sortedKeysCC.get(i3)).intValue();
                }
                --i3;
            }
            i3 = countCategoriesCC - maxCategories;
            while (i3 > 0) {
                countOthersCC += mapCC.get(sortedKeysCC.get(i3)).intValue();
                --i3;
            }
            dataset[1].addValue((double)countOthersCC, (Comparable)((Object)CATEGORY_CC), (Comparable)((Object)"Others"));
        } else {
            i3 = countCategoriesCC - 1;
            while (i3 > 0) {
                dataset[1].addValue((Number)mapCC.get(sortedKeysCC.get(i3)), (Comparable)((Object)CATEGORY_CC), (Comparable)((Object)sortedKeysCC.get(i3)));
                --i3;
            }
        }
        monitor.worked(1);
        if (monitor != null) {
            monitor.subTask("Generating Biological Process dataset");
        }
        List<String> sortedKeysBP = StatisticsModel.sortByValue(mapBP);
        int countCategoriesBP = mapBP.size();
        int countItemsBP = 0;
        int minItemsBP = 0;
        int countOthersBP = 0;
        int i4 = 0;
        while (i4 < sortedKeysBP.size()) {
            countItemsBP += mapBP.get(sortedKeysBP.get(i4)).intValue();
            ++i4;
        }
        minItemsBP = countItemsCC / 100 * minPercent;
        if (countCategoriesBP > maxCategories) {
            i4 = countCategoriesBP - 1;
            while (i4 > countCategoriesBP - maxCategories) {
                if (mapBP.get(sortedKeysBP.get(i4)) > minItemsBP) {
                    dataset[2].addValue((Number)mapBP.get(sortedKeysBP.get(i4)), (Comparable)((Object)CATEGORY_BP), (Comparable)((Object)sortedKeysBP.get(i4)));
                } else {
                    countOthersBP += mapBP.get(sortedKeysBP.get(i4)).intValue();
                }
                --i4;
            }
            i4 = countCategoriesBP - maxCategories;
            while (i4 > 0) {
                countOthersBP += mapBP.get(sortedKeysBP.get(i4)).intValue();
                --i4;
            }
            dataset[2].addValue((double)countOthersBP, (Comparable)((Object)CATEGORY_BP), (Comparable)((Object)"Others"));
        } else {
            i4 = countCategoriesBP - 1;
            while (i4 > 0) {
                dataset[2].addValue((Number)mapBP.get(sortedKeysBP.get(i4)), (Comparable)((Object)CATEGORY_BP), (Comparable)((Object)sortedKeysBP.get(i4)));
                --i4;
            }
        }
        monitor.worked(1);
        monitor.done();
        return dataset;
    }

    public CategoryDataset generateECBarDataset(List<List<String>> model, int column, int maxCategories, int minPercent, IProgressMonitor monitor) throws PatternSyntaxException, NullPointerException, IndexOutOfBoundsException, InterruptedException {
        int modelLength = model.size();
        DefaultCategoryDataset categoryDataset = new DefaultCategoryDataset();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        String ecPattern = "^EC:(\\d+\\.){3}(\\d+)?$";
        Pattern pattern = Pattern.compile(ecPattern);
        if (model == null) {
            throw new NullPointerException();
        }
        if (monitor != null) {
            monitor.beginTask("EC statistics", modelLength + 1);
        }
        if (monitor != null) {
            monitor.subTask("Reading data column");
        }
        int i = 0;
        while (i < modelLength) {
            String key = model.get(i).get(column).trim();
            if (key != null && key.length() != 0) {
                String[] tokens;
                String[] stringArray = tokens = key.split(";");
                int n = tokens.length;
                int n2 = 0;
                while (n2 < n) {
                    String token = stringArray[n2];
                    token = token.trim();
                    Matcher matcher = pattern.matcher(token);
                    if (token.length() > 0 && matcher.matches()) {
                        if (map.containsKey(token)) {
                            Integer value = (Integer)map.get(token);
                            value = value + 1;
                            map.put(token, value);
                        } else {
                            map.put(token, 1);
                        }
                    }
                    ++n2;
                }
                if (monitor != null) {
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                }
            }
            ++i;
        }
        if (monitor != null) {
            monitor.subTask("Sorting by categories");
        }
        List<String> sortedKeys = StatisticsModel.sortByValue(map);
        int countCategories = map.size();
        int countItems = 0;
        int minItems = 0;
        int countOthers = 0;
        int i2 = 0;
        while (i2 < sortedKeys.size()) {
            countItems += ((Integer)map.get(sortedKeys.get(i2))).intValue();
            ++i2;
        }
        minItems = countItems / 100 * minPercent;
        if (countCategories > maxCategories) {
            i2 = countCategories - 1;
            while (i2 > countCategories - maxCategories) {
                if ((Integer)map.get(sortedKeys.get(i2)) >= minItems) {
                    categoryDataset.addValue((Number)map.get(sortedKeys.get(i2)), (Comparable)((Object)"EC"), (Comparable)((Object)sortedKeys.get(i2)));
                } else {
                    countOthers += ((Integer)map.get(sortedKeys.get(i2))).intValue();
                }
                --i2;
            }
            i2 = countCategories - maxCategories;
            while (i2 > 0) {
                countOthers += ((Integer)map.get(sortedKeys.get(i2))).intValue();
                --i2;
            }
            categoryDataset.addValue((double)countOthers, (Comparable)((Object)"EC"), (Comparable)((Object)"Others"));
        } else {
            i2 = countCategories - 1;
            while (i2 > 0) {
                categoryDataset.addValue((Number)map.get(sortedKeys.get(i2)), (Comparable)((Object)"EC"), (Comparable)((Object)sortedKeys.get(i2)));
                ++i2;
            }
        }
        if (monitor != null) {
            monitor.done();
        }
        return categoryDataset;
    }

    public PieDataset generateECPieDataset(List<List<String>> model, int column, int maxCategories, int minPercent, IProgressMonitor monitor) throws PatternSyntaxException, InterruptedException {
        DefaultPieDataset dataset = new DefaultPieDataset();
        int modelLength = model.size();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        String ecPattern = "^EC:(\\d+\\.){3}(\\d+)?$";
        Pattern pattern = Pattern.compile(ecPattern);
        if (monitor != null) {
            monitor.beginTask("EC statistics", modelLength + 1);
        }
        if (monitor != null) {
            monitor.subTask("Reading data column");
        }
        int i = 0;
        while (i < modelLength) {
            String key = model.get(i).get(column).trim();
            if (key != null && key.length() != 0) {
                String[] tokens;
                String[] stringArray = tokens = key.split(";");
                int n = tokens.length;
                int n2 = 0;
                while (n2 < n) {
                    String token = stringArray[n2];
                    token = token.trim();
                    Matcher matcher = pattern.matcher(token);
                    if (token.length() > 0 && matcher.matches()) {
                        if (map.containsKey(token)) {
                            Integer value = (Integer)map.get(token);
                            value = value + 1;
                            map.put(token, value);
                        } else {
                            map.put(token, 1);
                        }
                    }
                    ++n2;
                }
                if (monitor != null) {
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                }
            }
            ++i;
        }
        if (monitor != null) {
            monitor.subTask("Sorting by categories");
        }
        List<String> sortedKeys = StatisticsModel.sortByValue(map);
        int countCategories = map.size();
        int countItems = 0;
        int minItems = 0;
        int countOthers = 0;
        int i2 = 0;
        while (i2 < sortedKeys.size()) {
            countItems += ((Integer)map.get(sortedKeys.get(i2))).intValue();
            ++i2;
        }
        minItems = countItems / 100 * minPercent;
        if (countCategories > maxCategories) {
            i2 = countCategories - 1;
            while (i2 > countCategories - maxCategories) {
                if ((Integer)map.get(sortedKeys.get(i2)) >= minItems) {
                    dataset.setValue((Comparable)((Object)sortedKeys.get(i2)), (Number)map.get(sortedKeys.get(i2)));
                } else {
                    countOthers += ((Integer)map.get(sortedKeys.get(i2))).intValue();
                }
                --i2;
            }
            i2 = countCategories - maxCategories;
            while (i2 > 0) {
                countOthers += ((Integer)map.get(sortedKeys.get(i2))).intValue();
                --i2;
            }
            dataset.setValue((Comparable)((Object)"Others"), (double)countOthers);
        } else {
            i2 = countCategories - 1;
            while (i2 > 0) {
                dataset.setValue((Comparable)((Object)sortedKeys.get(i2)), (Number)map.get(sortedKeys.get(i2)));
                ++i2;
            }
        }
        if (monitor != null) {
            monitor.done();
        }
        return dataset;
    }

    public CategoryDataset generateInterproBarDataset(List<List<String>> model, int column, int maxCategories, int minPercent, IProgressMonitor monitor) throws Exception {
        int modelLength = model.size();
        DefaultCategoryDataset categoryDataset = new DefaultCategoryDataset();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (model == null) {
            throw new Exception("Model is null", new NullPointerException());
        }
        if (monitor != null) {
            monitor.beginTask("InterPro statistics", modelLength);
        }
        if (monitor != null) {
            monitor.subTask("Reading data column");
        }
        int i = 0;
        while (i < modelLength) {
            String key = model.get(i).get(column).trim();
            if (key != null && key.length() != 0) {
                String[] tokens;
                String[] stringArray = tokens = key.split(";");
                int n = tokens.length;
                int n2 = 0;
                while (n2 < n) {
                    String token = stringArray[n2];
                    if ((token = token.trim()).length() > 0) {
                        if (map.containsKey(key)) {
                            Integer value = (Integer)map.get(token);
                            value = value + 1;
                            map.put(token, value);
                        } else {
                            map.put(token, 1);
                        }
                    }
                    ++n2;
                }
                if (monitor != null) {
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                }
            }
            ++i;
        }
        if (monitor != null) {
            monitor.subTask("Sorting categories");
        }
        List<String> sortedKeys = StatisticsModel.sortByValue(map);
        int countCategories = map.size();
        int countItems = 0;
        int minItems = 0;
        int countOthers = 0;
        int i2 = 0;
        while (i2 < sortedKeys.size()) {
            countItems += ((Integer)map.get(sortedKeys.get(i2))).intValue();
            ++i2;
        }
        minItems = countItems / 100 * minPercent;
        if (countCategories > maxCategories) {
            i2 = countCategories - 1;
            while (i2 > countCategories - maxCategories) {
                if ((Integer)map.get(sortedKeys.get(i2)) >= minItems) {
                    categoryDataset.addValue((Number)map.get(sortedKeys.get(i2)), (Comparable)((Object)"InterPro"), (Comparable)((Object)sortedKeys.get(i2)));
                } else {
                    countOthers += ((Integer)map.get(sortedKeys.get(i2))).intValue();
                }
                --i2;
            }
            i2 = countCategories - maxCategories;
            while (i2 > 0) {
                countOthers += ((Integer)map.get(sortedKeys.get(i2))).intValue();
                --i2;
            }
            categoryDataset.addValue((double)countOthers, (Comparable)((Object)"InterPro"), (Comparable)((Object)"Others"));
        } else {
            i2 = countCategories - 1;
            while (i2 > 0) {
                categoryDataset.addValue((Number)map.get(sortedKeys.get(i2)), (Comparable)((Object)"InterPro"), (Comparable)((Object)sortedKeys.get(i2)));
                ++i2;
            }
        }
        if (monitor != null) {
            monitor.done();
        }
        return categoryDataset;
    }

    public PieDataset generateInterproPieDataset(List<List<String>> model, int column, int maxCategories, int minPercent, IProgressMonitor monitor) throws NullPointerException, PatternSyntaxException, IndexOutOfBoundsException, InterruptedException {
        DefaultPieDataset dataset = new DefaultPieDataset();
        int modelLength = model.size();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (model == null) {
            throw new NullPointerException("Model is null");
        }
        if (monitor != null) {
            monitor.beginTask("InterPro statistics", modelLength);
        }
        if (monitor != null) {
            monitor.subTask("Reading data column");
        }
        int i = 0;
        while (i < modelLength) {
            String key = model.get(i).get(column).trim();
            if (key != null && key.length() != 0) {
                String[] tokens;
                String[] stringArray = tokens = key.split(";");
                int n = tokens.length;
                int n2 = 0;
                while (n2 < n) {
                    String token = stringArray[n2];
                    if ((token = token.trim()).length() > 0) {
                        if (map.containsKey(token)) {
                            Integer value = (Integer)map.get(token);
                            value = value + 1;
                            map.put(token, value);
                        } else {
                            map.put(token, 1);
                        }
                    }
                    ++n2;
                }
                if (monitor != null) {
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                }
            }
            ++i;
        }
        if (monitor != null) {
            monitor.subTask("Sorting by categories");
        }
        List<String> sortedKeys = StatisticsModel.sortByValue(map);
        int countCategories = map.size();
        int countItems = 0;
        int minItems = 0;
        int countOthers = 0;
        int i2 = 0;
        while (i2 < sortedKeys.size()) {
            countItems += ((Integer)map.get(sortedKeys.get(i2))).intValue();
            ++i2;
        }
        minItems = countItems / 100 * minPercent;
        if (countCategories > maxCategories) {
            i2 = countCategories - 1;
            while (i2 > countCategories - maxCategories) {
                if ((Integer)map.get(sortedKeys.get(i2)) >= minItems) {
                    dataset.setValue((Comparable)((Object)sortedKeys.get(i2)), (Number)map.get(sortedKeys.get(i2)));
                } else {
                    countOthers += ((Integer)map.get(sortedKeys.get(i2))).intValue();
                }
                --i2;
            }
            i2 = countCategories - maxCategories;
            while (i2 > 0) {
                countOthers += ((Integer)map.get(sortedKeys.get(i2))).intValue();
                --i2;
            }
            dataset.setValue((Comparable)((Object)"Others"), (double)countOthers);
        } else {
            i2 = countCategories - 1;
            while (i2 > 0) {
                dataset.setValue((Comparable)((Object)sortedKeys.get(i2)), (Number)map.get(sortedKeys.get(i2)));
                ++i2;
            }
        }
        if (monitor != null) {
            monitor.done();
        }
        return dataset;
    }

    public PieDataset generatePieDataset(List<List<String>> model, int column, int maxCategories, int minPercent, IProgressMonitor monitor) throws InterruptedException, IndexOutOfBoundsException {
        DefaultPieDataset dataset = new DefaultPieDataset();
        int modelLength = model.size();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (monitor != null) {
            monitor.beginTask("Category statistics", modelLength);
        }
        if (monitor != null) {
            monitor.subTask("Reading data column");
        }
        int i = 0;
        while (i < modelLength) {
            String key = model.get(i).get(column);
            if (key != null && key.length() != 0) {
                if (map.containsKey(key)) {
                    Integer value = (Integer)map.get(key);
                    value = value + 1;
                    map.put(key, value);
                } else {
                    map.put(key, 1);
                }
                if (monitor != null) {
                    monitor.worked(1);
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                }
            }
            ++i;
        }
        if (monitor != null) {
            monitor.subTask("Sorting categories");
        }
        List<String> sortedKeys = StatisticsModel.sortByValue(map);
        int countCategories = map.size();
        int countItems = 0;
        int minItems = 0;
        int countOthers = 0;
        int i2 = 0;
        while (i2 < sortedKeys.size()) {
            countItems += ((Integer)map.get(sortedKeys.get(i2))).intValue();
            ++i2;
        }
        minItems = countItems / 100 * minPercent;
        if (countCategories > maxCategories) {
            i2 = countCategories - 1;
            while (i2 > countCategories - maxCategories) {
                if ((Integer)map.get(sortedKeys.get(i2)) >= minItems) {
                    dataset.setValue((Comparable)((Object)sortedKeys.get(i2)), (Number)map.get(sortedKeys.get(i2)));
                } else {
                    countOthers += ((Integer)map.get(sortedKeys.get(i2))).intValue();
                }
                --i2;
            }
            i2 = countCategories - maxCategories;
            while (i2 > 0) {
                countOthers += ((Integer)map.get(sortedKeys.get(i2))).intValue();
                --i2;
            }
            dataset.setValue((Comparable)((Object)"Others"), (double)countOthers);
        } else {
            i2 = countCategories - 1;
            while (i2 > 0) {
                dataset.setValue((Comparable)((Object)sortedKeys.get(i2)), (Number)map.get(sortedKeys.get(i2)));
                ++i2;
            }
        }
        if (monitor != null) {
            monitor.done();
        }
        return dataset;
    }

    public CategoryDataset generateGODepthDataset(List<List<String>> model, int columnIndex, GOTerm.GODomain termType, int minSequences, double alpha, double nodeScoreThreshold, int maximumDepth, IProgressMonitor monitor) throws NullPointerException, IndexOutOfBoundsException, InterruptedException {
        if (model == null) {
            throw new NullPointerException("Model is null");
        }
        int modelLength = model.size();
        DefaultCategoryDataset categoryDataset = new DefaultCategoryDataset();
        HashMap filteredDepthToTermsMap = new HashMap();
        HashMap<Integer, Integer> filteredDepthToSequenceCountMap = new HashMap<Integer, Integer>();
        monitor.beginTask("GO depth statistics", modelLength * 2 + 9);
        monitor.subTask("Building " + termType.getPrettyName() + " graph");
        GOGraphModel graphModel = new GOGraphModel(model, columnIndex, termType, alpha);
        graphModel.buildGraphModel(monitor);
        monitor.subTask("Filtering terms ");
        int i = 0;
        while (i <= maximumDepth) {
            filteredDepthToTermsMap.put(i, new HashSet());
            filteredDepthToSequenceCountMap.put(i, 0);
            ++i;
        }
        for (GOTerm term : graphModel.getCsvTerms()) {
            if (term.getDepth() <= 0 || term.getDepth() > maximumDepth || term.getSequenceCount() < minSequences || !(term.getNodeScore() >= nodeScoreThreshold)) continue;
            ((Set)filteredDepthToTermsMap.get(term.getDepth())).add(term);
            int sequenceCount = (Integer)filteredDepthToSequenceCountMap.get(term.getDepth());
            filteredDepthToSequenceCountMap.put(term.getDepth(), sequenceCount + term.getSequenceCount());
        }
        Iterator<GOTerm> iterator = filteredDepthToSequenceCountMap.keySet().iterator();
        while (iterator.hasNext()) {
            int depth = (Integer)((Object)iterator.next());
            if ((Integer)filteredDepthToSequenceCountMap.get(depth) <= 0) continue;
            categoryDataset.addValue((Number)filteredDepthToSequenceCountMap.get(depth), (Comparable)((Object)"Sequences"), (Comparable)((Object)Integer.toString(depth)));
        }
        monitor.done();
        return categoryDataset;
    }

    public PieDataset generateGODepthPieDataset(List<List<String>> model, int columnIndex, GOTerm.GODomain termType, int minSequences, double alpha, double nodeScoreThreshold, int maximumDepth, IProgressMonitor monitor) throws InterruptedException, IndexOutOfBoundsException {
        if (model == null) {
            throw new NullPointerException("Model is null");
        }
        DefaultPieDataset pieDataset = new DefaultPieDataset();
        int modelLength = model.size();
        HashMap filteredDepthToTermsMap = new HashMap();
        HashMap<Integer, Integer> filteredDepthToSequenceCountMap = new HashMap<Integer, Integer>();
        monitor.beginTask("GO depth statistics", modelLength * 2 + 9);
        monitor.subTask("Building " + termType.getPrettyName() + " graph");
        GOGraphModel graphModel = new GOGraphModel(model, columnIndex, termType, alpha);
        graphModel.buildGraphModel(monitor);
        monitor.subTask("Filtering terms ");
        int i = 0;
        while (i <= maximumDepth) {
            filteredDepthToTermsMap.put(i, new HashSet());
            filteredDepthToSequenceCountMap.put(i, 0);
            ++i;
        }
        for (GOTerm term : graphModel.getCsvTerms()) {
            if (term.getDepth() > maximumDepth || term.getSequenceCount() < minSequences || !(term.getNodeScore() >= nodeScoreThreshold)) continue;
            ((Set)filteredDepthToTermsMap.get(term.getDepth())).add(term);
            int sequenceCount = (Integer)filteredDepthToSequenceCountMap.get(term.getDepth());
            filteredDepthToSequenceCountMap.put(term.getDepth(), sequenceCount + term.getSequenceCount());
            ((Set)filteredDepthToTermsMap.get(term.getDepth())).add(term);
        }
        Iterator<GOTerm> iterator = filteredDepthToTermsMap.keySet().iterator();
        while (iterator.hasNext()) {
            int depth = (Integer)((Object)iterator.next());
            if (((Set)filteredDepthToTermsMap.get(depth)).size() <= 0) continue;
            pieDataset.setValue((Comparable)((Object)Integer.toString(depth + 1)), (Number)filteredDepthToSequenceCountMap.get(depth));
        }
        monitor.done();
        return pieDataset;
    }

    public CategoryDataset generateGOTermsDataset(List<List<String>> model, int columnIndex, GOTerm.GODomain termType, int minSequences, double alpha, double nodeScoreThreshold, int maximumDepth, boolean onlyThisLevel, IProgressMonitor monitor) throws NullPointerException, IndexOutOfBoundsException, InterruptedException {
        if (model == null) {
            throw new NullPointerException("Model is null");
        }
        int modelLength = model.size();
        DefaultCategoryDataset categoryDataset = new DefaultCategoryDataset();
        HashMap<GOTerm, Integer> termToSequencesMap = new HashMap<GOTerm, Integer>();
        HashMap listIndicesForSorting = new HashMap();
        monitor.beginTask("GO depth statistics", modelLength * 2 + 9);
        monitor.subTask("Building " + termType.getPrettyName() + " graph");
        GOGraphModel graphModel = new GOGraphModel(model, columnIndex, termType, alpha);
        graphModel.buildGraphModel(monitor);
        monitor.subTask("Filtering terms ");
        if (onlyThisLevel) {
            for (GOTerm term : graphModel.getCsvTerms()) {
                if (term.getDepth() != maximumDepth || term.getSequenceCount() < minSequences || !(term.getNodeScore() >= nodeScoreThreshold)) continue;
                termToSequencesMap.put(term, term.getSequenceCount());
            }
        } else {
            for (GOTerm term : graphModel.getCsvTerms()) {
                if (term.getDepth() > maximumDepth || term.getSequenceCount() < minSequences || !(term.getNodeScore() >= nodeScoreThreshold)) continue;
                termToSequencesMap.put(term, term.getSequenceCount());
            }
        }
        LinkedHashMap<GOTerm, Integer> listSorted = this.sortHashMapByValues(termToSequencesMap);
        for (GOTerm k : listSorted.keySet()) {
            if (listSorted.get(k) <= 0) continue;
            categoryDataset.addValue((Number)listSorted.get(k), (Comparable)((Object)"Sequences"), (Comparable)((Object)k.getName()));
        }
        monitor.done();
        return categoryDataset;
    }

    public LinkedHashMap<GOTerm, Integer> sortHashMapByValues(Map<GOTerm, Integer> passedMap) {
        ArrayList<GOTerm> mapKeys = new ArrayList<GOTerm>(passedMap.keySet());
        ArrayList<Integer> mapValues = new ArrayList<Integer>(passedMap.values());
        Collections.sort(mapValues, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return o2 - o1;
            }
        });
        Collections.sort(mapKeys);
        LinkedHashMap<GOTerm, Integer> sortedMap = new LinkedHashMap<GOTerm, Integer>();
        Iterator valueIt = mapValues.iterator();
        block0: while (valueIt.hasNext()) {
            int val = (Integer)valueIt.next();
            Iterator keyIt = mapKeys.iterator();
            while (keyIt.hasNext()) {
                int comp2;
                GOTerm key = (GOTerm)keyIt.next();
                int comp1 = passedMap.get(key);
                if (comp1 != (comp2 = val)) continue;
                keyIt.remove();
                sortedMap.put(key, val);
                continue block0;
            }
        }
        return sortedMap;
    }

    public PieDataset generateGOTermsPieDataset(List<List<String>> model, int columnIndex, GOTerm.GODomain termType, int minSequences, double alpha, double nodeScoreThreshold, int maximumDepth, boolean onlyThisLevel, IProgressMonitor monitor) throws InterruptedException, IndexOutOfBoundsException {
        if (model == null) {
            throw new NullPointerException("Model is null");
        }
        DefaultPieDataset pieDataset = new DefaultPieDataset();
        int modelLength = model.size();
        monitor.beginTask("GO depth statistics", modelLength * 2 + 9);
        monitor.subTask("Building " + termType.getPrettyName() + " graph");
        GOGraphModel graphModel = new GOGraphModel(model, columnIndex, termType, alpha);
        graphModel.buildGraphModel(monitor);
        monitor.subTask("Filtering terms ");
        for (GOTerm term : graphModel.getCsvTerms()) {
            if (term.getDepth() != maximumDepth || term.getSequenceCount() < minSequences || !(term.getNodeScore() >= nodeScoreThreshold)) continue;
            pieDataset.insertValue(0, (Comparable)((Object)term.getName()), (double)term.getSequenceCount());
        }
        monitor.done();
        return pieDataset;
    }

    public static List<String> sortByValue(final Map<String, Integer> m) {
        ArrayList<String> keys = new ArrayList<String>();
        keys.addAll(m.keySet());
        Collections.sort(keys, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                Object v1 = m.get(o1);
                Object v2 = m.get(o2);
                if (v1 == null) {
                    return v2 == null ? 0 : 1;
                }
                if (v1 instanceof Comparable) {
                    return ((Comparable)v1).compareTo(v2);
                }
                return 0;
            }
        });
        return keys;
    }

    public static <K, V extends Comparable<V>> List<K> genericsSortByValue(final Map<K, V> m) {
        ArrayList<K> keys = new ArrayList<K>();
        keys.addAll(m.keySet());
        Collections.sort(keys, new Comparator<K>(){

            @Override
            public int compare(Object o1, Object o2) {
                return ((Comparable)m.get(o1)).compareTo((Comparable)m.get(o2));
            }
        });
        return keys;
    }

    public static <K, V> List<K> genericsSortByValue(Map<K, V> m, Comparator<K> comparator) {
        ArrayList<K> keys = new ArrayList<K>();
        keys.addAll(m.keySet());
        Collections.sort(keys, comparator);
        return keys;
    }

    public class StatisticsTooSmallNumberException
    extends Exception {
        private static final long serialVersionUID = -4842977628111911480L;
    }

    public class TermComparator
    implements Comparator<Object> {
        Map<GOTerm, Integer> entry;

        public TermComparator(Map<GOTerm, Integer> entry) {
            this.entry = entry;
        }

        @Override
        public int compare(Object a, Object b) {
            return -this.entry.get(a).compareTo(this.entry.get(b));
        }
    }

    class TwoDimcolumnComparator
    implements Comparator<Object> {
        private int columnToSortOn;

        public TwoDimcolumnComparator(int columnToSortOn) {
            this.columnToSortOn = columnToSortOn;
        }

        @Override
        public int compare(Object o1, Object o2) {
            Integer[] row1 = (Integer[])o1;
            Integer[] row2 = (Integer[])o2;
            return row2[this.columnToSortOn].compareTo(row1[this.columnToSortOn]);
        }
    }
}

