/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.model;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GenbankDownloader {
    private final String QUERY_URL = "https://eutils.ncbi.nlm.nih.gov/gquery?";
    private final String SEARCH_URL = "https://eutils.ncbi.nlm.nih.gov/entrez/eutils/esearch.fcgi?";
    private final String FETCH_URL = "https://eutils.ncbi.nlm.nih.gov/entrez/eutils/efetch.fcgi?";
    private final String DB_PROTEIN = "protein";
    private final String DB_NUCLEOTIDE = "gene";
    private final String GB_EXTENSION = ".gbk";
    private final String FASTA_EXTENSIONS = ".fa";
    public static final String RETTYPE_GENBANK = "gb";
    public static final String RETTYPE_FASTA = "fasta";
    private final int PAUSE = 500;
    private DocumentBuilderFactory domFactory;
    private DocumentBuilder builder;
    private Document doc;
    private List<String> termsNotFound = new ArrayList<String>();
    private String rettype;

    public String[] download(List<List<String>> model, int column, List<Integer> listSelectedRows, String outputFolder, String rettype, IProgressMonitor monitor) throws Exception {
        this.rettype = rettype;
        String entrezDatabase = "gene";
        monitor.beginTask("Download GenBank accessions", listSelectedRows.size());
        try {
            for (int i : listSelectedRows) {
                List<String> row = model.get(i);
                String term = row.get(column);
                monitor.subTask("Downloading: " + term);
                if (monitor.isCanceled()) {
                    String[] stringArray = this.termsNotFound.toArray(new String[this.termsNotFound.size()]);
                    return stringArray;
                }
                Object[] queryDatabases = this.getQueryDatabases(new URL("https://eutils.ncbi.nlm.nih.gov/gquery?term=" + term + "&retmode=xml"));
                Arrays.sort(queryDatabases);
                int resNucleotide = Arrays.binarySearch(queryDatabases, "gene");
                int resProtein = Arrays.binarySearch(queryDatabases, "protein");
                if (resNucleotide >= 0 && resProtein >= 0) {
                    entrezDatabase = "protein";
                } else if (resNucleotide >= 0) {
                    entrezDatabase = "gene";
                } else if (resProtein >= 0) {
                    entrezDatabase = "protein";
                }
                URL search = this.getSearchURL(term, entrezDatabase);
                String[] listIds = this.getSearchId(search);
                if (listIds != null && listIds.length > 0) {
                    URL fetch = this.getFetchUrl(listIds[0], entrezDatabase, rettype);
                    this.fetchGenbank(fetch, term, outputFolder);
                    monitor.worked(1);
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return null;
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        finally {
            monitor.done();
        }
    }

    public String[] download(String[] terms, String rettype, String outputFolder, IProgressMonitor monitor) {
        this.rettype = rettype;
        String entrezDatabase = "gene";
        String[] stringArray = terms;
        int n = terms.length;
        int n2 = 0;
        while (n2 < n) {
            String term = stringArray[n2];
            term = term.trim();
            monitor.subTask("Downloading: " + term);
            if (monitor.isCanceled()) {
                return this.termsNotFound.toArray(new String[this.termsNotFound.size()]);
            }
            try {
                Object[] queryDatabases = this.getQueryDatabases(new URL("https://eutils.ncbi.nlm.nih.gov/gquery?term=" + term));
                Arrays.sort(queryDatabases);
                int resNucleotide = Arrays.binarySearch(queryDatabases, "gene");
                int resProtein = Arrays.binarySearch(queryDatabases, "protein");
                if (resNucleotide >= 0 && resProtein >= 0) {
                    entrezDatabase = "protein";
                } else if (resNucleotide >= 0) {
                    entrezDatabase = "gene";
                } else if (resProtein >= 0) {
                    entrezDatabase = "protein";
                }
                URL search = this.getSearchURL(term, entrezDatabase);
                String[] listIds = this.getSearchId(search);
                if (listIds != null && listIds.length > 0) {
                    URL fetch = this.getFetchUrl(listIds[0], entrezDatabase, rettype);
                    this.fetchGenbank(fetch, term, outputFolder);
                    monitor.worked(1);
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return this.termsNotFound.toArray(new String[this.termsNotFound.size()]);
    }

    private URL getSearchURL(String term, String database) throws MalformedURLException {
        StringBuilder sbuilder = new StringBuilder();
        sbuilder.append("https://eutils.ncbi.nlm.nih.gov/entrez/eutils/esearch.fcgi?");
        sbuilder.append("db=" + database);
        sbuilder.append("&term=" + term);
        System.out.println("Construyendo url: " + sbuilder.toString());
        URL url = new URL(sbuilder.toString());
        return url;
    }

    private String[] getSearchId(URL url) throws ParserConfigurationException, SAXException, IOException {
        ArrayList<String> listSites = new ArrayList<String>();
        System.out.println("Examinando la url: " + url.getPath());
        this.domFactory = DocumentBuilderFactory.newInstance();
        this.domFactory.setNamespaceAware(true);
        this.builder = this.domFactory.newDocumentBuilder();
        this.doc = this.builder.parse(url.openStream());
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        String expression = "/eSearchResult/IdList";
        try {
            XPathExpression expr = xpath.compile(expression);
            Object result = expr.evaluate(this.doc, XPathConstants.NODESET);
            NodeList nodes = (NodeList)result;
            int i = 0;
            while (i < nodes.getLength()) {
                listSites.add(nodes.item(i).getTextContent());
                ++i;
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return listSites.toArray(new String[listSites.size()]);
    }

    private String[] getQueryDatabases(URL url) throws ParserConfigurationException, SAXException, IOException {
        ArrayList<String> listDatabases = new ArrayList<String>();
        this.domFactory = DocumentBuilderFactory.newInstance();
        this.domFactory.setNamespaceAware(true);
        this.builder = this.domFactory.newDocumentBuilder();
        this.doc = this.builder.parse(url.openStream());
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        String expression = "//ResultItem";
        try {
            XPathExpression expr = xpath.compile(expression);
            Object result = expr.evaluate(this.doc, XPathConstants.NODESET);
            NodeList nodes = (NodeList)result;
            String dbName = null;
            String dbCount = null;
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                NodeList children = node.getChildNodes();
                int c = 0;
                while (c < children.getLength()) {
                    if (children.item(c).getNodeName().equals("DbName")) {
                        dbName = children.item(c).getTextContent();
                    } else if (children.item(c).getNodeName().equals("Count")) {
                        dbCount = children.item(c).getTextContent();
                    }
                    ++c;
                }
                if (dbCount != null && !dbCount.equals("0")) {
                    listDatabases.add(dbName);
                }
                ++i;
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        return listDatabases.toArray(new String[listDatabases.size()]);
    }

    private URL getFetchUrl(String searchId, String database, String rettype) throws MalformedURLException {
        StringBuilder sbuilder = new StringBuilder();
        sbuilder.append("https://eutils.ncbi.nlm.nih.gov/entrez/eutils/efetch.fcgi?");
        sbuilder.append("db=" + database);
        sbuilder.append("&id=" + searchId);
        sbuilder.append("&rettype=" + rettype);
        sbuilder.append("&retmode=text");
        System.out.println("Construyendo URL: " + sbuilder.toString());
        URL url = new URL(sbuilder.toString());
        return url;
    }

    private boolean fetchGenbank(URL url, String term, String outputFolder) {
        try {
            String extension = ".gbk";
            if (this.rettype.equalsIgnoreCase(RETTYPE_FASTA)) {
                extension = ".fa";
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openConnection().getInputStream()));
            BufferedWriter writer = new BufferedWriter(new FileWriter(new File(outputFolder + File.separator + term + "." + extension)));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    writer.write(line);
                    writer.newLine();
                }
            }
            finally {
                reader.close();
                writer.close();
            }
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }
}

