/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.model.CsvEditor.actions;

import com.biotechvana.csveditor.model.CsvEditor.actions.CsvAction;
import java.util.ArrayList;
import java.util.List;

public class CsvActionColumnSort
extends CsvAction {
    private String columnName;
    private List<List<String>> modelBefore;

    public CsvActionColumnSort(String columnName, List<List<String>> model, long timestamp) {
        this.setType(16);
        this.setTimestamp(timestamp);
        this.columnName = columnName;
        this.modelBefore = new ArrayList<List<String>>(model.size());
        this.copyModel(this.modelBefore, model);
    }

    public CsvActionColumnSort(String columnName, List<List<String>> model) {
        this.setType(16);
        this.setTimestamp(System.currentTimeMillis());
        this.columnName = columnName;
        this.modelBefore = new ArrayList<List<String>>(model.size());
        this.copyModel(this.modelBefore, model);
    }

    private void copyModel(List<List<String>> dst, List<List<String>> src) {
        for (List<String> row : src) {
            ArrayList<String> newRow = new ArrayList<String>();
            for (String item : row) {
                newRow.add(item);
            }
            dst.add(newRow);
        }
    }

    public List<List<String>> getModel() {
        return this.modelBefore;
    }

    public String toString() {
        return "[Sort:" + this.getTimestamp() + "];  column: " + this.columnName + "; size: " + this.modelBefore.size();
    }
}

