/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.model.CsvEditor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.swt.graphics.Point;

public class ScoreFilteringModel {
    public void parseScore(List<List<String>> rowSet, int hspQueryColumnIndex, int hspHitColumnIndex, int similarityColumnIndex, int eValueColumnIndex, int depthColumnIndex) {
        for (List<String> originalCSVLineList : rowSet) {
            double hspQuery = 100.0;
            double hspHit = 100.0;
            double similarity = 100.0;
            double eValue = 1.0;
            int depth = 1;
            int shiftIndex = 1;
            if (hspQueryColumnIndex != -1 && !originalCSVLineList.get(hspQueryColumnIndex + shiftIndex).trim().isEmpty()) {
                hspQuery = Double.parseDouble(this.sanitizeDecimalNumberString(originalCSVLineList.get(hspQueryColumnIndex + shiftIndex)));
            }
            if (hspHitColumnIndex != -1 && !originalCSVLineList.get(hspHitColumnIndex + shiftIndex).trim().isEmpty()) {
                hspHit = Double.parseDouble(this.sanitizeDecimalNumberString(originalCSVLineList.get(hspHitColumnIndex + shiftIndex)));
            }
            if (similarityColumnIndex != -1 && !originalCSVLineList.get(similarityColumnIndex + shiftIndex).trim().isEmpty()) {
                similarity = Double.parseDouble(this.sanitizeDecimalNumberString(originalCSVLineList.get(similarityColumnIndex + shiftIndex)));
            }
            if (eValueColumnIndex != -1 && !originalCSVLineList.get(eValueColumnIndex + shiftIndex).trim().isEmpty()) {
                eValue = Double.parseDouble(this.sanitizeDecimalNumberString(originalCSVLineList.get(eValueColumnIndex + shiftIndex)));
            }
            originalCSVLineList.add(Double.toString(this.computeScore(hspQuery, hspHit, similarity, eValue, depth)));
        }
    }

    private double computeScore(double hspQuery, double hspHit, double similarity, double eValue, int depth) {
        if (eValue == 0.0) {
            eValue = 1.0E-299;
        }
        return hspQuery * hspHit * similarity / 1000000.0 * (1.0 / eValue) * (double)depth;
    }

    public void sortByScore(List<List<String>> rowSet, final int scoreColumnIndex) {
        Comparator<List<String>> scoreColumnComparator = new Comparator<List<String>>(){

            @Override
            public int compare(List<String> o1, List<String> o2) {
                double o2Score;
                int sci = scoreColumnIndex;
                String s1 = o1.get(scoreColumnIndex);
                String s2 = o2.get(scoreColumnIndex);
                double o1Score = Double.parseDouble(ScoreFilteringModel.this.sanitizeDecimalNumberString(o1.get(scoreColumnIndex)));
                if (o1Score < (o2Score = Double.parseDouble(ScoreFilteringModel.this.sanitizeDecimalNumberString(o2.get(scoreColumnIndex))))) {
                    return -1;
                }
                if (o2Score < o1Score) {
                    return 1;
                }
                return 0;
            }
        };
        Collections.sort(rowSet, scoreColumnComparator);
    }

    public List<String[]> filterOverlap(List<String[]> rows, double overlapRatio, final int scoreColumnIndex, final int subjectFromColumnIndex, int subjectToColumnIndex) {
        ArrayList<String[]> filteredByOverlap = new ArrayList<String[]>();
        Comparator<String[]> scoreComparator = new Comparator<String[]>(){

            @Override
            public int compare(String[] o1, String[] o2) {
                double o2Score;
                double o1Score = Double.parseDouble(ScoreFilteringModel.this.sanitizeDecimalNumberString(o1[scoreColumnIndex]));
                if (o1Score < (o2Score = Double.parseDouble(ScoreFilteringModel.this.sanitizeDecimalNumberString(o2[scoreColumnIndex])))) {
                    return -1;
                }
                if (o2Score < o1Score) {
                    return 1;
                }
                return 0;
            }
        };
        Collections.sort(rows, new Comparator<String[]>(){

            @Override
            public int compare(String[] o1, String[] o2) {
                int start1 = Integer.parseInt(o1[subjectFromColumnIndex]);
                int start2 = Integer.parseInt(o2[subjectFromColumnIndex]);
                return start1 - start2;
            }
        });
        ArrayList<String[]> groupOverlapping = new ArrayList<String[]>();
        groupOverlapping.add(rows.get(0));
        if (rows.size() > 1) {
            int i = 1;
            while (i < rows.size()) {
                boolean overlaps = false;
                String[] currentRow = rows.get(i);
                int startCurrent = Integer.parseInt(currentRow[subjectFromColumnIndex]);
                int endCurrent = Integer.parseInt(currentRow[subjectToColumnIndex]);
                int j = 0;
                while (j < groupOverlapping.size() && !overlaps) {
                    int endPrevious;
                    String[] previousRow = (String[])groupOverlapping.get(j);
                    int startPrevious = Integer.parseInt(previousRow[subjectFromColumnIndex]);
                    if (this.overlaps(new Point(startPrevious, endPrevious = Integer.parseInt(previousRow[subjectToColumnIndex])), new Point(startCurrent, endCurrent))) {
                        overlaps = true;
                    }
                    ++j;
                }
                if (overlaps) {
                    groupOverlapping.add(currentRow);
                } else {
                    Collections.sort(groupOverlapping, scoreComparator);
                    filteredByOverlap.add((String[])groupOverlapping.get(groupOverlapping.size() - 1));
                    groupOverlapping = new ArrayList();
                    groupOverlapping.add(currentRow);
                }
                ++i;
            }
            Collections.sort(groupOverlapping, scoreComparator);
            filteredByOverlap.add((String[])groupOverlapping.get(groupOverlapping.size() - 1));
        } else {
            filteredByOverlap.add(rows.get(0));
        }
        return filteredByOverlap;
    }

    private String sanitizeDecimalNumberString(String insaneDecimalNumberString) {
        ArrayList<Integer> commaPositions = new ArrayList<Integer>();
        int commaPosition = -1;
        while ((commaPosition = insaneDecimalNumberString.indexOf(",", commaPosition + 1)) != -1) {
            commaPositions.add(commaPosition);
        }
        ArrayList<Integer> dotPositions = new ArrayList<Integer>();
        int dotPosition = -1;
        while ((dotPosition = insaneDecimalNumberString.indexOf(".", dotPosition + 1)) != -1) {
            dotPositions.add(dotPosition);
        }
        String saneDecimalNumberString = insaneDecimalNumberString;
        if (commaPositions.size() > 1) {
            saneDecimalNumberString = insaneDecimalNumberString.replaceAll(",", "");
        } else if (commaPositions.size() == 1) {
            saneDecimalNumberString = insaneDecimalNumberString.replaceAll(",", ".");
        } else if (dotPositions.size() > 1) {
            saneDecimalNumberString = insaneDecimalNumberString.replaceAll(".", "");
            saneDecimalNumberString = saneDecimalNumberString.replaceAll(",", ".");
        }
        return saneDecimalNumberString;
    }

    private boolean overlaps(Point point1, Point point2) {
        Point leftPoint = point1;
        Point rightPoint = point2;
        if (point2.x < leftPoint.x) {
            leftPoint = point2;
            rightPoint = point1;
        }
        return leftPoint.y >= rightPoint.x;
    }
}

