/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.model.CsvEditor;

import com.biotechvana.csveditor.model.CsvEditor.CsvCluster;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class ClusterUtils {
    public static List<CsvCluster> getClusterList(List<List<String>> model, List<Integer> listCheckedRowIndices, int clusterKeyColumnIndex, IProgressMonitor monitor) throws InterruptedException {
        ArrayList<CsvCluster> listClusters = new ArrayList<CsvCluster>();
        try {
            int i2;
            int divisor = 1;
            if (listClusters.size() > 100) {
                divisor = 100;
            }
            if (listClusters.size() > 10000) {
                divisor = 1000;
            }
            monitor.beginTask("Fetch cluster list", listCheckedRowIndices.size() / divisor);
            int counterSteps = 0;
            for (int i2 : listCheckedRowIndices) {
                List<String> row = model.get(i2);
                String groupName = row.get(clusterKeyColumnIndex);
                int res = Collections.binarySearch(listClusters, groupName, new Comparator<Object>(){

                    @Override
                    public int compare(Object o1, Object o2) {
                        return ((CsvCluster)o1).getName().compareToIgnoreCase(o2.toString());
                    }
                });
                if (res < 0) {
                    listClusters.add(-(res + 1), new CsvCluster(groupName, i2));
                } else {
                    CsvCluster cluster = (CsvCluster)listClusters.get(res);
                    cluster.addIndice(i2);
                }
                if (++counterSteps % divisor == 0) {
                    monitor.worked(1);
                }
                if (!monitor.isCanceled()) continue;
                throw new InterruptedException();
            }
            i2 = 0;
            while (i2 < model.size()) {
                List<String> row = model.get(i2);
                String rowName = row.get(clusterKeyColumnIndex);
                int res = Collections.binarySearch(listClusters, rowName, new Comparator<Object>(){

                    @Override
                    public int compare(Object o1, Object o2) {
                        return ((CsvCluster)o1).getName().compareTo((String)o2);
                    }
                });
                if (res >= 0) {
                    ((CsvCluster)listClusters.get(res)).addIndice(i2);
                }
                ++i2;
            }
            ArrayList<CsvCluster> arrayList = listClusters;
            return arrayList;
        }
        finally {
            monitor.done();
        }
    }

    public static List<CsvCluster> getClusterListWithRange(List<List<String>> model, List<Integer> listCheckedRowIndices, int clusterKeyColumnIndex, double range, IProgressMonitor monitor) throws InterruptedException {
        ArrayList<CsvCluster> listClusters = new ArrayList<CsvCluster>();
        try {
            int i2;
            int divisor = 1;
            if (listClusters.size() > 100) {
                divisor = 100;
            }
            if (listClusters.size() > 10000) {
                divisor = 1000;
            }
            monitor.beginTask("Fetching cluster list", model.size() / divisor);
            int counterSteps = 0;
            for (int i2 : listCheckedRowIndices) {
                List<String> row = model.get(i2);
                String groupName = row.get(clusterKeyColumnIndex);
                int res = Collections.binarySearch(listClusters, groupName, new Comparator<Object>(){

                    @Override
                    public int compare(Object o1, Object o2) {
                        double n1 = 0.0;
                        double n2 = 0.0;
                        try {
                            n1 = Double.parseDouble(ClusterUtils.sanitizeNumber(((CsvCluster)o1).getName()));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        try {
                            n2 = Double.parseDouble(ClusterUtils.sanitizeNumber(o2.toString()));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (n1 > n2) {
                            return 1;
                        }
                        if (n1 < n2) {
                            return -1;
                        }
                        return 0;
                    }
                });
                if (res >= 0) continue;
                listClusters.add(-(res + 1), new CsvCluster(groupName, i2));
            }
            i2 = 0;
            while (i2 < model.size()) {
                List<String> row = model.get(i2);
                String rowName = row.get(clusterKeyColumnIndex);
                double rowNameNumber = 0.0;
                try {
                    rowNameNumber = Double.parseDouble(ClusterUtils.sanitizeNumber(rowName));
                    int res = Collections.binarySearch(listClusters, rowName, new Comparator<Object>(){

                        @Override
                        public int compare(Object o1, Object o2) {
                            double n1 = 0.0;
                            double n2 = 0.0;
                            try {
                                n1 = Double.parseDouble(ClusterUtils.sanitizeNumber(((CsvCluster)o1).getName()));
                            }
                            catch (NumberFormatException ex) {
                                n1 = -1.0;
                            }
                            try {
                                n2 = Double.parseDouble(ClusterUtils.sanitizeNumber(o2.toString()));
                            }
                            catch (NumberFormatException ex) {
                                n2 = -1.0;
                            }
                            if (n1 > n2) {
                                return 1;
                            }
                            if (n1 < n2) {
                                return -1;
                            }
                            return 0;
                        }
                    });
                    int prevIndex = 0;
                    if (res >= 0) {
                        prevIndex = res - 1;
                        if (prevIndex < 0) {
                            prevIndex = 0;
                        }
                    } else {
                        prevIndex = -(res + 1);
                        if (prevIndex >= listClusters.size()) {
                            --prevIndex;
                        }
                    }
                    String clusterName = ((CsvCluster)listClusters.get(prevIndex)).getName();
                    double clusterNameNumber = Double.parseDouble(ClusterUtils.sanitizeNumber(clusterName));
                    double overlap = Math.abs(clusterNameNumber - rowNameNumber);
                    while (prevIndex > 0 && overlap <= range) {
                        clusterName = ((CsvCluster)listClusters.get(--prevIndex)).getName();
                        clusterNameNumber = Double.parseDouble(ClusterUtils.sanitizeNumber(clusterName));
                        overlap = Math.abs(clusterNameNumber - rowNameNumber);
                    }
                    boolean overlapFound = false;
                    boolean overlapLost = false;
                    boolean stop = false;
                    int j = prevIndex;
                    while (j < listClusters.size() && !stop) {
                        clusterName = ((CsvCluster)listClusters.get(j)).getName();
                        clusterNameNumber = Double.parseDouble(ClusterUtils.sanitizeNumber(clusterName));
                        overlap = Math.abs(clusterNameNumber - rowNameNumber);
                        if (overlap <= range) {
                            ((CsvCluster)listClusters.get(j)).addIndice(i2);
                            overlapFound = true;
                            overlapLost = false;
                        } else {
                            overlapLost = true;
                        }
                        if (overlapFound && overlapLost) {
                            stop = true;
                        }
                        ++j;
                    }
                    if (++counterSteps % divisor == 0) {
                        monitor.worked(1);
                    }
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                ++i2;
            }
            ArrayList<CsvCluster> arrayList = listClusters;
            return arrayList;
        }
        finally {
            monitor.done();
        }
    }

    private static String sanitizeNumber(String number) {
        if (number.equals("")) {
            return "0";
        }
        return number.replace(",", ".").replace("e", "E");
    }

    public static boolean columnHasNonNumericValues(List<List<String>> model, int columnIndex, IProgressMonitor monitor) throws InterruptedException {
        boolean hasNonNumericValues = false;
        int steps = model.size() / 100;
        int counter = 0;
        monitor.beginTask("Validating column format", 100);
        monitor.subTask("Reading column");
        for (List<String> row : model) {
            try {
                Double.parseDouble(ClusterUtils.sanitizeNumber(row.get(columnIndex)));
            }
            catch (NumberFormatException ex) {
                hasNonNumericValues = true;
                throw new InterruptedException();
            }
            if (counter != 0 && counter % steps == 0) {
                monitor.worked(1);
            }
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            ++counter;
        }
        return hasNonNumericValues;
    }
}

