/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.model.CsvEditor;

import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.model.CsvEditor.CsvModifiedRecord;
import com.biotechvana.csveditor.model.CsvEditor.actions.CsvActionRowCheck;
import com.biotechvana.csveditor.model.CsvEditor.actions.CsvActionRowEdit;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;

public class CSVEditorSupport
extends EditingSupport {
    private CellEditor editor;
    private int column;
    private CSVEditor csvEditor;
    private TableViewer tableViewer;
    private boolean debug = false;

    public CSVEditorSupport(CSVEditor csvEditor, int column) {
        super((ColumnViewer)csvEditor.getTableViewer());
        this.csvEditor = csvEditor;
        this.tableViewer = csvEditor.getTableViewer();
        this.column = column;
        this.debug = csvEditor.getDebug();
        switch (column) {
            case 0: {
                this.editor = new CheckboxCellEditor((Composite)this.tableViewer.getTable(), 40);
                break;
            }
            case 1: {
                this.editor = null;
                break;
            }
            default: {
                this.editor = new TextCellEditor((Composite)this.tableViewer.getTable());
            }
        }
    }

    protected boolean canEdit(Object element) {
        return this.column != 1;
    }

    protected CellEditor getCellEditor(Object element) {
        return this.editor;
    }

    protected Object getValue(Object element) {
        ArrayList row = (ArrayList)element;
        if (this.column == 0) {
            if (((String)row.get(0)).equals("0")) {
                return false;
            }
            return true;
        }
        return row.get(this.column);
    }

    protected void setValue(Object element, Object value) {
        block12: {
            ArrayList row = (ArrayList)element;
            String oldValue = (String)row.get(this.column);
            if (oldValue.equals(value)) {
                return;
            }
            if (this.column == 0) {
                int rowIndex = Integer.parseInt((String)row.get(1)) - 1;
                if (oldValue.equals("0")) {
                    row.set(0, "1");
                    this.csvEditor.getListActions().add(new CsvActionRowCheck(rowIndex, true));
                } else {
                    row.set(0, "0");
                    this.csvEditor.getListActions().add(new CsvActionRowCheck(rowIndex, false));
                }
            } else {
                row.set(this.column, value.toString());
                try {
                    int fastaRowIndex = -1;
                    int fastaColIndex = -1;
                    int rowIndex = Integer.parseInt((String)row.get(1)) - 1;
                    if (!oldValue.equals(value)) {
                        this.csvEditor.getListModifiedRecords().add(new CsvModifiedRecord(rowIndex, this.column, fastaRowIndex, fastaColIndex, oldValue, value.toString()));
                        this.csvEditor.getListActions().add(new CsvActionRowEdit(rowIndex, this.column, oldValue, value.toString()));
                    }
                    this.csvEditor.setModified(true);
                }
                catch (Exception ex) {
                    if (!this.debug) break block12;
                    ex.printStackTrace();
                }
            }
        }
        if (this.csvEditor.isShowAnnotationColors()) {
            block13: {
                try {
                    this.csvEditor.loadAnnotationColors();
                }
                catch (InterruptedException ex) {
                }
                catch (InvocationTargetException e) {
                    if (!this.debug) break block13;
                    e.printStackTrace();
                }
            }
            this.csvEditor.setShowAnnotationColors(true);
        }
        this.getViewer().update(element, null);
    }
}

