/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.jobs.taxonomy;

import com.biotechvana.csveditor.jobs.taxonomy.AddGOsToCSV;
import com.biotechvana.utils.FilenameUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class AnnotatorHTTPRunnable2
implements IRunnableWithProgress {
    public static final int FILE_NOT_FOUND = -1;
    private File[] inputFiles;
    private File outputFolder;
    private int columnGi = -1;
    private int columnAccession = -1;
    private int columnSubject = -1;
    private Map<String, Integer> mapInput = new HashMap<String, Integer>();
    private List<String> listAppend = new ArrayList<String>();
    private int lineCount;
    public static final String INPUT_GI = "GI";
    public static final String INPUT_SUBJECT = "Subject";
    public static final String INPUT_SWISSPROT_ACCESSION = "SwissProt accession";
    public static final String INPUT_GENBANK_ACCESSION = "GenBank accession";
    public static final String INPUT_GO = "GO";
    public static final String APPEND_GO = "GO";
    public static final String APPEND_EVIDENCE = "Evidence codes";
    public static final String APPEND_ENZYME = "Enzyme";
    public static final String APPEND_ACCESSION_GENBANK = "GenBank accession";
    public static final String APPEND_ACCESSION_SWISSPROT = "SwissProt accession";
    public static final String APPEND_GI = "GI";

    public AnnotatorHTTPRunnable2(File[] inputFiles, File outputFolder, Map<String, Integer> mapInput, List<String> listAppend, int lineCount) {
        this.inputFiles = inputFiles;
        this.outputFolder = outputFolder;
        this.mapInput = mapInput;
        this.listAppend = listAppend;
        this.lineCount = lineCount;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        if (this.inputFiles.length == 1) {
            try {
                monitor.beginTask("Append annotation data", 100);
                this.searchInFile(this.inputFiles[0], monitor);
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
        }
        monitor.beginTask("Add GOs", this.inputFiles.length);
        int i = 0;
        while (i < this.inputFiles.length) {
            monitor.subTask("Reading file: " + this.inputFiles[i].getName());
            try {
                this.searchInFile(this.inputFiles[1], (IProgressMonitor)new NullProgressMonitor());
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
            monitor.worked(1);
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            ++i;
        }
        monitor.done();
    }

    public void validateInputAppend() throws AnnotationFormatsException {
        if (this.listAppend.contains("GO") && !this.mapInput.containsKey(INPUT_SUBJECT) && !this.mapInput.containsKey("SwissProt accession") && !this.listAppend.contains("SwissProt accession")) {
            throw new AnnotationFormatsException("GO requires subject of swissprot accession");
        }
        if (this.listAppend.contains(APPEND_EVIDENCE) && !this.mapInput.containsKey("GO") && !this.listAppend.contains("GO")) {
            throw new AnnotationFormatsException("Evidence codes require GO codes");
        }
        if (this.listAppend.contains(APPEND_ENZYME) && !this.mapInput.containsKey("GO") && !this.listAppend.contains("GO")) {
            throw new AnnotationFormatsException("Evidence codes require GO codes");
        }
    }

    private void searchInFile(File csvFile, IProgressMonitor monitor) throws IOException, InterruptedException {
        String basename = FilenameUtils.getBasename((String)csvFile.getName());
        String extension = FilenameUtils.getExtension((String)csvFile.getName());
        AddGOsToCSV addGos = new AddGOsToCSV(csvFile, this.columnGi, this.columnAccession, this.columnSubject, new File(this.outputFolder, basename + "_with_annotations" + extension), this.lineCount);
        addGos.run(monitor);
    }

    public class AnnotationFormatsException
    extends Exception {
        private static final long serialVersionUID = 3657627993271405401L;

        public AnnotationFormatsException(String message) {
            super(message);
        }
    }
}

