/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.jobs.taxonomy;

import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.pipelineCommander.PipelineCommanderQueryUtils;
import com.biotechvana.utils.IPrefs;
import com.biotechvana.utils.PreferenceManager;
import com.biotechvana.utils.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class AddEnzymeCodesByGoHTTPRunnable
implements IRunnableWithProgress {
    private final String NULLSTRING = "--UD--";
    public static final int FILE_NOT_FOUND = -1;
    private final String PIPELINE_USER = PreferenceManager.getInstance().get("ssh_user", "");
    private final String PIPELINE_PASS = PreferenceManager.getInstance().get("ssh_password", "");
    private final String DB_NAME = PreferenceManager.getInstance().get("DB_PIPELINE", "");
    private CSVEditor csvEditor;
    private List<String> row;
    private NumberFormat numberFormat = NumberFormat.getInstance();
    private int startColumn;
    private int column;
    private HashMap<String, ArrayList<String>> mapGoEc = new HashMap();
    private final String queryEcByGo = "SELECT ec2go.ecid, ec2go.ec_desc, ec2go.go FROM ec2go WHERE ec2go.go LIKE ?";

    public AddEnzymeCodesByGoHTTPRunnable(CSVEditor csvEditor, int column) {
        this.csvEditor = csvEditor;
        this.column = column;
        this.startColumn = csvEditor.getColumnCount() - 1;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            this.searchEnzyme(monitor);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InvocationTargetException(e);
        }
    }

    public void searchEnzyme(IProgressMonitor monitor) throws InterruptedException {
        List model = (List)this.csvEditor.getModel();
        int modelLength = model.size();
        try {
            try {
                int stepBlock = modelLength / 100;
                if (stepBlock < 1) {
                    stepBlock = 1;
                }
                monitor.beginTask("Enzyme code search", 100);
                int i = 0;
                while (i < modelLength) {
                    this.row = (List)model.get(i);
                    String key = this.row.get(this.column);
                    List<String> goCodes = this.getGoCodesFromString(key);
                    ArrayList<String> listEnzymes = this.getEcByGo(goCodes);
                    if (this.row.size() <= this.startColumn) {
                        int missingI = this.row.size();
                        while (missingI <= this.startColumn) {
                            this.row.add("");
                            ++missingI;
                        }
                    }
                    if (listEnzymes != null && listEnzymes.size() > 0) {
                        this.row.set(this.startColumn, StringUtils.join(listEnzymes, (String)";"));
                    } else {
                        this.row.set(this.startColumn, "");
                    }
                    this.csvEditor.getSite().getShell().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            AddEnzymeCodesByGoHTTPRunnable.this.csvEditor.getTableViewer().update(AddEnzymeCodesByGoHTTPRunnable.this.row, null);
                        }
                    });
                    if (i % stepBlock == 0) {
                        monitor.subTask("Parsing row (" + this.numberFormat.format(i + 1) + "/" + this.numberFormat.format(modelLength) + ")");
                        monitor.worked(1);
                    }
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    private List<String> getGoCodesFromString(String goCodeText) {
        ArrayList<String> listGoCodes = new ArrayList<String>();
        Pattern patternGo = Pattern.compile("GO:\\d+");
        Matcher m = patternGo.matcher(goCodeText);
        while (m.find()) {
            listGoCodes.add(m.group().trim());
        }
        return listGoCodes;
    }

    private ArrayList<String> getEcByGo(List<String> goCodes) {
        ArrayList<String> listEnzymes = new ArrayList<String>();
        for (String go : goCodes) {
            if (go.isEmpty()) continue;
            if (this.mapGoEc.containsKey(go)) {
                if (this.mapGoEc.get(go) == null || this.mapGoEc.get(go).size() <= 0) continue;
                for (String ec : this.mapGoEc.get(go)) {
                    if (ec == null || ec.length() <= 0 || listEnzymes.contains(ec)) continue;
                    listEnzymes.add(ec);
                }
                continue;
            }
            String preparedQuery = PipelineCommanderQueryUtils.prepareQuery((String)"SELECT ec2go.ecid, ec2go.ec_desc, ec2go.go FROM ec2go WHERE ec2go.go LIKE ?", (String[])new String[]{go}, (String[])new String[]{"s"});
            List resultSet = PipelineCommanderQueryUtils.runQuery((IPrefs)PreferenceManager.getInstance(), (String)PreferenceManager.getInstance().get("ssh_host", "opathy.biotechvana.com"), (String)this.PIPELINE_USER, (String)this.PIPELINE_PASS, (String)this.DB_NAME, (String)preparedQuery);
            if (resultSet == null || resultSet.size() < 0) continue;
            if (!this.mapGoEc.containsKey(go)) {
                this.mapGoEc.put(go, new ArrayList());
            }
            try {
                int i = 1;
                while (i < resultSet.size()) {
                    String v = (String)((List)resultSet.get(i)).get(0);
                    if (v != null && v.length() > 0 && !listEnzymes.contains(v)) {
                        listEnzymes.add(v);
                        this.mapGoEc.get(go).add(v);
                    }
                    ++i;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return listEnzymes;
    }
}

