/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.jobs.csvEditor;

import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.model.CsvEditor.actions.CsvAction;
import com.biotechvana.csveditor.model.CsvEditor.actions.CsvActionRowEdit;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class CsvUndoRowEditRunnable
implements IRunnableWithProgress {
    private final String TASK_NAME = "Undo edit rows";
    private CSVEditor csvEditor;
    private CsvAction lastAction;
    private List<CsvAction> listActions = new ArrayList<CsvAction>();
    private List<CsvAction> undoActions = new ArrayList<CsvAction>();
    private List<List<String>> model;
    private Shell shell;

    public CsvUndoRowEditRunnable(CSVEditor csvEditor, CsvAction lastAction) {
        this.csvEditor = csvEditor;
        this.lastAction = lastAction;
        this.listActions = csvEditor.getListActions();
        this.shell = csvEditor.getSite().getShell();
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        long lastTimestamp = this.lastAction.getTimestamp();
        int counter = this.listActions.size() - 1;
        CsvAction ac = this.listActions.get(counter);
        while (counter >= 0) {
            ac = this.listActions.get(counter);
            if (ac == null || ac.getTimestamp() != lastTimestamp || ac.getType() != 3) break;
            this.undoActions.add(this.listActions.remove(counter));
            --counter;
        }
        this.undoEdit(monitor);
    }

    private void undoEdit(IProgressMonitor monitor) throws InterruptedException {
        try {
            monitor.beginTask("Undo edit rows", this.undoActions.size());
            this.model = (List)this.csvEditor.getModel();
            int i = this.undoActions.size() - 1;
            while (i >= 0) {
                final CsvActionRowEdit editAction = (CsvActionRowEdit)this.undoActions.get(i);
                this.shell.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        List<String> row = CsvUndoRowEditRunnable.this.model.get(editAction.getRowIndex());
                        row.set(editAction.getColumnIndex(), editAction.getOldText());
                        CsvUndoRowEditRunnable.this.csvEditor.getTableViewer().update(row, null);
                    }
                });
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                --i;
            }
        }
        finally {
            monitor.done();
        }
    }
}

