/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.jobs.csvEditor;

import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.model.CsvEditor.actions.CsvAction;
import com.biotechvana.csveditor.model.CsvEditor.actions.CsvActionRowColor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class CsvUndoRowColorRunnable
implements IRunnableWithProgress {
    private final String TASK_NAME = "Undo set background color";
    private CSVEditor csvEditor;
    private CsvAction lastAction;
    private List<CsvAction> listActions = new ArrayList<CsvAction>();
    private List<CsvAction> undoActions = new ArrayList<CsvAction>();
    private Shell shell;

    public CsvUndoRowColorRunnable(CSVEditor csvEditor, CsvAction lastAction) {
        this.csvEditor = csvEditor;
        this.lastAction = lastAction;
        this.listActions = csvEditor.getListActions();
        this.shell = csvEditor.getSite().getShell();
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        long lastTimestamp = this.lastAction.getTimestamp();
        int counter = this.listActions.size() - 1;
        CsvAction ac = this.listActions.get(counter);
        while (counter >= 0) {
            ac = this.listActions.get(counter);
            if (ac == null || ac.getTimestamp() != lastTimestamp || ac.getType() != 8) break;
            this.undoActions.add(this.listActions.remove(counter));
            --counter;
        }
        this.undoColor(monitor);
    }

    private void undoColor(IProgressMonitor monitor) throws InterruptedException {
        try {
            monitor.beginTask("Undo set background color", this.undoActions.size());
            for (CsvAction action : this.undoActions) {
                final CsvActionRowColor colorAction = (CsvActionRowColor)action;
                this.shell.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        CsvUndoRowColorRunnable.this.csvEditor.getTable().getItem(colorAction.getRowIndex()).setBackground(colorAction.getOldColor());
                    }
                });
                monitor.worked(1);
                if (!monitor.isCanceled()) continue;
                throw new InterruptedException();
            }
        }
        finally {
            monitor.done();
        }
    }
}

