/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.jobs.csvEditor;

import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.model.CsvEditor.actions.CsvAction;
import com.biotechvana.csveditor.model.CsvEditor.actions.CsvActionRowCheck;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class CsvUndoRowCheckRunnable
implements IRunnableWithProgress {
    private final String TASK_NAME = "Undo check/uncheck rows";
    private CSVEditor csvEditor;
    private CsvAction lastAction;
    private List<CsvAction> listActions = new ArrayList<CsvAction>();
    private List<CsvAction> undoActions = new ArrayList<CsvAction>();
    private List<List<String>> model;
    private List<String> row;
    private Shell shell;

    public CsvUndoRowCheckRunnable(CSVEditor csvEditor, CsvAction lastAction) {
        this.csvEditor = csvEditor;
        this.lastAction = lastAction;
        this.listActions = csvEditor.getListActions();
        this.shell = csvEditor.getSite().getShell();
        this.model = (List)csvEditor.getModel();
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        long lastTimestamp = this.lastAction.getTimestamp();
        int counter = this.listActions.size() - 1;
        CsvAction ac = this.listActions.get(counter);
        while (counter >= 0) {
            ac = this.listActions.get(counter);
            if (ac == null || ac.getTimestamp() != lastTimestamp || ac.getType() != 9) break;
            this.undoActions.add(this.listActions.remove(counter));
            --counter;
        }
        this.undoCheck(monitor);
    }

    private void undoCheck(IProgressMonitor monitor) throws InterruptedException {
        try {
            monitor.beginTask("Undo check/uncheck rows", this.undoActions.size());
            for (CsvAction action : this.undoActions) {
                final CsvActionRowCheck checkAction = (CsvActionRowCheck)action;
                this.shell.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        CsvUndoRowCheckRunnable.this.row = CsvUndoRowCheckRunnable.this.model.get(checkAction.getRowIndex());
                        String value = "0";
                        if (!checkAction.isChecked()) {
                            value = "1";
                        }
                        CsvUndoRowCheckRunnable.this.row.set(0, value);
                        CsvUndoRowCheckRunnable.this.csvEditor.getTableViewer().update(CsvUndoRowCheckRunnable.this.row, null);
                    }
                });
                monitor.worked(1);
                if (!monitor.isCanceled()) continue;
                throw new InterruptedException();
            }
        }
        finally {
            monitor.done();
        }
    }
}

