/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.jobs.csvEditor;

import com.biotechvana.commons.SharedImages;
import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.model.CsvEditor.actions.CsvAction;
import com.biotechvana.csveditor.model.CsvEditor.actions.CsvActionColumnCheck;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;

public class CsvUndoColumnCheckRunnable
implements IRunnableWithProgress {
    private final String TASK_NAME = "Undo check/uncheck columns";
    private CSVEditor csvEditor;
    private CsvAction lastAction;
    private List<CsvAction> listActions = new ArrayList<CsvAction>();
    private List<CsvAction> undoActions = new ArrayList<CsvAction>();
    private Shell shell;
    private final Image CHECK_ENABLED = SharedImages.CHECKENABLED;
    private final Image CHECK_DISABLED = SharedImages.CHECKDISABLED;

    public CsvUndoColumnCheckRunnable(CSVEditor csvEditor, CsvAction lastAction) {
        this.csvEditor = csvEditor;
        this.lastAction = lastAction;
        this.listActions = csvEditor.getListActions();
        this.shell = csvEditor.getSite().getShell();
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        long lastTimestamp = this.lastAction.getTimestamp();
        int counter = this.listActions.size() - 1;
        CsvAction ac = this.listActions.get(counter);
        while (counter >= 0) {
            ac = this.listActions.get(counter);
            if (ac == null || ac.getTimestamp() != lastTimestamp || ac.getType() != 11) break;
            this.undoActions.add(this.listActions.remove(counter));
            --counter;
        }
        this.undoCheck(monitor);
    }

    private void undoCheck(IProgressMonitor monitor) throws InterruptedException {
        try {
            monitor.beginTask("Undo check/uncheck columns", this.undoActions.size());
            for (CsvAction action : this.undoActions) {
                final CsvActionColumnCheck checkAction = (CsvActionColumnCheck)action;
                this.shell.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        int index = checkAction.getIndex();
                        TableColumn[] tableColumns = CsvUndoColumnCheckRunnable.this.csvEditor.getTable().getColumns();
                        if (tableColumns[index].getImage().equals((Object)CsvUndoColumnCheckRunnable.this.CHECK_ENABLED)) {
                            tableColumns[index].setImage(CsvUndoColumnCheckRunnable.this.CHECK_DISABLED);
                        } else {
                            tableColumns[index].setImage(CsvUndoColumnCheckRunnable.this.CHECK_ENABLED);
                        }
                    }
                });
                monitor.worked(1);
                if (!monitor.isCanceled()) continue;
                throw new InterruptedException();
            }
        }
        finally {
            monitor.done();
        }
    }
}

