/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.jobs.csvEditor;

import com.biotechvana.csveditor.editors.CSVEditor;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class CsvSelectNotEmptyCellRowsRunnable
implements IRunnableWithProgress {
    private DecimalFormat decimalFormat = new DecimalFormat("###,###");
    private CSVEditor csvEditor;
    private int columnIndex;
    private Shell shell;
    private List<List<String>> model;
    private List<String> row;
    private int stepSize = 1;
    private int selectionCount = 0;

    public CsvSelectNotEmptyCellRowsRunnable(CSVEditor csvEditor, int columnIndex) {
        this.csvEditor = csvEditor;
        this.columnIndex = columnIndex;
        this.shell = csvEditor.getSite().getShell();
        this.model = (List)csvEditor.getModel();
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        if (this.model.size() > 100) {
            this.stepSize = this.model.size() / 100;
        }
        long timeStart = System.currentTimeMillis();
        this.selectNotEmptyCellRows(monitor);
        long timeEnd = System.currentTimeMillis();
        if (this.csvEditor.getDebug()) {
            System.out.println("Selected " + this.decimalFormat.format(this.selectionCount) + " rows in " + this.decimalFormat.format(timeEnd - timeStart) + "ms");
        }
    }

    private void selectNotEmptyCellRows(IProgressMonitor monitor) throws InterruptedException {
        try {
            monitor.beginTask("Select not empty rows", this.model.size());
            this.shell.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    CsvSelectNotEmptyCellRowsRunnable.this.csvEditor.getTable().deselectAll();
                }
            });
            int i = 0;
            while (i < this.model.size()) {
                this.row = this.model.get(i);
                if (!this.row.get(this.columnIndex).equals("--UD--") && this.row.get(this.columnIndex).length() > 0) {
                    ++this.selectionCount;
                    final int fi = i;
                    this.shell.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            CsvSelectNotEmptyCellRowsRunnable.this.csvEditor.getTable().select(fi);
                        }
                    });
                }
                if (i % this.stepSize == 0) {
                    monitor.worked(this.stepSize);
                }
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }
}

