/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.jobs.csvEditor;

import com.biotechvana.csveditor.dialogs.csvEditor.CsvSelectTermDialog;
import com.biotechvana.csveditor.editors.CSVEditor;
import java.lang.reflect.InvocationTargetException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class CsvSelectByTermRunnable
implements IRunnableWithProgress {
    private NumberFormat decimalFormat = NumberFormat.getInstance();
    private CSVEditor csvEditor;
    private int columnIndex;
    private int itemCount;
    private CsvSelectTermDialog.Term[] termList;
    private List<List<Integer>> listIndices;
    private Shell shell;
    private int stepSize = 1;
    private boolean exact = false;
    private boolean ignoreCase = false;
    private boolean regexp = false;

    public CsvSelectByTermRunnable(CSVEditor csvEditor, int columnIndex, CsvSelectTermDialog.Term[] termList, boolean exact, boolean ignoreCase, boolean regexp) {
        this.csvEditor = csvEditor;
        this.columnIndex = columnIndex;
        this.termList = termList;
        this.exact = exact;
        this.ignoreCase = ignoreCase;
        this.regexp = regexp;
        this.shell = csvEditor.getSite().getShell();
        this.itemCount = csvEditor.getTable().getItemCount();
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        if (this.itemCount > 100) {
            this.stepSize = this.itemCount / 100;
        }
        long timeStart = System.currentTimeMillis();
        this.selectByTerms(monitor);
        long timeEnd = System.currentTimeMillis();
        if (this.csvEditor.getDebug()) {
            System.out.println("Selected " + this.termList.length + " terms in " + this.decimalFormat.format(timeEnd - timeStart) + "ms");
        }
    }

    public List<List<Integer>> getMatchingIndices() {
        return this.listIndices;
    }

    private void selectByTerms(IProgressMonitor monitor) throws InterruptedException {
        try {
            this.listIndices = new ArrayList<List<Integer>>(this.termList.length);
            int i = 0;
            while (i < this.termList.length) {
                this.listIndices.add(new ArrayList());
                ++i;
            }
            monitor.beginTask("Select by terms", this.itemCount);
            i = 0;
            while (i < this.itemCount) {
                final int fi = i;
                this.shell.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        String rowValue = CsvSelectByTermRunnable.this.csvEditor.getTable().getItem(fi).getText(CsvSelectByTermRunnable.this.columnIndex);
                        int t = 0;
                        while (t < CsvSelectByTermRunnable.this.termList.length) {
                            String currentTerm = CsvSelectByTermRunnable.this.termList[t].getTerm();
                            if (CsvSelectByTermRunnable.this.regexp) {
                                if (Pattern.compile(currentTerm).matcher(rowValue).matches()) {
                                    CsvSelectByTermRunnable.this.listIndices.get(t).add(fi);
                                }
                            } else if (CsvSelectByTermRunnable.this.exact) {
                                if (CsvSelectByTermRunnable.this.ignoreCase) {
                                    if (rowValue.equalsIgnoreCase(currentTerm)) {
                                        CsvSelectByTermRunnable.this.listIndices.get(t).add(fi);
                                    }
                                } else if (rowValue.equals(currentTerm)) {
                                    CsvSelectByTermRunnable.this.listIndices.get(t).add(fi);
                                }
                            } else if (CsvSelectByTermRunnable.this.ignoreCase) {
                                System.out.println("partial ignore");
                                if (rowValue.toLowerCase().indexOf(currentTerm.toLowerCase()) != -1) {
                                    CsvSelectByTermRunnable.this.listIndices.get(t).add(fi);
                                }
                            } else if (rowValue.indexOf(currentTerm) != -1) {
                                CsvSelectByTermRunnable.this.listIndices.get(t).add(fi);
                            }
                            ++t;
                        }
                    }
                });
                if (i % this.stepSize == 0) {
                    monitor.worked(this.stepSize);
                    monitor.subTask("Reading row " + this.decimalFormat.format(i + 1) + " of " + this.decimalFormat.format(this.itemCount) + " total rows.");
                }
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }
}

