/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.jobs.csvEditor;

import com.biotechvana.csveditor.editors.CSVEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class CsvResetModelIndicesRunnable
implements IRunnableWithProgress {
    private final String TASK_NAME = "Reset table indices";
    private CSVEditor csvEditor;
    private Shell shell;
    private List<List<String>> model;
    private int stepSize = 100;

    public CsvResetModelIndicesRunnable(CSVEditor csvEditor) {
        this.csvEditor = csvEditor;
        this.shell = csvEditor.getSite().getShell();
        this.model = (List)csvEditor.getModel();
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.resetModelIndices(monitor);
    }

    private void resetModelIndices(IProgressMonitor monitor) {
        try {
            monitor.beginTask("Reset table indices", this.model.size());
            monitor.subTask("Refreshing indices...");
            int i = 0;
            while (i < this.model.size()) {
                List<String> row = this.model.get(i);
                row.set(1, String.valueOf(i + 1));
                if (i % this.stepSize == 0) {
                    monitor.worked(this.stepSize);
                }
                ++i;
            }
            this.shell.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    CsvResetModelIndicesRunnable.this.csvEditor.getTableViewer().refresh();
                }
            });
        }
        finally {
            monitor.done();
        }
    }
}

