/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.jobs.csvEditor;

import com.biotechvana.csveditor.editors.CSVEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class CsvRemoveColorRowsRunnable
implements IRunnableWithProgress {
    private final String TASK_NAME = "Remove colors";
    private CSVEditor csvEditor;
    private List<Integer> listIndices;
    private int stepSize = 1;
    private int totalRowIndices = 0;

    public CsvRemoveColorRowsRunnable(CSVEditor csvEditor, List<Integer> listIndices) {
        this.csvEditor = csvEditor;
        this.listIndices = listIndices;
    }

    public CsvRemoveColorRowsRunnable(CSVEditor csvEditor) {
        this.csvEditor = csvEditor;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.beginTask("Remove colors", 100);
        if (this.totalRowIndices > 100) {
            this.stepSize = this.totalRowIndices / 100;
        }
        int counter = 0;
        if (this.listIndices != null) {
            for (int i : this.listIndices) {
                this.csvEditor.getTableViewer().getTable().getItem(i).setBackground(null);
                if (++counter % this.stepSize == 0) {
                    monitor.worked(1);
                }
                if (!monitor.isCanceled()) continue;
                throw new InterruptedException();
            }
        } else {
            int itemCount = this.csvEditor.getTableViewer().getTable().getItemCount();
            int i = 0;
            while (i < itemCount) {
                this.csvEditor.getTableViewer().getTable().getItem(i).setBackground(null);
                if (++counter % this.stepSize == 0) {
                    monitor.worked(1);
                }
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                ++i;
            }
        }
        monitor.done();
    }
}

