/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.jobs.csvEditor;

import com.biotechvana.csvUtils.CsvBufferedReader;
import com.biotechvana.csvUtils.CsvWriter;
import com.biotechvana.javabiotoolkit.exceptions.FastaReaderNotParsedException;
import com.biotechvana.javabiotoolkit.io.FASTAFileRecord;
import com.biotechvana.javabiotoolkit.io.FASTAReader;
import com.biotechvana.utils.FilenameUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class CsvMergeSequencesRunnable
implements IRunnableWithProgress {
    private File fileFasta;
    private File fileCsv;
    private File folderOutput;
    private int columnSeqnameIndex;
    private int columnAnnotationIndex;
    private int columnQueryFromIndex;
    private int columnQueryToIndex;
    private int columnHitFromIndex;
    private int columnHitToIndex;
    private int columnQueryLenIndex;
    private int columnHitLenIndex;
    private int columnQueryFrameIndex = -1;
    private float identityThreshold = 100.0f;
    private boolean mergeNonOverlapping = false;
    private int trimEnds = 0;
    private Map<String, List<CsvAnnotation>> mapAnnotations;
    private static final String FRAME_PLUS = "+";
    private static final String FRAME_MINUS = "-";
    private FASTAReader reader;
    private List<FASTAFileRecord> listAllRecords;
    private RandomAccessFile raf;
    private final char PAD_STRING = (char)78;
    private BufferedWriter writerLog;

    public static void main(String[] args) {
        CsvMergeSequencesRunnable runnable = new CsvMergeSequencesRunnable(new File("/home/rfutami/Escritorio/mergeando/lubina_10.fa"), new File("/home/rfutami/Escritorio/mergeando/report_10.csv"), new File("/home/rfutami/Escritorio/mergeando"), 1, 2, 8, 9, 10, 11, 16, 17, 12, 90.0f, false, 0);
        try {
            runnable.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public CsvMergeSequencesRunnable(File fileFasta, File fileCsv, File folderOutput, int columnSeqnameIndex, int columnAnnotationIndex, int columnQueryFromIndex, int columnQueryToIndex, int columnHitFromIndex, int columnHitToIndex, int columnQueryLenIndex, int columnHitLenIndex, int columnQueryFrameIndex, float identityThreshold, boolean mergeNonOverlapping, int trimEnds) {
        this.fileFasta = fileFasta;
        this.fileCsv = fileCsv;
        this.folderOutput = folderOutput;
        this.columnSeqnameIndex = columnSeqnameIndex;
        this.columnAnnotationIndex = columnAnnotationIndex;
        this.columnQueryFromIndex = columnQueryFromIndex;
        this.columnQueryToIndex = columnQueryToIndex;
        this.columnHitFromIndex = columnHitFromIndex;
        this.columnHitToIndex = columnHitToIndex;
        this.columnQueryLenIndex = columnQueryLenIndex;
        this.columnHitLenIndex = columnHitLenIndex;
        this.columnQueryFrameIndex = columnQueryFrameIndex;
        this.mergeNonOverlapping = mergeNonOverlapping;
        this.trimEnds = trimEnds;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            System.out.println("Reading fasta");
            this.readFasta(monitor);
            System.out.println("OK");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InvocationTargetException(e, "Failed reading fasta file: " + e.getMessage());
        }
        try {
            try {
                this.raf = new RandomAccessFile(this.fileFasta, "r");
                System.out.println("Read csv");
                this.readCsvData(monitor);
                System.out.println("OK");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new InvocationTargetException(e, "Failed reading csv file: " + e.getMessage());
            }
        }
        finally {
            try {
                this.raf.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void readFasta(IProgressMonitor monitor) throws FileNotFoundException, IOException, FastaReaderNotParsedException {
        this.reader = new FASTAReader(this.fileFasta);
        this.reader.parse(true);
        this.listAllRecords = this.reader.getFastaRecords();
        this.listAllRecords.sort(new Comparator<FASTAFileRecord>(){

            @Override
            public int compare(FASTAFileRecord o1, FASTAFileRecord o2) {
                return o1.getDescriptionSB().toString().compareTo(o2.getDescriptionSB().toString());
            }
        });
    }

    private void readCsvData(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException, IOException {
        CsvBufferedReader csvReader = new CsvBufferedReader(this.fileCsv, ';', '\"');
        String basename = FilenameUtils.getBasename((String)this.fileFasta.getName());
        File outputFileFasta = new File(String.valueOf(this.folderOutput) + "/" + basename + "_merged.fa");
        File outputFileCsv = new File(String.valueOf(this.folderOutput) + "/" + basename + "_merged.csv");
        File logFile = new File(String.valueOf(this.folderOutput) + "/" + basename + ".log");
        BufferedWriter writerFasta = null;
        CsvWriter writerCsv = null;
        try {
            try {
                block27: {
                    writerFasta = new BufferedWriter(new FileWriter(outputFileFasta));
                    this.writerLog = new BufferedWriter(new FileWriter(logFile));
                    writerCsv = new CsvWriter(outputFileCsv, ';', '\"');
                    try {
                        try {
                            List row = csvReader.readLine();
                            if (writerCsv != null) {
                                writerCsv.write(row);
                            }
                            int lineCounter = 1;
                            while ((row = csvReader.readLine()) != null) {
                                String name = ((String)row.get(this.columnSeqnameIndex)).trim();
                                String annotation = ((String)row.get(this.columnAnnotationIndex)).trim();
                                if (annotation.isEmpty()) continue;
                                int startQuery = -1;
                                int endQuery = -1;
                                int startHit = -1;
                                int endHit = -1;
                                int lenQuery = -1;
                                int lenHit = -1;
                                try {
                                    startQuery = Integer.parseInt(((String)row.get(this.columnQueryFromIndex)).trim());
                                    endQuery = Integer.parseInt(((String)row.get(this.columnQueryToIndex)).trim());
                                    startHit = Integer.parseInt(((String)row.get(this.columnHitFromIndex)).trim());
                                    endHit = Integer.parseInt(((String)row.get(this.columnHitToIndex)).trim());
                                    lenQuery = Integer.parseInt(((String)row.get(this.columnQueryLenIndex)).trim());
                                    lenHit = Integer.parseInt(((String)row.get(this.columnHitLenIndex)).trim());
                                }
                                catch (Exception ex) {
                                    continue;
                                }
                                String frameQuery = this.parseFrame(((String)row.get(this.columnQueryFrameIndex)).trim());
                                if (this.mapAnnotations == null) {
                                    this.mapAnnotations = new HashMap<String, List<CsvAnnotation>>();
                                }
                                CsvAnnotation csvAnnotation = new CsvAnnotation();
                                csvAnnotation.sequenceName = name;
                                csvAnnotation.annotation = annotation;
                                csvAnnotation.startQuery = startQuery;
                                csvAnnotation.endQuery = endQuery;
                                csvAnnotation.startHit = startHit;
                                csvAnnotation.endHit = endHit;
                                csvAnnotation.lenQuery = lenQuery;
                                csvAnnotation.lenHit = lenHit;
                                csvAnnotation.frameQuery = frameQuery;
                                if (!this.mapAnnotations.containsKey(annotation)) {
                                    this.mapAnnotations.put(annotation, new ArrayList());
                                }
                                this.mapAnnotations.get(annotation).add(csvAnnotation);
                                if (monitor.isCanceled()) {
                                    throw new InterruptedException();
                                }
                                ++lineCounter;
                            }
                            for (String k : this.mapAnnotations.keySet()) {
                                this.parseGroup(this.mapAnnotations.get(k), writerCsv, writerFasta, this.writerLog);
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            try {
                                csvReader.close();
                                break block27;
                            }
                            catch (IOException e2) {
                                throw new InvocationTargetException(e2);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            csvReader.close();
                        }
                        catch (IOException e) {
                            throw new InvocationTargetException(e);
                        }
                        throw throwable;
                    }
                    try {
                        csvReader.close();
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                monitor.done();
            }
            catch (IOException e1) {
                throw new InvocationTargetException(e1);
            }
        }
        finally {
            if (writerFasta != null) {
                writerFasta.close();
            }
            if (this.writerLog != null) {
                this.writerLog.close();
            }
            if (writerCsv != null) {
                writerCsv.close();
            }
        }
    }

    private void parseSingle(CsvAnnotation annotation, CsvWriter writerCsv, BufferedWriter writerSequences, BufferedWriter writerLog) throws IOException {
        FASTAFileRecord fastaRecord = this.getMatchingFastaRecord(annotation.sequenceName);
        String sequence = this.getSequence(fastaRecord);
        String name = fastaRecord.getDescriptionSB().toString();
        writerLog.append("Single sequence in annotation:\n");
        writerLog.append("\t" + name + "\n");
        writerSequences.append(">" + name);
        writerSequences.append("\n");
        writerSequences.append(sequence);
        writerSequences.append("\n");
    }

    private int getDistance(CsvAnnotation annotation1, CsvAnnotation annotation2) {
        return annotation2.startQuery - annotation1.endQuery;
    }

    private void parseGroup(List<CsvAnnotation> listAnnotations, CsvWriter writerCsv, BufferedWriter writerSequences, BufferedWriter writerLog) throws IOException {
        if (listAnnotations.size() == 1) {
            this.parseSingle(listAnnotations.get(0), writerCsv, writerSequences, writerLog);
        }
        listAnnotations.sort(new Comparator<CsvAnnotation>(){

            @Override
            public int compare(CsvAnnotation o1, CsvAnnotation o2) {
                return o1.startHit - o2.startHit;
            }
        });
        CsvAnnotation annotationPrevious = listAnnotations.get(0);
        FASTAFileRecord fastaRecordPrevious = this.getMatchingFastaRecord(annotationPrevious.sequenceName);
        String sequencePrevious = this.getSequence(fastaRecordPrevious);
        Object namePrevious = fastaRecordPrevious.getDescriptionSB().toString();
        if (this.isReverseFrame(annotationPrevious.frameQuery)) {
            sequencePrevious = this.complement(this.reverse(sequencePrevious));
        }
        boolean haveBeenOverlapped = false;
        int i = 1;
        while (i < listAnnotations.size()) {
            CsvAnnotation annotationCurrent = listAnnotations.get(i);
            FASTAFileRecord fastaRecordCurrent = this.getMatchingFastaRecord(annotationCurrent.sequenceName);
            String sequenceCurrent = this.getSequence(fastaRecordCurrent);
            String nameCurrent = fastaRecordCurrent.getDescriptionSB().toString();
            if (this.isReverseFrame(annotationCurrent.frameQuery)) {
                sequenceCurrent = this.complement(this.reverse(sequenceCurrent));
            }
            int distance = this.getDistance(annotationPrevious, annotationCurrent);
            haveBeenOverlapped = false;
            String mergedSequence = null;
            if (distance <= 0) {
                mergedSequence = this.joinSequencesOverlapping(sequencePrevious, sequenceCurrent, annotationPrevious, annotationCurrent);
                if (mergedSequence == null) {
                    writerLog.append("Overlapping but cannot merge:\n");
                    writerLog.append("\t" + (String)namePrevious + "\n");
                    writerLog.append("\t" + nameCurrent + "\n");
                    writerSequences.append(">" + (String)namePrevious);
                    writerSequences.append("\n");
                    writerSequences.append(sequencePrevious);
                    writerSequences.append("\n");
                    writerSequences.append(">" + nameCurrent);
                    writerSequences.append("\n");
                    writerSequences.append(sequenceCurrent);
                    writerSequences.append("\n");
                } else {
                    writerLog.append("Overlapping and merge:\n");
                    writerLog.append("\t" + (String)namePrevious + "\n");
                    writerLog.append("\t" + nameCurrent + "\n");
                    haveBeenOverlapped = true;
                }
            } else if (this.mergeNonOverlapping) {
                writerLog.append("Non Overlapping but joined:\n");
                writerLog.append("\t" + (String)namePrevious + "\n");
                writerLog.append("\t" + nameCurrent + "\n");
                mergedSequence = this.joinSequencesNonOverlapping(sequencePrevious, sequenceCurrent, distance);
                haveBeenOverlapped = true;
            } else {
                writerLog.append("Non Overlapping and not joining:\n");
                writerLog.append("\t" + (String)namePrevious + "\n");
                writerLog.append("\t" + nameCurrent + "\n");
                writerSequences.append(">" + (String)namePrevious);
                writerSequences.append("\n");
                writerSequences.append(sequencePrevious);
                writerSequences.append("\n");
                writerSequences.append(">" + nameCurrent);
                writerSequences.append("\n");
                writerSequences.append(sequenceCurrent);
                writerSequences.append("\n");
            }
            if (haveBeenOverlapped) {
                sequencePrevious = mergedSequence;
                namePrevious = (String)namePrevious + "_" + nameCurrent;
                annotationPrevious.endQuery = annotationCurrent.endQuery;
            } else {
                annotationPrevious = annotationCurrent;
                fastaRecordPrevious = this.getMatchingFastaRecord(annotationCurrent.sequenceName);
                sequencePrevious = this.getSequence(fastaRecordCurrent);
                if (this.isReverseFrame(annotationPrevious.frameQuery)) {
                    sequencePrevious = this.complement(this.reverse(sequencePrevious));
                }
                namePrevious = nameCurrent;
            }
            ++i;
        }
        if (haveBeenOverlapped && sequencePrevious != null && sequencePrevious.length() > 0) {
            writerSequences.append(">" + (String)namePrevious);
            writerSequences.append("\n");
            writerSequences.append(sequencePrevious);
            writerSequences.append("\n");
        }
    }

    private String getSequence(FASTAFileRecord record) throws IOException {
        this.raf.seek(record.sequenceOffset());
        byte[] buffer = new byte[(int)record.sequenceBytes()];
        if (this.raf.read(buffer) != -1) {
            return new String(buffer).trim();
        }
        return null;
    }

    private String joinSequencesOverlapping(String seqPrevious, String seqCurrent, CsvAnnotation annotationPrevious, CsvAnnotation annotationCurrent) throws IOException {
        String nextWithPad;
        int maxOverlappingLen;
        String prevWithPad;
        float identityRatio;
        try {
            System.out.println("previous: " + annotationPrevious.annotation);
            System.out.println("sequence: " + annotationPrevious.sequenceName);
            System.out.println("end_query: " + annotationPrevious.endQuery);
            System.out.println("curent: " + annotationCurrent.annotation);
            System.out.println("sequence: " + annotationCurrent.sequenceName);
            System.out.println("start_query:" + annotationCurrent.startQuery);
            System.out.println("current len: " + seqCurrent.length());
            System.out.println("**************\n");
            seqPrevious.substring(0, annotationPrevious.endQuery);
            seqCurrent.substring(annotationCurrent.startQuery);
        }
        catch (StringIndexOutOfBoundsException ex) {
            if (this.writerLog != null) {
                this.writerLog.append("Invalid sequence range found:\n");
                this.writerLog.append("\t" + annotationCurrent.sequenceName);
                this.writerLog.append("\tCSV coords: " + String.valueOf(annotationCurrent.startQuery) + FRAME_MINUS + String.valueOf(annotationCurrent.endQuery));
                this.writerLog.append("\tSequence length: " + String.valueOf(seqCurrent.length()));
            }
            ex.printStackTrace();
            return null;
        }
        String prev = seqPrevious.substring(0, annotationPrevious.endQuery);
        String next = seqCurrent.substring(annotationCurrent.startQuery);
        String prevOverlapping = seqPrevious.substring(annotationPrevious.endQuery);
        String nextOverlapping = seqCurrent.substring(0, annotationCurrent.startQuery);
        if (this.trimEnds > 0) {
            prevOverlapping = this.trimSeqRight(prevOverlapping, this.trimEnds);
            nextOverlapping = this.trimSeqLeft(nextOverlapping, this.trimEnds);
        }
        if ((identityRatio = this.calcIdentityRatio(prevWithPad = this.padSeqRight(prevOverlapping, maxOverlappingLen = this.getMaxLen(prevOverlapping, nextOverlapping)), nextWithPad = this.padSeqLeft(nextOverlapping, maxOverlappingLen))) >= this.identityThreshold) {
            String consensus = this.getConsensusSequence(prevWithPad, nextWithPad);
            return prev + consensus + next;
        }
        return null;
    }

    private String joinSequencesNonOverlapping(String fastaSequencePrevious, String fastaSequenceCurrent, int distance) throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append(fastaSequencePrevious);
        builder.append(this.fillWithNs(distance));
        builder.append(fastaSequenceCurrent);
        return builder.toString();
    }

    private String fillWithNs(int length) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < length) {
            builder.append("N");
            ++i;
        }
        return builder.toString();
    }

    private FASTAFileRecord getMatchingFastaRecord(String sequenceName) {
        int res = Collections.binarySearch(this.listAllRecords, sequenceName, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return ((FASTAFileRecord)o1).getDescriptionSB().toString().compareTo((String)o2);
            }
        });
        if (res >= 0) {
            FASTAFileRecord record = this.listAllRecords.get(res);
            return record;
        }
        return null;
    }

    private String parseFrame(String frameText) {
        String frame = FRAME_PLUS;
        if (frameText.contains(FRAME_MINUS)) {
            frame = FRAME_MINUS;
        }
        return frame;
    }

    private int getMaxLen(String seq1, String seq2) {
        int maxLen = seq1.trim().length();
        int len2 = seq2.trim().length();
        if (len2 > maxLen) {
            maxLen = len2;
        }
        return maxLen;
    }

    private String trimSeqRight(String seq, int trimCharCount) {
        return seq.trim().substring(0, seq.trim().length() - trimCharCount);
    }

    private String trimSeqLeft(String seq, int trimCharCount) {
        return seq.trim().substring(trimCharCount);
    }

    private String padSeqLeft(String seq, int padLen) {
        return String.format("%" + padLen + "s", seq).replace(' ', '*');
    }

    private String padSeqRight(String seq, int padLen) {
        return String.format("%-" + padLen + "s", seq).replace(' ', '*');
    }

    private float calcIdentityRatio(String seq1, String seq2) {
        if (seq1.length() != seq2.length()) {
            return -1.0f;
        }
        int seqLen = seq1.length();
        int countIdentities = 0;
        int i = 0;
        while (i < seqLen) {
            if (seq1.charAt(i) == seq2.charAt(i) || seq1.charAt(i) == 'N' || seq2.charAt(i) == 'N') {
                ++countIdentities;
            }
            ++i;
        }
        return (float)countIdentities / (float)seqLen;
    }

    private String getConsensusSequence(String seq1, String seq2) {
        if (seq1.length() != seq2.length()) {
            return null;
        }
        int seqLen = seq1.length();
        StringBuilder builder = new StringBuilder(seqLen);
        int i = 0;
        while (i < seqLen) {
            char char1 = seq1.charAt(i);
            char char2 = seq2.charAt(i);
            if (char1 == 'N') {
                builder.append(char2);
            } else if (char2 == 'N') {
                builder.append(char1);
            } else if (char1 == char2) {
                builder.append(char1);
            } else {
                builder.append('N');
            }
            ++i;
        }
        return builder.toString();
    }

    private String reverse(String seq) {
        StringBuilder builder = new StringBuilder(seq);
        return builder.reverse().toString();
    }

    private String complement(String seq) {
        int seqLen = seq.length();
        StringBuilder builder = new StringBuilder(seqLen);
        int i = 0;
        while (i < seqLen) {
            char c = seq.charAt(i);
            switch (c) {
                case 'A': {
                    builder.append('G');
                    break;
                }
                case 'a': {
                    builder.append('g');
                    break;
                }
                case 'G': {
                    builder.append('A');
                    break;
                }
                case 'g': {
                    builder.append('a');
                    break;
                }
                case 'C': {
                    builder.append('T');
                    break;
                }
                case 'c': {
                    builder.append('t');
                    break;
                }
                case 'T': {
                    builder.append('C');
                    break;
                }
                case 't': {
                    builder.append('c');
                    break;
                }
                default: {
                    builder.append(c);
                }
            }
            ++i;
        }
        return builder.toString();
    }

    private boolean isReverseFrame(String frameValue) {
        return frameValue.contains(FRAME_MINUS);
    }

    private class CsvAnnotation {
        public String sequenceName;
        public String annotation;
        public int startQuery;
        public int endQuery;
        public int startHit;
        public int endHit;
        public int lenQuery;
        public int lenHit;
        public String frameQuery;

        private CsvAnnotation() {
        }
    }
}

