/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.jobs.csvEditor;

import com.biotechvana.csveditor.editors.CSVEditor;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class CsvJoinColumnsRunnable
implements IRunnableWithProgress {
    private CSVEditor csvEditor;
    private int[] columnIndices;
    private char separator;
    private String joinColumnName;
    private long timestamp;
    private DecimalFormat decimalFormat = new DecimalFormat("###,###");
    private int stepSize = 1;

    public CsvJoinColumnsRunnable(CSVEditor csvEditor, int[] columnIndices, char separator, String joinColumnName, long timestamp) {
        this.csvEditor = csvEditor;
        this.columnIndices = columnIndices;
        this.separator = separator;
        this.joinColumnName = joinColumnName;
        this.timestamp = timestamp;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        long timeStart = System.currentTimeMillis();
        try {
            this.joinColumns(monitor);
        }
        catch (Exception ex) {
            throw new InvocationTargetException(ex);
        }
        long timeEnd = System.currentTimeMillis();
        if (this.csvEditor.getDebug()) {
            System.out.println("Joined " + this.columnIndices.length + " columns in " + this.decimalFormat.format(timeEnd - timeStart) + "ms");
        }
    }

    public void joinColumns(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
        try {
            List model = (List)this.csvEditor.getModel();
            int firstColumn = this.columnIndices[0];
            if (model.size() > 100) {
                this.stepSize = model.size() / 100;
            }
            monitor.beginTask("Join columns", model.size());
            int i = 0;
            while (i < model.size()) {
                List row = (List)model.get(i);
                StringBuilder sbuilder = new StringBuilder();
                int[] nArray = this.columnIndices;
                int n = this.columnIndices.length;
                int n2 = 0;
                while (n2 < n) {
                    int ci = nArray[n2];
                    if (((String)row.get(ci)).length() > 0) {
                        sbuilder.append((String)row.get(ci));
                        sbuilder.append(this.separator);
                    }
                    ++n2;
                }
                if (sbuilder.length() > 0 && sbuilder.charAt(sbuilder.length() - 1) == this.separator) {
                    sbuilder.deleteCharAt(sbuilder.length() - 1);
                }
                row.set(firstColumn, sbuilder.toString());
                final List frow = row;
                this.csvEditor.getSite().getShell().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        CsvJoinColumnsRunnable.this.csvEditor.getTableViewer().update((Object)frow, null);
                    }
                });
                if (i % this.stepSize == 0) {
                    monitor.worked(this.stepSize);
                    monitor.subTask("Reading row " + this.decimalFormat.format(i) + " of " + this.decimalFormat.format(model.size()) + " total rows");
                }
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                ++i;
            }
            this.csvEditor.getSite().getShell().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    List<String> listCheckedNames = CsvJoinColumnsRunnable.this.csvEditor.getEditorUtils2().getColumnNamesAsList(true, true, true);
                    CsvJoinColumnsRunnable.this.csvEditor.renameColumn(listCheckedNames.get(0), CsvJoinColumnsRunnable.this.joinColumnName);
                    CsvJoinColumnsRunnable.this.csvEditor.deleteColumn(listCheckedNames.subList(1, listCheckedNames.size()), true);
                    CsvJoinColumnsRunnable.this.csvEditor.getTableViewer().refresh();
                    CsvJoinColumnsRunnable.this.csvEditor.setModified(true);
                }
            });
        }
        finally {
            monitor.done();
        }
    }
}

