/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.jobs.csvEditor;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class CsvGetCheckedRowsIndicesRunnable
implements IRunnableWithProgress {
    private List<Integer> listIndices;
    private List<List<String>> model;
    private int stepSize = 100;

    public CsvGetCheckedRowsIndicesRunnable(List<List<String>> model) {
        this.model = model;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.getCheckedIndices(monitor);
    }

    private void getCheckedIndices(IProgressMonitor monitor) throws InterruptedException {
        try {
            int modelSize = this.model.size();
            this.listIndices = new ArrayList<Integer>();
            monitor.beginTask("Get checked indices", modelSize);
            int countRows = 0;
            for (List<String> row : this.model) {
                if (row.get(0).equals("1")) {
                    this.listIndices.add(countRows);
                }
                if (++countRows % this.stepSize == 0) {
                    monitor.worked(this.stepSize);
                }
                if (!monitor.isCanceled()) continue;
                throw new InterruptedException();
            }
        }
        finally {
            monitor.done();
        }
    }

    public List<Integer> getListIndices() {
        return this.listIndices;
    }
}

