/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.jobs.csvEditor;

import com.biotechvana.csveditor.editors.CSVEditor;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class CsvFillColumnRunnable
implements IRunnableWithProgress {
    private CSVEditor csvEditor;
    private int columnIndex;
    private String fillValue;
    private int startRowIndex;
    private int endRowIndex;
    private List<List<String>> model;
    private List<String> row;
    private DecimalFormat decimalFormat = new DecimalFormat("###,###");
    private int stepSize = 1;

    public CsvFillColumnRunnable(CSVEditor csvEditor, int columnIndex, String fillValue, int startRowIndex, int endRowIndex) {
        this.csvEditor = csvEditor;
        this.columnIndex = columnIndex;
        this.fillValue = fillValue;
        this.startRowIndex = startRowIndex;
        this.endRowIndex = endRowIndex;
        this.model = (List)csvEditor.getModel();
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        long timeStart = System.currentTimeMillis();
        this.fillColumn(monitor);
        long timeEnd = System.currentTimeMillis();
        if (this.csvEditor.getDebug()) {
            System.out.println("Filled column for " + this.decimalFormat.format(this.endRowIndex - this.startRowIndex) + " rows in " + this.decimalFormat.format(timeEnd - timeStart) + "ms");
        }
    }

    public void fillColumn(IProgressMonitor monitor) throws InterruptedException {
        try {
            boolean columnExists = true;
            int counter = 1;
            if (this.columnIndex >= this.csvEditor.getTable().getColumnCount()) {
                columnExists = false;
            }
            if (this.endRowIndex - this.startRowIndex > 100) {
                this.stepSize = (this.endRowIndex - this.startRowIndex) / 100;
            }
            monitor.beginTask("Fill column", this.endRowIndex - this.startRowIndex);
            monitor.subTask("Filling columns");
            int i = this.startRowIndex;
            while (i < this.endRowIndex) {
                monitor.subTask("Updating row " + this.decimalFormat.format(counter++));
                this.row = this.model.get(i);
                if (columnExists) {
                    try {
                        this.row.set(this.columnIndex, this.fillValue);
                    }
                    catch (Exception ex) {
                        this.row.add(this.fillValue);
                    }
                } else {
                    this.row.add(this.fillValue);
                }
                this.csvEditor.getSite().getShell().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        CsvFillColumnRunnable.this.csvEditor.getTableViewer().update(CsvFillColumnRunnable.this.row, null);
                    }
                });
                if (i % this.stepSize == 0) {
                    monitor.worked(this.stepSize);
                    monitor.subTask("Parsing row " + this.decimalFormat.format(i) + " of " + this.decimalFormat.format(this.endRowIndex - this.startRowIndex));
                }
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }
}

