/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.jobs.csvEditor;

import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.model.CsvEditor.ClusterUtils;
import com.biotechvana.csveditor.model.CsvEditor.CsvCluster;
import com.biotechvana.javabiotoolkit.io.FASTAFileRecord;
import com.biotechvana.javabiotoolkit.io.FASTAReader;
import com.biotechvana.utils.StringUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class CsvExportClusterRunnable
implements IRunnableWithProgress {
    private final char CLUSTER_SEPARATOR = (char)59;
    private int clusterKeyColumnIndex;
    private CSVEditor csvEditor;
    private List<List<String>> model;
    private List<Integer> listCheckedRowIndices;
    private List<Integer> exportColumnIndices;
    private List<String> exportColumnNames;
    private List<CsvCluster> listClusters;
    private File outputFolder;
    private boolean exportCsv = false;
    private boolean exportFasta = false;
    private String separator = ";";
    private String delimiter = "\"";
    private double range = 0.0;

    public CsvExportClusterRunnable(CSVEditor csvEditor, int clusterKeyColumnIndex, List<Integer> exportColumnIndices, List<String> exportColumnNames, List<Integer> listCheckedRowIndices, File outputFolder, boolean exportCsv, boolean exportFasta) {
        this.csvEditor = csvEditor;
        this.clusterKeyColumnIndex = clusterKeyColumnIndex;
        this.exportColumnIndices = exportColumnIndices;
        this.exportColumnNames = exportColumnNames;
        this.listCheckedRowIndices = listCheckedRowIndices;
        this.outputFolder = outputFolder;
        this.exportCsv = exportCsv;
        this.exportFasta = exportFasta;
        this.model = (List)csvEditor.getModel();
    }

    public void setRange(double range) {
        this.range = range;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.listClusters = this.range > 0.0 ? ClusterUtils.getClusterListWithRange(this.model, this.listCheckedRowIndices, this.clusterKeyColumnIndex, this.range, monitor) : ClusterUtils.getClusterList(this.model, this.listCheckedRowIndices, this.clusterKeyColumnIndex, monitor);
        if (this.exportCsv) {
            try {
                this.exportCsv(monitor);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.exportFasta) {
            try {
                this.exportFasta(monitor);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void exportCsv(IProgressMonitor monitor) throws IOException, InterruptedException {
        try {
            File outputClusterFile;
            int divisor = 1;
            if (this.listClusters.size() > 100) {
                divisor = 100;
            }
            if (this.listClusters.size() > 10000) {
                divisor = 1000;
            }
            monitor.beginTask("Exporting clusters to CSV", this.listClusters.size() / divisor);
            int counterSteps = 0;
            if (!this.outputFolder.exists()) {
                this.outputFolder.mkdir();
            }
            if (!(outputClusterFile = new File(this.outputFolder.getAbsolutePath() + File.separator + "clusters.csv")).exists()) {
                outputClusterFile.createNewFile();
            }
            try (BufferedWriter bw = new BufferedWriter(new FileWriter(outputClusterFile));){
                bw.append(this.delimiter + "Cluster ID" + this.delimiter + this.separator);
                bw.append(this.delimiter + "Item count" + this.delimiter + this.separator);
                for (String s : this.exportColumnNames) {
                    bw.append(this.delimiter);
                    bw.append(s);
                    bw.append(this.delimiter);
                    bw.append(this.separator);
                }
                bw.newLine();
                for (CsvCluster cluster : this.listClusters) {
                    int[] rowIndices = cluster.getIndices();
                    bw.append(this.delimiter + cluster.getName() + this.delimiter + this.separator);
                    bw.append(this.delimiter + rowIndices.length + this.delimiter + this.separator);
                    for (int c : this.exportColumnIndices) {
                        bw.append(this.delimiter);
                        int i = 0;
                        while (i < rowIndices.length - 1) {
                            String t = this.model.get(rowIndices[i]).get(c);
                            if (t.length() > 0) {
                                bw.append(t + ";");
                            }
                            ++i;
                        }
                        bw.append(this.model.get(rowIndices[rowIndices.length - 1]).get(c));
                        bw.append(this.delimiter);
                        bw.append(this.separator);
                    }
                    bw.newLine();
                    if (++counterSteps % divisor == 0) {
                        monitor.worked(1);
                    }
                    if (!monitor.isCanceled()) continue;
                    throw new InterruptedException();
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    public void exportFasta(IProgressMonitor monitor) throws Exception {
        try {
            int divisor = 1;
            if (this.listClusters.size() > 100) {
                divisor = 100;
            }
            if (this.listClusters.size() > 10000) {
                divisor = 1000;
            }
            File associatedFastaFile = this.csvEditor.getAssociationFile();
            monitor.beginTask("Export clusers as FASTA", this.listClusters.size() / divisor);
            int counterSteps = 0;
            FASTAReader fastaParser = null;
            List listFastaRecords = null;
            fastaParser = new FASTAReader(associatedFastaFile);
            fastaParser.parse();
            listFastaRecords = fastaParser.getFastaRecords();
            Collections.sort(listFastaRecords, new Comparator<FASTAFileRecord>(){

                @Override
                public int compare(FASTAFileRecord o1, FASTAFileRecord o2) {
                    return o1.getDescriptionSB().toString().compareTo(o2.getDescriptionSB().toString());
                }
            });
            for (CsvCluster cluster : this.listClusters) {
                this.exportFastaCluster(cluster, associatedFastaFile, listFastaRecords);
                if (++counterSteps % divisor == 0) {
                    monitor.worked(1);
                }
                if (!monitor.isCanceled()) continue;
                throw new InterruptedException();
            }
        }
        finally {
            monitor.done();
        }
    }

    public void exportFastaCluster(CsvCluster cluster, File fastaFile, List<FASTAFileRecord> listRecords) throws IOException {
        File outputFile = new File(this.outputFolder.getAbsolutePath() + File.separator + this.sanitizeFileName(cluster.getName()) + ".fasta");
        BufferedWriter writerFasta = new BufferedWriter(new FileWriter(outputFile));
        RandomAccessFile raf = new RandomAccessFile(fastaFile, "r");
        int[] associationIndices = this.csvEditor.getAssociationColumnIndices();
        String associationSeparator = this.csvEditor.getAssociationSeparator();
        try {
            int[] nArray = cluster.getIndices();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int c = nArray[n2];
                List<String> row = this.model.get(c);
                ArrayList<String> sequenceName = new ArrayList<String>();
                int[] nArray2 = associationIndices;
                int n3 = associationIndices.length;
                int n4 = 0;
                while (n4 < n3) {
                    int ai = nArray2[n4];
                    sequenceName.add(row.get(ai + 2));
                    ++n4;
                }
                String fullSequenceName = StringUtils.join(sequenceName, (String)associationSeparator);
                int res = Collections.binarySearch(listRecords, fullSequenceName, new Comparator<Object>(){

                    @Override
                    public int compare(Object o1, Object o2) {
                        return ((FASTAFileRecord)o1).getDescriptionSB().toString().compareTo(o2.toString());
                    }
                });
                if (res >= 0) {
                    FASTAFileRecord record = listRecords.get(res);
                    raf.seek(record.sequenceOffset());
                    byte[] buffer = new byte[(int)record.sequenceBytes()];
                    int bytesRead = raf.read(buffer);
                    if (bytesRead >= 0) {
                        writerFasta.write(">" + record.getDescriptionSB().toString() + "\n");
                        writerFasta.write(new String(buffer));
                    }
                }
                ++n2;
            }
        }
        finally {
            writerFasta.close();
            raf.close();
        }
    }

    private String sanitizeFileName(String clusterName) {
        clusterName = clusterName.replace(",", "_");
        clusterName = clusterName.replace(".", "_");
        return clusterName;
    }
}

