/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.jobs.csvEditor;

import com.biotechvana.csveditor.model.CsvEditor.ClusterUtils;
import com.biotechvana.csveditor.model.CsvEditor.CsvCluster;
import com.biotechvana.javabiotoolkit.exceptions.FastaReaderNotParsedException;
import com.biotechvana.javabiotoolkit.exceptions.InvalidSequenceCharacterException;
import com.biotechvana.javabiotoolkit.exceptions.SequenceTooLongException;
import com.biotechvana.javabiotoolkit.io.FASTAFileRecord;
import com.biotechvana.javabiotoolkit.io.FASTAReader;
import com.biotechvana.utils.StringUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class CsvExportCategoriesRunnable
implements IRunnableWithProgress {
    private final String TITLE = "Export categories & clusters";
    private int categoryColumnIndex;
    private List<List<String>> model;
    private List<Integer> rowIndices;
    private List<String> columnNames;
    private List<Integer> columnIndices;
    private File outputFolder;
    private File associationFastaFile;
    private int[] associationIndices;
    private String associationSeparator;
    private String separator = ";";
    private String delimiter = "\"";
    private List<String> listFilesSuccess = new ArrayList<String>();
    private List<String> listFilesFail = new ArrayList<String>();
    private double range = 0.0;
    private List<CsvCluster> listClusters;

    public CsvExportCategoriesRunnable(List<List<String>> model, List<Integer> rowIndices, int categoryColumnIndex, List<String> columnNames, List<Integer> columnIndices, File outputFolder, File associatedFastaFile, int[] associationIndices, String associationSeparator) {
        this.model = model;
        this.rowIndices = rowIndices;
        this.categoryColumnIndex = categoryColumnIndex;
        this.columnNames = columnNames;
        this.columnIndices = columnIndices;
        this.outputFolder = outputFolder;
        this.associationFastaFile = associatedFastaFile;
        this.associationIndices = associationIndices;
        this.associationSeparator = associationSeparator;
    }

    public CsvExportCategoriesRunnable(List<List<String>> model, List<Integer> rowIndices, int categoryColumnIndex, List<String> columnNames, List<Integer> columnIndices, File outputFolder) {
        this(model, rowIndices, categoryColumnIndex, columnNames, columnIndices, outputFolder, null, null, null);
    }

    public void setRange(double range) {
        this.range = range;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.listClusters = this.range > 0.0 ? ClusterUtils.getClusterListWithRange(this.model, this.rowIndices, this.categoryColumnIndex, this.range, monitor) : ClusterUtils.getClusterList(this.model, this.rowIndices, this.categoryColumnIndex, monitor);
        if (this.associationFastaFile != null) {
            try {
                this.exportWithFasta(monitor);
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }
        try {
            this.exportWithoutFasta(monitor);
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
        this.exportLogFile();
    }

    public int exportWithFasta(IProgressMonitor monitor) throws InterruptedException, InvalidSequenceCharacterException, SequenceTooLongException, FastaReaderNotParsedException, FileNotFoundException, IOException {
        try {
            int divisor = 1;
            if (this.listClusters.size() > 100) {
                divisor = 100;
            }
            if (this.listClusters.size() > 10000) {
                divisor = 1000;
            }
            monitor.beginTask("Export categories & clusters", this.listClusters.size() / divisor);
            int counterFiles = 0;
            int counterSteps = 0;
            FASTAReader fastaParser = null;
            List listRecords = null;
            fastaParser = new FASTAReader(this.associationFastaFile);
            fastaParser.parse();
            listRecords = fastaParser.getFastaRecords();
            Collections.sort(listRecords, new Comparator<FASTAFileRecord>(){

                @Override
                public int compare(FASTAFileRecord o1, FASTAFileRecord o2) {
                    return o1.getDescriptionSB().toString().compareTo(o2.getDescriptionSB().toString());
                }
            });
            String header = this.buildHeader();
            for (CsvCluster cluster : this.listClusters) {
                try {
                    this.exportCsvCluster(cluster, header);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.exportFastaCluster(cluster, this.associationFastaFile, listRecords);
                if (++counterSteps % divisor == 0) {
                    monitor.worked(1);
                }
                if (!monitor.isCanceled()) continue;
                throw new InterruptedException();
            }
            int n = counterFiles;
            return n;
        }
        finally {
            monitor.done();
        }
    }

    public String buildHeader() {
        ArrayList<String> listHeader = new ArrayList<String>();
        for (String cn : this.columnNames) {
            listHeader.add(cn);
        }
        return StringUtils.join(listHeader, (String)this.separator, (String)this.delimiter, (boolean)true);
    }

    public void exportCsvCluster(CsvCluster cluster, String header) throws IOException {
        File fileToOpen = new File(this.outputFolder.getAbsolutePath() + File.separator + this.sanitizeFileName(cluster.getName()) + ".csv");
        try (BufferedWriter writerWorksheet = new BufferedWriter(new FileWriter(fileToOpen));){
            writerWorksheet.append(header + "\n");
            int[] nArray = cluster.getIndices();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                List<String> row = this.model.get(i);
                ArrayList<String> listOutput = new ArrayList<String>();
                listOutput.add(row.get(this.categoryColumnIndex));
                for (int c : this.columnIndices) {
                    listOutput.add(row.get(c));
                }
                writerWorksheet.append(StringUtils.join(listOutput, (String)this.separator, (String)this.delimiter, (boolean)true));
                writerWorksheet.append("\n");
                ++n2;
            }
        }
    }

    public void exportFastaCluster(CsvCluster cluster, File fastaFile, List<FASTAFileRecord> listRecords) throws IOException {
        File outputFile = new File(this.outputFolder.getAbsolutePath() + File.separator + this.sanitizeFileName(cluster.getName()) + ".fasta");
        BufferedWriter writerFasta = new BufferedWriter(new FileWriter(outputFile));
        RandomAccessFile raf = new RandomAccessFile(fastaFile, "r");
        try {
            int[] nArray = cluster.getIndices();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int c = nArray[n2];
                List<String> row = this.model.get(c);
                ArrayList<String> sequenceName = new ArrayList<String>();
                int[] nArray2 = this.associationIndices;
                int n3 = this.associationIndices.length;
                int n4 = 0;
                while (n4 < n3) {
                    int ai = nArray2[n4];
                    sequenceName.add(row.get(ai + 2));
                    ++n4;
                }
                String fullSequenceName = StringUtils.join(sequenceName, (String)this.associationSeparator);
                int res = Collections.binarySearch(listRecords, fullSequenceName, new Comparator<Object>(){

                    @Override
                    public int compare(Object o1, Object o2) {
                        return ((FASTAFileRecord)o1).getDescriptionSB().toString().compareTo(o2.toString());
                    }
                });
                if (res >= 0) {
                    FASTAFileRecord record = listRecords.get(res);
                    raf.seek(record.sequenceOffset());
                    byte[] buffer = new byte[(int)record.sequenceBytes()];
                    int bytesRead = raf.read(buffer);
                    if (bytesRead >= 0) {
                        writerFasta.write(">" + record.getDescriptionSB().toString() + "\n");
                        writerFasta.write(new String(buffer));
                    }
                }
                ++n2;
            }
        }
        finally {
            writerFasta.close();
            raf.close();
        }
    }

    public int exportWithoutFasta(IProgressMonitor monitor) throws InterruptedException {
        try {
            int divisor = 1;
            if (this.listClusters.size() > 100) {
                divisor = 100;
            }
            if (this.listClusters.size() > 10000) {
                divisor = 1000;
            }
            monitor.beginTask("Export categories & clusters", this.listClusters.size() / divisor);
            int counterFiles = 0;
            int counterSteps = 0;
            String header = this.buildHeader();
            for (CsvCluster cluster : this.listClusters) {
                try {
                    this.exportCsvCluster(cluster, header);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (++counterSteps % divisor == 0) {
                    monitor.worked(1);
                }
                if (!monitor.isCanceled()) continue;
                throw new InterruptedException();
            }
            int n = counterFiles;
            return n;
        }
        finally {
            monitor.done();
        }
    }

    private String sanitizeFileName(String clusterName) {
        clusterName = clusterName.replace(",", "_");
        clusterName = clusterName.replace(".", "_");
        return clusterName;
    }

    private void exportLogFile() {
        try (BufferedWriter writerLog = new BufferedWriter(new FileWriter(new File(this.outputFolder, "log.txt")));){
            writerLog.append("Files exported: " + new DecimalFormat("###,###").format(this.listFilesSuccess.size()));
            writerLog.newLine();
            writerLog.append("Files failed: " + new DecimalFormat("###,###").format(this.listFilesFail.size()));
            writerLog.newLine();
            writerLog.newLine();
            if (this.listFilesFail.size() > 0) {
                writerLog.append("List of failed keys:");
                writerLog.newLine();
                for (String ff : this.listFilesFail) {
                    writerLog.append("\t" + ff);
                    writerLog.newLine();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

