/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.jobs.csvEditor;

import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.model.CsvEditor.actions.CsvAction;
import com.biotechvana.csveditor.model.CsvEditor.actions.CsvActionRowDelete;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class CsvDeleteRowsRunnable
implements IRunnableWithProgress {
    private CSVEditor csvEditor;
    private List<Integer> listSelectedRows;
    private long timestamp;

    public CsvDeleteRowsRunnable(CSVEditor csvEditor, List<Integer> listSelectedRows, long timestamp) {
        this.csvEditor = csvEditor;
        this.listSelectedRows = listSelectedRows;
        this.timestamp = timestamp;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            int i2;
            List model = (List)this.csvEditor.getModel();
            Shell shell = this.csvEditor.getSite().getShell();
            List<CsvAction> listActions = this.csvEditor.getListActions();
            monitor.beginTask("Delete rows", this.listSelectedRows.size());
            if (this.listSelectedRows.size() == 0) {
                return;
            }
            for (int i2 : this.listSelectedRows) {
                int index = Integer.parseInt((String)((List)model.get(i2)).get(1)) - 1;
                listActions.add(new CsvActionRowDelete(index, (List)model.get(i2), this.timestamp));
            }
            Collections.sort(this.listSelectedRows);
            i2 = this.listSelectedRows.size() - 1;
            while (i2 >= 0) {
                List delRow = (List)model.remove(this.listSelectedRows.get(i2));
                if (delRow == null) {
                    System.out.println("Error borrando fila: " + String.valueOf(this.listSelectedRows.get(i2)));
                }
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                --i2;
            }
            shell.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    CsvDeleteRowsRunnable.this.csvEditor.getTableViewer().refresh();
                    CsvDeleteRowsRunnable.this.csvEditor.setModified(true);
                }
            });
        }
        finally {
            monitor.done();
        }
    }
}

