/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.jobs.csvEditor;

import com.biotechvana.csvUtils.CsvBufferedReader;
import com.biotechvana.csvUtils.CsvWriter;
import com.biotechvana.csveditor.csvEditor.dialogs.CsvCurationAdvancedFilter;
import com.biotechvana.utils.FilenameUtils;
import com.biotechvana.utils.StringUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class CsvCurationRunnable
implements IRunnableWithProgress {
    private File fileCsv;
    private File folderOutput;
    private int columnSeqnameIndex;
    private int columnAnnotationIndex;
    private int columnQueryFromIndex;
    private int columnQueryToIndex;
    private int columnSizeIndex;
    private int columnFrameIndex = -1;
    private int maxDistanceNonOverlapping = -1;
    private List<CsvCurationAdvancedFilter> listAdvancedFilters;
    private int filterMaxLen;
    private CsvCurationAdvancedFilter lastMatchingFilter;
    private static final String FRAME_PLUS = "+";
    private static final String FRAME_MINUS = "-";

    public static void main(String[] args) {
        String[] lines = new String[]{"term1", "term1", "term1", "term1", "term2", "term3", "term3"};
        String[] terms = new String[]{"term1", "term2", "term3"};
        ArrayList<Integer> listMatchingIndices = new ArrayList<Integer>();
        ArrayList<Integer> listMatchingTermIndices = new ArrayList<Integer>();
        int i = 0;
        while (i < lines.length) {
            int currentTermIndex = 0;
            if (lines[i].equals(terms[currentTermIndex])) {
                boolean termMatches = true;
                int j = i;
                while (j < lines.length && termMatches) {
                    termMatches = false;
                    if (!listMatchingIndices.contains(j)) {
                        listMatchingIndices.add(j);
                    }
                    if (lines[j].equals(terms[currentTermIndex])) {
                        termMatches = true;
                    } else if (currentTermIndex < terms.length - 1 && lines[j].equals(terms[currentTermIndex + 1])) {
                        termMatches = true;
                        ++currentTermIndex;
                    }
                    if (termMatches && !listMatchingTermIndices.contains(currentTermIndex)) {
                        listMatchingTermIndices.add(currentTermIndex);
                    }
                    ++j;
                }
            }
            if (currentTermIndex == terms.length) {
                System.out.println("Todos los terminos han sido encontrados");
            }
            ++i;
        }
        System.out.println("Term Indices\n");
        i = 0;
        while (i < listMatchingTermIndices.size()) {
            System.out.println("terms: " + String.valueOf(listMatchingTermIndices.get(i)));
            ++i;
        }
    }

    public CsvCurationRunnable(File fileCsv, File folderOutput, int columnSeqnameIndex, int columnAnnotationIndex, int columnQueryFromIndex, int columnQueryToIndex, int columnSizeIndex, int columnFrameIndex, int maxDistanceNonOverlapping) {
        this.fileCsv = fileCsv;
        this.folderOutput = folderOutput;
        this.columnSeqnameIndex = columnSeqnameIndex;
        this.columnAnnotationIndex = columnAnnotationIndex;
        this.columnQueryFromIndex = columnQueryFromIndex;
        this.columnQueryToIndex = columnQueryToIndex;
        this.columnSizeIndex = columnSizeIndex;
        this.columnFrameIndex = columnFrameIndex;
        this.maxDistanceNonOverlapping = maxDistanceNonOverlapping;
    }

    public CsvCurationRunnable(File fileCsv, File folderOutput, int columnSeqnameIndex, int columnAnnotationIndex, int columnQueryFromIndex, int columnQueryToIndex, int columnSizeIndex) {
        this(fileCsv, folderOutput, columnSeqnameIndex, columnAnnotationIndex, columnQueryFromIndex, columnQueryToIndex, columnSizeIndex, -1, -1);
    }

    public void setFiltering(List<CsvCurationAdvancedFilter> listAdvancedFilters, int filterMaxLen) {
        this.listAdvancedFilters = listAdvancedFilters;
        this.filterMaxLen = filterMaxLen;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        if (this.listAdvancedFilters != null && this.listAdvancedFilters.size() > 0) {
            try {
                this.modeFilter(monitor);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                this.modeNormal(monitor);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void modeNormal(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException, IOException {
        block38: {
            int lineCount = 0;
            CsvBufferedReader csvReader = new CsvBufferedReader(this.fileCsv, ';', '\"');
            String basename = FilenameUtils.getBasename((String)this.fileCsv.getName());
            CsvWriter csvWriter = new CsvWriter(new File(String.valueOf(this.folderOutput) + "/" + basename + "_curated.csv"), ';', '\"');
            BufferedWriter logWriter = new BufferedWriter(new FileWriter(new File(String.valueOf(this.folderOutput) + "/" + basename + "_log.txt")));
            try {
                lineCount = CsvBufferedReader.getLineCount((File)this.fileCsv);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new InvocationTargetException(e, "Cannot read input csv file");
            }
            int stepSize = 1;
            if (lineCount > 100) {
                stepSize = lineCount / 100;
            }
            int stepCounter = 0;
            monitor.beginTask("Read CSV", 100);
            try {
                try {
                    List<List<String>> rowGroupOverlapping = new ArrayList<List<String>>();
                    List row = csvReader.readLine();
                    csvWriter.write(row);
                    int lastStart = 0;
                    int lastEnd = 0;
                    row = csvReader.readLine();
                    rowGroupOverlapping.add(row);
                    int start = 0;
                    int end = 0;
                    try {
                        start = Integer.parseInt((String)row.get(this.columnQueryFromIndex));
                        end = Integer.parseInt((String)row.get(this.columnQueryToIndex));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    lastStart = start;
                    lastEnd = end;
                    while ((row = csvReader.readLine()) != null) {
                        String name = (String)row.get(this.columnSeqnameIndex);
                        try {
                            start = Integer.parseInt((String)row.get(this.columnQueryFromIndex));
                            end = Integer.parseInt((String)row.get(this.columnQueryToIndex));
                        }
                        catch (Exception ex) {
                            continue;
                        }
                        String frame = null;
                        if (this.columnFrameIndex != -1) {
                            frame = this.getFrame((String)row.get(this.columnFrameIndex));
                        }
                        List<String> lastRow = rowGroupOverlapping.get(rowGroupOverlapping.size() - 1);
                        String lastName = lastRow.get(this.columnSeqnameIndex);
                        String lastFrame = null;
                        if (this.columnFrameIndex != -1) {
                            lastFrame = this.getFrame(lastRow.get(this.columnFrameIndex));
                        }
                        int distance = this.getDistance(lastStart, lastEnd, start, end);
                        if (lastName != null && lastName.equals(name) && (this.columnFrameIndex == -1 || lastFrame != null && frame != null && frame.equals(lastFrame)) && (distance <= 0 || this.maxDistanceNonOverlapping != -1 && distance < this.maxDistanceNonOverlapping)) {
                            rowGroupOverlapping.add(row);
                        } else {
                            rowGroupOverlapping = this.modeFilterSub(rowGroupOverlapping, logWriter);
                            for (List<String> outputRow : rowGroupOverlapping) {
                                csvWriter.write(outputRow);
                            }
                            rowGroupOverlapping = new ArrayList();
                            rowGroupOverlapping.add(row);
                            lastStart = start;
                            lastEnd = end;
                        }
                        if (++stepCounter % stepSize == 0) {
                            monitor.worked(1);
                        }
                        if (!monitor.isCanceled()) continue;
                        throw new InterruptedException();
                    }
                    rowGroupOverlapping = this.modeFilterSub(rowGroupOverlapping, logWriter);
                    for (List<String> outputRow : rowGroupOverlapping) {
                        csvWriter.write(outputRow);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        csvReader.close();
                    }
                    catch (IOException e2) {
                        throw new InvocationTargetException(e2);
                    }
                    if (csvWriter != null) {
                        try {
                            csvWriter.close();
                        }
                        catch (IOException e3) {
                            e3.printStackTrace();
                        }
                    }
                    if (logWriter != null) {
                        logWriter.close();
                    }
                    break block38;
                }
            }
            catch (Throwable throwable) {
                try {
                    csvReader.close();
                }
                catch (IOException e) {
                    throw new InvocationTargetException(e);
                }
                if (csvWriter != null) {
                    try {
                        csvWriter.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (logWriter != null) {
                    logWriter.close();
                }
                throw throwable;
            }
            try {
                csvReader.close();
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
            if (csvWriter != null) {
                try {
                    csvWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (logWriter != null) {
                logWriter.close();
            }
        }
        monitor.done();
    }

    public void modeFilter(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException, IOException {
        block40: {
            int lineCount = 0;
            CsvBufferedReader csvReader = new CsvBufferedReader(this.fileCsv, ';', '\"');
            String basename = FilenameUtils.getBasename((String)this.fileCsv.getName());
            CsvWriter csvWriter = new CsvWriter(new File(String.valueOf(this.folderOutput) + "/" + basename + "_curated.csv"), ';', '\"');
            BufferedWriter logWriter = new BufferedWriter(new FileWriter(new File(String.valueOf(this.folderOutput) + "/" + basename + "_log.txt")));
            try {
                lineCount = CsvBufferedReader.getLineCount((File)this.fileCsv);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new InvocationTargetException(e, "Cannot read input csv file");
            }
            int stepSize = 1;
            if (lineCount > 100) {
                stepSize = lineCount / 100;
            }
            int stepCounter = 0;
            monitor.beginTask("Read CSV", 100);
            try {
                try {
                    List<List<String>> rowGroupOverlapping = new ArrayList<List<String>>();
                    List row = csvReader.readLine();
                    csvWriter.write(row);
                    while ((row = csvReader.readLine()) != null) {
                        String name = (String)row.get(this.columnSeqnameIndex);
                        int start = 0;
                        int end = 0;
                        try {
                            start = Integer.parseInt((String)row.get(this.columnQueryFromIndex));
                            end = Integer.parseInt((String)row.get(this.columnQueryToIndex));
                        }
                        catch (Exception ex) {
                            continue;
                        }
                        String frame = null;
                        if (this.columnFrameIndex != -1) {
                            frame = this.getFrame((String)row.get(this.columnFrameIndex));
                        }
                        if (rowGroupOverlapping.size() == 0) {
                            rowGroupOverlapping.add(row);
                        } else {
                            List<String> lastRow = rowGroupOverlapping.get(rowGroupOverlapping.size() - 1);
                            String lastName = lastRow.get(this.columnSeqnameIndex);
                            int lastStart = 0;
                            int lastEnd = 0;
                            try {
                                lastStart = Integer.parseInt(lastRow.get(this.columnQueryFromIndex));
                                lastEnd = Integer.parseInt(lastRow.get(this.columnQueryToIndex));
                            }
                            catch (Exception ex) {
                                continue;
                            }
                            String lastFrame = null;
                            if (this.columnFrameIndex != -1) {
                                lastFrame = this.getFrame(lastRow.get(this.columnFrameIndex));
                            }
                            int distance = this.getDistance(lastStart, lastEnd, start, end);
                            if (lastName != null && lastName.equals(name) && (this.columnFrameIndex == -1 || lastFrame != null && frame != null && frame.equals(lastFrame)) && (distance <= 0 || this.maxDistanceNonOverlapping != -1 && distance < this.maxDistanceNonOverlapping)) {
                                rowGroupOverlapping.add(row);
                            } else {
                                rowGroupOverlapping = this.modeFilterSub(rowGroupOverlapping, logWriter);
                                for (List<String> outputRow : rowGroupOverlapping) {
                                    csvWriter.write(outputRow);
                                }
                                rowGroupOverlapping = new ArrayList();
                                rowGroupOverlapping.add(row);
                            }
                        }
                        if (++stepCounter % stepSize == 0) {
                            monitor.worked(1);
                        }
                        if (!monitor.isCanceled()) continue;
                        throw new InterruptedException();
                    }
                    rowGroupOverlapping = this.modeFilterSub(rowGroupOverlapping, logWriter);
                    for (List<String> outputRow : rowGroupOverlapping) {
                        csvWriter.write(outputRow);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        csvReader.close();
                    }
                    catch (IOException e2) {
                        throw new InvocationTargetException(e2);
                    }
                    if (csvWriter != null) {
                        try {
                            csvWriter.close();
                        }
                        catch (IOException e3) {
                            e3.printStackTrace();
                        }
                    }
                    if (logWriter != null) {
                        logWriter.close();
                    }
                    break block40;
                }
            }
            catch (Throwable throwable) {
                try {
                    csvReader.close();
                }
                catch (IOException e) {
                    throw new InvocationTargetException(e);
                }
                if (csvWriter != null) {
                    try {
                        csvWriter.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (logWriter != null) {
                    logWriter.close();
                }
                throw throwable;
            }
            try {
                csvReader.close();
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
            if (csvWriter != null) {
                try {
                    csvWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (logWriter != null) {
                logWriter.close();
            }
        }
        monitor.done();
    }

    private List<List<String>> modeFilterSub(List<List<String>> rowGroupOverlapping, BufferedWriter writerLog) {
        if (this.listAdvancedFilters != null && this.listAdvancedFilters.size() > 0) {
            List<List<Integer>> listAllMatchingIndices = this.findMatchingIndicesByTerms(rowGroupOverlapping);
            boolean allIndicesAreMatching = this.allInidicesMatching(listAllMatchingIndices, this.listAdvancedFilters.size());
            while (allIndicesAreMatching && listAllMatchingIndices.get(0).size() > 1) {
                List<Integer> firstList = listAllMatchingIndices.get(0);
                List<List<String>> matchingRows = rowGroupOverlapping.subList(firstList.get(0), firstList.get(firstList.size() - 1) + 1);
                List<String> rowMerged = this.mergeMatchingByFilter(matchingRows);
                if (rowMerged != null && writerLog != null) {
                    try {
                        writerLog.append(this.rowGroupToString(matchingRows));
                        writerLog.append("\n");
                        writerLog.append("-->\n");
                        writerLog.append(this.rowToString(rowMerged));
                        writerLog.append("\n");
                        writerLog.append("------------------------------\n");
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                rowGroupOverlapping = this.removeRowsFromList(rowGroupOverlapping, listAllMatchingIndices.get(0));
                rowGroupOverlapping.add(rowMerged);
                if (rowGroupOverlapping != null && rowGroupOverlapping.size() > 0) {
                    rowGroupOverlapping.sort(new RowStartComparator(this.columnQueryFromIndex));
                }
                listAllMatchingIndices = this.findMatchingIndicesByTerms(rowGroupOverlapping);
                allIndicesAreMatching = this.allInidicesMatching(listAllMatchingIndices, this.listAdvancedFilters.size());
            }
        } else {
            try {
                rowGroupOverlapping = this.processOverlappingGroupByAnnotation(rowGroupOverlapping, writerLog);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return rowGroupOverlapping;
    }

    private boolean allInidicesMatching(List<List<Integer>> listAllMatchingIndices, int listAdvancedFilterSize) {
        if (listAllMatchingIndices.size() == 0) {
            return false;
        }
        HashMap<Integer, Integer> indicesCounter = new HashMap<Integer, Integer>();
        for (List<Integer> l : listAllMatchingIndices) {
            if (l.size() <= 0) continue;
            for (int i : l) {
                if (!indicesCounter.containsKey(i)) {
                    indicesCounter.put(i, 1);
                    continue;
                }
                indicesCounter.replace(i, (Integer)indicesCounter.get(i) + 1);
            }
        }
        if (indicesCounter.size() == 0) {
            return false;
        }
        for (Integer i : indicesCounter.keySet()) {
            if ((Integer)indicesCounter.get(i) == listAdvancedFilterSize) continue;
            return false;
        }
        return true;
    }

    private List<Integer> intersectMatchingIndices(List<List<Integer>> listAllMatchingIndices) {
        ArrayList<Integer> intersectingIndices = new ArrayList<Integer>();
        int numFilters = listAllMatchingIndices.size();
        HashMap<Integer, Integer> setIndices = new HashMap<Integer, Integer>();
        for (List<Integer> listMatches : listAllMatchingIndices) {
            for (int i : listMatches) {
                if (setIndices.containsKey(i)) {
                    setIndices.put(i, 0);
                }
                setIndices.replace(i, (Integer)setIndices.get(i) + 1);
            }
        }
        Iterator<List<Integer>> iterator = setIndices.keySet().iterator();
        while (iterator.hasNext()) {
            int i = (Integer)((Object)iterator.next());
            if ((Integer)setIndices.get(i) != numFilters) continue;
            intersectingIndices.add(i);
        }
        return intersectingIndices;
    }

    private List<List<String>> removeRowsFromList(List<List<String>> rowGroupOverlapping, List<Integer> indices) {
        ArrayList<List<String>> listNew = new ArrayList<List<String>>();
        int i = 0;
        while (i < rowGroupOverlapping.size()) {
            if (!indices.contains(i)) {
                listNew.add(rowGroupOverlapping.get(i));
            }
            ++i;
        }
        return listNew;
    }

    private void printRowGroup(List<List<String>> rowGroup) {
        for (List<String> row : rowGroup) {
            this.printRow(row);
        }
    }

    private void printRow(List<String> row) {
        System.out.println(StringUtils.join(row, (String)";"));
    }

    private String rowGroupToString(List<List<String>> rowGroup) {
        StringBuilder builder = new StringBuilder();
        for (List<String> row : rowGroup) {
            builder.append(this.rowToString(row) + "\n");
        }
        return builder.toString();
    }

    private String rowToString(List<String> row) {
        return StringUtils.join(row, (String)";");
    }

    private List<String> mergeMatchingByFilter(List<List<String>> onlyMatching) {
        ArrayList<String> listMerged = new ArrayList<String>();
        int minStart = -1;
        int maxEnd = -1;
        int i = 0;
        while (i < onlyMatching.get(0).size()) {
            for (List<String> row : onlyMatching) {
                int start = Integer.parseInt(row.get(this.columnQueryFromIndex));
                int end = Integer.parseInt(row.get(this.columnQueryToIndex));
                if (minStart == -1 || start < minStart) {
                    minStart = start;
                }
                if (maxEnd != -1 && end <= maxEnd) continue;
                maxEnd = end;
            }
            ++i;
        }
        int mergedLen = maxEnd - minStart + 1;
        int i2 = 0;
        while (i2 < onlyMatching.get(0).size()) {
            ArrayList<String> listValues = new ArrayList<String>();
            for (List<String> row : onlyMatching) {
                listValues.add(row.get(i2));
            }
            if (i2 == this.columnSeqnameIndex) {
                listMerged.add(i2, (String)listValues.get(0));
            } else if (i2 == this.columnAnnotationIndex) {
                listMerged.add(i2, (String)listValues.get(0));
            } else if (i2 == this.columnQueryFromIndex) {
                listMerged.add(i2, this.getLowestStart(listValues));
            } else if (i2 == this.columnQueryToIndex) {
                listMerged.add(i2, this.getHighestStart(listValues));
            } else if (i2 == this.columnSizeIndex) {
                listMerged.add(i2, String.valueOf(mergedLen));
            } else {
                listMerged.add(i2, this.mergeListOfValues(listValues));
            }
            ++i2;
        }
        if (this.lastMatchingFilter != null) {
            listMerged.set(this.lastMatchingFilter.column, this.lastMatchingFilter.rename);
        }
        return listMerged;
    }

    private String getLowestStart(List<String> listValues) {
        int lowestStart = -1;
        for (String s : listValues) {
            if (s.isEmpty()) continue;
            int v = Integer.parseInt(s);
            if (lowestStart != -1 && v >= lowestStart) continue;
            lowestStart = v;
        }
        return String.valueOf(lowestStart);
    }

    private String getHighestStart(List<String> listValues) {
        int highestEnd = -1;
        for (String s : listValues) {
            if (s.isEmpty()) continue;
            int v = Integer.parseInt(s);
            if (highestEnd != -1 && v <= highestEnd) continue;
            highestEnd = v;
        }
        return String.valueOf(highestEnd);
    }

    private String mergeListOfValues(List<String> values) {
        String first = values.get(0);
        boolean equal = true;
        for (String v : values) {
            if (first.equals(v)) continue;
            equal = false;
        }
        if (equal) {
            return first;
        }
        return StringUtils.join(values, (String)",");
    }

    private List<List<String>> processOverlappingGroupByAnnotation(List<List<String>> rowGroupOverlapping, BufferedWriter writerLog) throws IOException {
        ArrayList<List<String>> listNew = new ArrayList<List<String>>();
        if (rowGroupOverlapping.size() == 1) {
            return rowGroupOverlapping;
        }
        List<String> lastRow = null;
        String lastName = null;
        String lastAnnotation = null;
        int lastStart = Integer.parseInt(rowGroupOverlapping.get(0).get(this.columnQueryFromIndex));
        int lastEnd = Integer.parseInt(rowGroupOverlapping.get(0).get(this.columnQueryToIndex));
        String lastFrame = null;
        for (List<String> row : rowGroupOverlapping) {
            String name = row.get(this.columnSeqnameIndex);
            String annotation = "";
            if (this.columnAnnotationIndex != -1) {
                annotation = row.get(this.columnAnnotationIndex);
            }
            int start = Integer.parseInt(row.get(this.columnQueryFromIndex));
            int end = Integer.parseInt(row.get(this.columnQueryToIndex));
            String frame = null;
            if (this.columnFrameIndex != -1) {
                frame = this.getFrame(row.get(this.columnFrameIndex).trim());
            }
            int distance = this.getDistance(lastStart, lastEnd, start, end);
            if (lastRow != null) {
                if (lastName != null && lastName.equals(name) && lastAnnotation != null && annotation.equals(lastAnnotation) && (this.columnFrameIndex == -1 || lastFrame != null && frame != null && frame.equals(lastFrame))) {
                    if (distance <= 0 || this.maxDistanceNonOverlapping != -1 && distance < this.maxDistanceNonOverlapping) {
                        writerLog.append(this.rowToString(lastRow));
                        writerLog.append("\n");
                        writerLog.append(this.rowToString(row));
                        writerLog.append("\n");
                        writerLog.append("-->\n");
                        row = this.mergeRows(lastRow, row);
                        writerLog.append(this.rowToString(row));
                        writerLog.append("\n");
                        writerLog.append("------------------------------\n");
                    }
                } else {
                    listNew.add(lastRow);
                    lastStart = start;
                    lastEnd = end;
                }
            }
            lastRow = row;
            lastName = name;
            lastAnnotation = annotation;
            lastFrame = frame;
        }
        listNew.add(lastRow);
        return listNew;
    }

    private List<List<Integer>> findMatchingIndicesByTerms(List<List<String>> rowGroupOverlapping) {
        ArrayList<List<Integer>> listMatchingIndices = new ArrayList<List<Integer>>();
        for (CsvCurationAdvancedFilter filter : this.listAdvancedFilters) {
            List<Integer> listMatching = this.findMatchingIndicesByTerms(rowGroupOverlapping, filter);
            if (listMatching == null || listMatching.size() <= 0) continue;
            listMatchingIndices.add(listMatching);
        }
        return listMatchingIndices;
    }

    private List<Integer> findMatchingIndicesByTerms(List<List<String>> rowGroupOverlapping, CsvCurationAdvancedFilter filter) {
        if (filter.concatenated) {
            if (filter.repeat) {
                return this.findMatchingIndicesByTermsMultipleRepeats(rowGroupOverlapping, filter);
            }
            return this.findMatchingIndicesByTermsMultipleNoRepeats(rowGroupOverlapping, filter);
        }
        return this.findMatchingIndicesByTermsSingle(rowGroupOverlapping, filter);
    }

    private List<Integer> findMatchingIndicesByTermsMultipleRepeats(List<List<String>> rowGroupOverlapping, CsvCurationAdvancedFilter filter) {
        ArrayList<Integer> matchingIndices = new ArrayList<Integer>();
        ArrayList<Integer> matchingTermIndices = new ArrayList<Integer>();
        if (rowGroupOverlapping.size() == 1) {
            return matchingIndices;
        }
        List<String> listFilterTerms = filter.terms;
        int columnFilterTermIndex = filter.column;
        int i = 0;
        while (i < rowGroupOverlapping.size()) {
            List<String> row = rowGroupOverlapping.get(i);
            String rowValue = row.get(columnFilterTermIndex).trim();
            matchingIndices = new ArrayList();
            int currentTermIndex = 0;
            boolean valueMatchesTerm = this.valueMatchesTerm(rowValue, listFilterTerms.get(currentTermIndex), filter.regexp);
            if (valueMatchesTerm) {
                int lowestStart = -1;
                int highestEnd = -1;
                int j = i;
                while (j < rowGroupOverlapping.size() && valueMatchesTerm) {
                    List<String> rowInner = rowGroupOverlapping.get(j);
                    String valueInner = rowInner.get(columnFilterTermIndex).trim();
                    if (valueMatchesTerm && !matchingTermIndices.contains(currentTermIndex)) {
                        matchingTermIndices.add(currentTermIndex);
                    }
                    if (!(valueMatchesTerm = this.valueMatchesTerm(valueInner, listFilterTerms.get(currentTermIndex), filter.regexp)) && currentTermIndex < listFilterTerms.size() - 1) {
                        valueMatchesTerm = this.valueMatchesTerm(valueInner, listFilterTerms.get(currentTermIndex + 1), filter.regexp);
                        ++currentTermIndex;
                    }
                    if (valueMatchesTerm) {
                        if (!matchingIndices.contains(j)) {
                            matchingIndices.add(j);
                        }
                        int start = Integer.parseInt(rowInner.get(this.columnQueryFromIndex));
                        int end = Integer.parseInt(rowInner.get(this.columnQueryToIndex));
                        if (lowestStart == -1 || start < lowestStart) {
                            lowestStart = start;
                        }
                        if (highestEnd == -1 || end > highestEnd) {
                            highestEnd = end;
                        }
                    }
                    ++j;
                }
                if (matchingTermIndices.size() == listFilterTerms.size()) {
                    this.lastMatchingFilter = filter;
                    int totalLen = highestEnd - lowestStart;
                    if (totalLen < this.filterMaxLen) {
                        return matchingIndices;
                    }
                }
            }
            ++i;
        }
        return matchingIndices;
    }

    private List<Integer> findMatchingIndicesByTermsMultipleNoRepeats(List<List<String>> rowGroupOverlapping, CsvCurationAdvancedFilter filter) {
        ArrayList<Integer> matchingIndices = new ArrayList<Integer>();
        if (rowGroupOverlapping.size() == 1) {
            return matchingIndices;
        }
        List<String> listFilterTerms = filter.terms;
        int columnFilterTermIndex = filter.column;
        int i = 0;
        while (i < rowGroupOverlapping.size() && matchingIndices.size() != listFilterTerms.size()) {
            List<String> row = rowGroupOverlapping.get(i);
            String rowValue = row.get(columnFilterTermIndex).trim();
            matchingIndices = new ArrayList();
            boolean valueMatchesTerm = this.valueMatchesTerm(rowValue, listFilterTerms.get(0), filter.regexp);
            if (valueMatchesTerm) {
                int totalLen;
                int filterI = 0;
                int countEquals = 0;
                int lowestStart = -1;
                int highestEnd = -1;
                int j = i;
                while (j < rowGroupOverlapping.size() && j < i + listFilterTerms.size()) {
                    List<String> rowInner = rowGroupOverlapping.get(j);
                    String valueInner = rowInner.get(columnFilterTermIndex).trim();
                    valueMatchesTerm = this.valueMatchesTerm(valueInner, listFilterTerms.get(filterI), filter.regexp);
                    if (valueMatchesTerm) {
                        if (!matchingIndices.contains(j)) {
                            matchingIndices.add(j);
                        }
                        ++countEquals;
                        int start = Integer.parseInt(rowInner.get(this.columnQueryFromIndex));
                        int end = Integer.parseInt(rowInner.get(this.columnQueryToIndex));
                        if (lowestStart == -1 || start < lowestStart) {
                            lowestStart = start;
                        }
                        if (highestEnd == -1 || end > highestEnd) {
                            highestEnd = end;
                        }
                    }
                    ++filterI;
                    ++j;
                }
                if (countEquals == listFilterTerms.size() && (totalLen = highestEnd - lowestStart) < this.filterMaxLen) {
                    return matchingIndices;
                }
            }
            ++i;
        }
        return matchingIndices;
    }

    private List<Integer> findMatchingIndicesByTermsSingleRepeats(List<List<String>> rowGroupOverlapping, CsvCurationAdvancedFilter filter) {
        ArrayList<Integer> matchingIndices = new ArrayList<Integer>();
        if (rowGroupOverlapping.size() == 1) {
            return matchingIndices;
        }
        List<String> listFilterTerms = filter.terms;
        int columnFilterTermIndex = filter.column;
        String firstTerm = listFilterTerms.get(0);
        int i = 0;
        while (i < rowGroupOverlapping.size()) {
            List<String> row = rowGroupOverlapping.get(i);
            String filterValue = row.get(columnFilterTermIndex).trim();
            matchingIndices = new ArrayList();
            boolean valueMatchesTerm = this.valueMatchesTerm(filterValue, firstTerm, filter.regexp);
            if (valueMatchesTerm) {
                int lowestStart = -1;
                int highestEnd = -1;
                int j = i;
                while (j < rowGroupOverlapping.size() && valueMatchesTerm) {
                    List<String> rowInner = rowGroupOverlapping.get(j);
                    String valueInner = rowInner.get(columnFilterTermIndex).trim();
                    valueMatchesTerm = this.valueMatchesTerm(valueInner, firstTerm, filter.regexp);
                    if (valueMatchesTerm) {
                        if (!matchingIndices.contains(j)) {
                            matchingIndices.add(j);
                        }
                        int start = Integer.parseInt(rowInner.get(this.columnQueryFromIndex));
                        int end = Integer.parseInt(rowInner.get(this.columnQueryToIndex));
                        if (lowestStart == -1 || start < lowestStart) {
                            lowestStart = start;
                        }
                        if (highestEnd == -1 || end > highestEnd) {
                            highestEnd = end;
                        }
                    }
                    ++j;
                }
                int totalLen = highestEnd - lowestStart;
                if (totalLen < this.filterMaxLen) {
                    return matchingIndices;
                }
            }
            ++i;
        }
        return matchingIndices;
    }

    private List<Integer> findMatchingIndicesByTermsSingle(List<List<String>> rowGroupOverlapping, CsvCurationAdvancedFilter filter) {
        ArrayList<Integer> matchingIndices = new ArrayList<Integer>();
        if (rowGroupOverlapping.size() == 1) {
            return matchingIndices;
        }
        int columnFilterTermIndex = filter.column;
        int i = 0;
        while (i < rowGroupOverlapping.size()) {
            List<String> row = rowGroupOverlapping.get(i);
            String filterValue = row.get(columnFilterTermIndex).trim();
            matchingIndices = new ArrayList();
            for (String filterTerm : filter.terms) {
                boolean valueMatchesTerm = this.valueMatchesTerm(filterValue, filterTerm, filter.regexp);
                if (!valueMatchesTerm) continue;
                int lowestStart = -1;
                int highestEnd = -1;
                int j = i;
                while (j < rowGroupOverlapping.size() && valueMatchesTerm) {
                    List<String> rowInner = rowGroupOverlapping.get(j);
                    String valueInner = rowInner.get(columnFilterTermIndex).trim();
                    valueMatchesTerm = this.valueMatchesTerm(valueInner, filterTerm, filter.regexp);
                    if (valueMatchesTerm) {
                        if (!matchingIndices.contains(j)) {
                            matchingIndices.add(j);
                        }
                        int start = Integer.parseInt(rowInner.get(this.columnQueryFromIndex));
                        int end = Integer.parseInt(rowInner.get(this.columnQueryToIndex));
                        if (lowestStart == -1 || start < lowestStart) {
                            lowestStart = start;
                        }
                        if (highestEnd == -1 || end > highestEnd) {
                            highestEnd = end;
                        }
                    }
                    ++j;
                }
                int totalLen = highestEnd - lowestStart;
                if (totalLen >= this.filterMaxLen) continue;
                this.lastMatchingFilter = filter;
                return matchingIndices;
            }
            ++i;
        }
        return matchingIndices;
    }

    private boolean valueMatchesTerm(String rowValue, String term, boolean filterRegexp) {
        boolean valueMatchesTerm = false;
        if (filterRegexp) {
            Pattern pattern = Pattern.compile(term, 2);
            Matcher matcher = pattern.matcher(rowValue);
            if (matcher.matches()) {
                valueMatchesTerm = true;
            }
        } else {
            valueMatchesTerm = rowValue.equalsIgnoreCase(term);
        }
        return valueMatchesTerm;
    }

    public String getFrame(String frameText) {
        if (frameText.contains(FRAME_MINUS)) {
            if (frameText.contains(",")) {
                String[] parts;
                String[] stringArray = parts = frameText.split(",");
                int n = parts.length;
                int n2 = 0;
                while (n2 < n) {
                    String p = stringArray[n2];
                    if (!p.contains(FRAME_MINUS)) {
                        return null;
                    }
                    ++n2;
                }
                return FRAME_MINUS;
            }
            return FRAME_MINUS;
        }
        if (frameText.contains(",")) {
            String[] parts;
            String[] stringArray = parts = frameText.split(",");
            int n = parts.length;
            int n3 = 0;
            while (n3 < n) {
                String p = stringArray[n3];
                if (p.contains(FRAME_MINUS)) {
                    return null;
                }
                ++n3;
            }
            return FRAME_PLUS;
        }
        return FRAME_PLUS;
    }

    public int getDistance(int start1, int end1, int start2, int end2) {
        int firstEnd = end1;
        int lastStart = start2;
        if (start2 < start1) {
            firstEnd = end2;
            lastStart = start1;
        }
        return lastStart - firstEnd;
    }

    public int getLength(int start1, int end1, int start2, int end2) {
        int lowestStart = start1;
        int highestEnd = end1;
        if (start2 < lowestStart) {
            lowestStart = start2;
        }
        if (end2 > highestEnd) {
            highestEnd = end2;
        }
        return highestEnd - lowestStart;
    }

    public List<String> mergeRows(List<String> firstRow, List<String> lastRow) {
        ArrayList<String> mergedRow = new ArrayList<String>();
        int newStart = Integer.parseInt(firstRow.get(this.columnQueryFromIndex));
        if (Integer.parseInt(lastRow.get(this.columnQueryFromIndex)) < newStart) {
            newStart = Integer.parseInt(lastRow.get(this.columnQueryFromIndex));
        }
        int newEnd = Integer.parseInt(firstRow.get(this.columnQueryToIndex));
        if (Integer.parseInt(lastRow.get(this.columnQueryToIndex)) > newEnd) {
            newEnd = Integer.parseInt(lastRow.get(this.columnQueryToIndex));
        }
        int newSize = newEnd - newStart;
        newSize = this.getLength(Integer.parseInt(firstRow.get(this.columnQueryFromIndex)), Integer.parseInt(firstRow.get(this.columnQueryToIndex)), Integer.parseInt(lastRow.get(this.columnQueryFromIndex)), Integer.parseInt(lastRow.get(this.columnQueryToIndex)));
        int i = 0;
        while (i < firstRow.size()) {
            if (i == this.columnSeqnameIndex) {
                mergedRow.add(firstRow.get(this.columnSeqnameIndex));
            } else if (i == this.columnAnnotationIndex) {
                mergedRow.add(firstRow.get(this.columnAnnotationIndex));
            } else if (i == this.columnQueryFromIndex) {
                mergedRow.add(String.valueOf(newStart));
            } else if (i == this.columnQueryToIndex) {
                mergedRow.add(String.valueOf(newEnd));
            } else if (i == this.columnSizeIndex) {
                mergedRow.add(String.valueOf(newSize));
            } else {
                String value1 = firstRow.get(i).trim();
                String value2 = lastRow.get(i).trim();
                Object mergedValues = "";
                if (!value1.isEmpty() && !value2.isEmpty() && value1.equals(value2)) {
                    mergedValues = value1;
                } else {
                    if (!value1.isEmpty()) {
                        mergedValues = (String)mergedValues + value1;
                    }
                    if (!value2.isEmpty()) {
                        if (!((String)mergedValues).isEmpty()) {
                            mergedValues = (String)mergedValues + ",";
                        }
                        mergedValues = (String)mergedValues + value2;
                    }
                }
                mergedRow.add((String)mergedValues);
            }
            ++i;
        }
        return mergedRow;
    }

    class RowStartComparator
    implements Comparator<List<String>> {
        private int columnQueryFromIndex;

        public RowStartComparator(int columnQueryFromIndex) {
            this.columnQueryFromIndex = columnQueryFromIndex;
        }

        @Override
        public int compare(List<String> o1, List<String> o2) {
            return Integer.parseInt(o1.get(this.columnQueryFromIndex)) - Integer.parseInt(o2.get(this.columnQueryFromIndex));
        }
    }
}

