/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.jobs.csvEditor;

import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.model.CsvEditor.actions.CsvActionRowColor;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Shell;

public class CsvColorRowsMultipleRunnable
implements IRunnableWithProgress {
    private final String TASK_NAME = "Apply colors";
    private CSVEditor csvEditor;
    private List<List<Integer>> listIndices;
    private Color[] color;
    private long timestamp;
    private Shell shell;
    private int stepSize = 1;
    private int totalRowIndices = 0;

    public CsvColorRowsMultipleRunnable(CSVEditor csvEditor, List<List<Integer>> listIndices, Color[] color, long timestamp) {
        this.csvEditor = csvEditor;
        this.listIndices = listIndices;
        this.color = color;
        this.timestamp = timestamp;
    }

    public CsvColorRowsMultipleRunnable(CSVEditor csvEditor, List<List<Integer>> listIndices, Color[] color) {
        this(csvEditor, listIndices, color, System.currentTimeMillis());
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.shell = this.csvEditor.getSite().getShell();
        for (List<Integer> l : this.listIndices) {
            this.totalRowIndices += l.size();
        }
        if (this.totalRowIndices > 1000) {
            this.stepSize = this.totalRowIndices / 100;
        }
        long timeStart = System.currentTimeMillis();
        this.setColorByIndex(monitor);
        long timeEnd = System.currentTimeMillis();
        if (this.csvEditor.getDebug()) {
            System.out.println("Applied colors to " + new DecimalFormat("###,###").format(this.totalRowIndices) + " rows in " + new DecimalFormat("###,###").format(timeEnd - timeStart) + "ms");
        }
    }

    public void setColorByIndex(IProgressMonitor monitor) throws InterruptedException {
        try {
            int colorCount = this.color.length;
            monitor.beginTask("Apply colors", this.totalRowIndices);
            int i = 0;
            while (i < colorCount) {
                this.setColorByIndex(this.listIndices.get(i), this.color[i], (IProgressMonitor)new SubProgressMonitor(monitor, this.listIndices.get(i).size()));
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    public void setColorByIndex(List<Integer> listSingle, final Color colorSingle, IProgressMonitor monitor) throws InterruptedException {
        try {
            monitor.beginTask("Apply colors", this.listIndices.size());
            int i = 0;
            while (i < listSingle.size()) {
                final int fi = listSingle.get(i);
                this.shell.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Color oldColor = CsvColorRowsMultipleRunnable.this.csvEditor.getTableViewer().getTable().getItem(fi).getBackground();
                        CsvColorRowsMultipleRunnable.this.csvEditor.getTableViewer().getTable().getItem(fi).setBackground(colorSingle);
                        CsvColorRowsMultipleRunnable.this.csvEditor.getListActions().add(new CsvActionRowColor(fi, oldColor, colorSingle, CsvColorRowsMultipleRunnable.this.timestamp));
                    }
                });
                if (i % this.stepSize == 0) {
                    monitor.worked(this.stepSize);
                    monitor.subTask("Applying colors...");
                }
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }
}

