/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.jobs.csvEditor;

import com.biotechvana.csveditor.editors.CSVEditor;
import java.lang.reflect.InvocationTargetException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.TableItem;

public class CsvCalculateColorMapRunnable
implements IRunnableWithProgress {
    private CSVEditor csvEditor;
    private Map<String, Color> mapColors;
    private MessageDigest md;
    private TableItem[] listItems;
    private int columnCount;
    private int stepSize = 100;
    private DecimalFormat decimalFormat = new DecimalFormat("###,###");

    public CsvCalculateColorMapRunnable(CSVEditor csvEditor) {
        this.csvEditor = csvEditor;
        this.listItems = csvEditor.getTable().getItems();
        this.columnCount = csvEditor.getTable().getColumnCount();
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        long timeStart = System.currentTimeMillis();
        this.associateColors(monitor);
        long timeEnd = System.currentTimeMillis();
        if (this.csvEditor.getDebug()) {
            System.out.println("Calculated hash map colors for " + this.decimalFormat.format(this.listItems.length) + " rows in " + this.decimalFormat.format(timeEnd - timeStart) + "ms");
        }
    }

    private void associateColors(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
        try {
            this.mapColors = new TreeMap<String, Color>();
            try {
                this.md = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new InvocationTargetException(e);
            }
            monitor.beginTask("Read colors", this.listItems.length);
            this.stepSize = this.listItems.length / 10;
            int i = 0;
            while (i < this.listItems.length) {
                final TableItem fti = this.listItems[i];
                this.csvEditor.getSite().getShell().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        StringBuilder lineContent = new StringBuilder();
                        int i = 2;
                        while (i < CsvCalculateColorMapRunnable.this.columnCount) {
                            lineContent.append(fti.getText(i));
                            ++i;
                        }
                        CsvCalculateColorMapRunnable.this.md.update(lineContent.toString().getBytes());
                        byte[] digestBytes = CsvCalculateColorMapRunnable.this.md.digest();
                        StringBuilder builderBytes = new StringBuilder();
                        byte[] byArray = digestBytes;
                        int n = digestBytes.length;
                        int n2 = 0;
                        while (n2 < n) {
                            byte b = byArray[n2];
                            builderBytes.append(Integer.toHexString(b & 0xFF | 0x100).substring(1, 3));
                            ++n2;
                        }
                        CsvCalculateColorMapRunnable.this.mapColors.put(builderBytes.toString(), fti.getBackground());
                    }
                });
                if (i % this.stepSize == 0) {
                    monitor.worked(this.stepSize);
                    monitor.subTask("Reading row " + this.decimalFormat.format(i) + " of " + this.decimalFormat.format(this.listItems.length));
                }
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }

    public Map<String, Color> getMapColors() {
        return this.mapColors;
    }

    private void printMap() {
        Iterator<Map.Entry<String, Color>> it = this.mapColors.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Color> entry = it.next();
            System.out.println(String.valueOf(entry.getKey()) + " = " + String.valueOf(entry.getValue()));
            it.remove();
        }
    }
}

