/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.jobs.csvEditor;

import com.biotechvana.csveditor.editors.CSVEditor;
import java.lang.reflect.InvocationTargetException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.TableItem;

public class CsvApplyColorMapRunnable
implements IRunnableWithProgress {
    private CSVEditor csvEditor;
    private Map<String, Color> mapColor;
    private MessageDigest md;
    private TableItem[] listItems;
    private int columnCount;
    private int stepSize = 100;

    public CsvApplyColorMapRunnable(CSVEditor csvEditor, Map<String, Color> mapColor) {
        this.csvEditor = csvEditor;
        this.mapColor = mapColor;
        this.listItems = csvEditor.getTable().getItems();
        this.columnCount = csvEditor.getTable().getColumnCount();
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        long timeStart = System.currentTimeMillis();
        this.applyColor(monitor);
        long timeEnd = System.currentTimeMillis();
        if (this.csvEditor.getDebug()) {
            System.out.println("Color applied to " + new DecimalFormat("###,###").format(this.listItems.length) + " rows in " + new DecimalFormat("###,###").format(timeEnd - timeStart) + "ms");
        }
    }

    private void applyColor(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask("Apply colors", this.listItems.length);
            try {
                this.md = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new InvocationTargetException(e);
            }
            int i = 0;
            while (i < this.listItems.length) {
                final TableItem fti = this.listItems[i];
                this.csvEditor.getSite().getShell().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        StringBuilder lineContent = new StringBuilder();
                        int i = 2;
                        while (i < CsvApplyColorMapRunnable.this.columnCount) {
                            lineContent.append(fti.getText(i));
                            ++i;
                        }
                        CsvApplyColorMapRunnable.this.md.update(lineContent.toString().getBytes());
                        byte[] digestBytes = CsvApplyColorMapRunnable.this.md.digest();
                        StringBuilder builderBytes = new StringBuilder();
                        byte[] byArray = digestBytes;
                        int n = digestBytes.length;
                        int n2 = 0;
                        while (n2 < n) {
                            byte b = byArray[n2];
                            builderBytes.append(Integer.toHexString(b & 0xFF | 0x100).substring(1, 3));
                            ++n2;
                        }
                        Color backColor = CsvApplyColorMapRunnable.this.mapColor.get(builderBytes.toString());
                        if (backColor != null) {
                            fti.setBackground(backColor);
                        }
                    }
                });
                if (i % this.stepSize == 0) {
                    monitor.worked(this.stepSize);
                }
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                ++i;
            }
        }
        finally {
            monitor.done();
        }
    }
}

