/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.jobs.csvEditor;

import com.biotechvana.csvUtils.CSVUtils2;
import com.biotechvana.csveditor.editors.CSVEditor;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class CsvAppendWorksheetRunnable
implements IRunnableWithProgress {
    private final String TITLE = "Append worksheet";
    private List<List<String>> model;
    private String importWorksheet;

    public static void main(String[] args) {
    }

    public CsvAppendWorksheetRunnable(CSVEditor csvEditor, String importWorksheet) {
        this.importWorksheet = importWorksheet;
        this.model = (ArrayList)csvEditor.getModel();
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.appendWorksheet(this.importWorksheet, monitor);
    }

    public void appendWorksheet(String importWorksheet, IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
        NumberFormat nf = NumberFormat.getInstance();
        try {
            try {
                CSVUtils2 csvUtils = CSVUtils2.createNewUtils((File)new File(importWorksheet), (boolean)true);
                csvUtils.parse();
                List importModel = csvUtils.getModel(true, false);
                int modelSize = importModel.size();
                int stepSize = 100;
                if (modelSize > 100) {
                    stepSize = modelSize / 100;
                }
                int countAppended = 0;
                monitor.beginTask("Append worksheet", 100);
                for (List row : importModel) {
                    this.model.add(row);
                    if (++countAppended % stepSize == 0) {
                        monitor.subTask("Imported " + nf.format(countAppended) + " of " + nf.format(modelSize) + " rows.");
                        monitor.worked(1);
                    }
                    if (!monitor.isCanceled()) continue;
                    throw new InterruptedException();
                }
            }
            catch (Exception ex) {
                throw new InvocationTargetException(ex);
            }
        }
        finally {
            monitor.done();
        }
    }
}

