/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csveditor.jobs.csvEditor;

import com.biotechvana.csveditor.editors.CSVEditor;
import com.biotechvana.csveditor.editors.CSVEditorInput;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class CSVEditorSaveDocumentRunnable
implements IRunnableWithProgress {
    private CSVEditor csvEditor;
    private File outputFile;
    private DecimalFormat decimalFormat = new DecimalFormat("###,###");
    private char separator;
    private char delimiter;
    private int[] columnOrder;
    private String[] header;
    private String multihitFile;
    private List<Integer> listColumnIndices;
    private List<Integer> listRowIndices;
    private BufferedWriter writer;
    private int[] outColumnIndices;

    public CSVEditorSaveDocumentRunnable(CSVEditor csvEditor, File outputFile, char separator, char delimiter) {
        this.csvEditor = csvEditor;
        this.outputFile = outputFile;
        this.separator = separator;
        this.delimiter = delimiter;
        this.columnOrder = csvEditor.getTable().getColumnOrder();
        this.header = csvEditor.getEditorUtils2().getColumnNamesAsArray(true, false, false);
        if (csvEditor.isMultiHit()) {
            this.multihitFile = ((CSVEditorInput)csvEditor.getEditorInput()).getMultiHitFile().getAbsolutePath();
        }
    }

    public CSVEditorSaveDocumentRunnable(CSVEditor csvEditor, File outputFile, char separator, char delimiter, List<Integer> listColumnIndices, List<Integer> listRowIndices) {
        this.csvEditor = csvEditor;
        this.outputFile = outputFile;
        this.separator = separator;
        this.delimiter = delimiter;
        this.listColumnIndices = listColumnIndices;
        this.listRowIndices = listRowIndices;
        this.columnOrder = csvEditor.getTable().getColumnOrder();
        this.header = csvEditor.getEditorUtils2().getColumnNamesAsArray(true, false, false);
        if (csvEditor.isMultiHit()) {
            this.multihitFile = ((CSVEditorInput)csvEditor.getEditorInput()).getMultiHitFile().getAbsolutePath();
        }
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        if (this.listColumnIndices != null && this.listRowIndices != null) {
            this.saveSelection(monitor);
        } else {
            try {
                this.saveAll(monitor);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void saveAll(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            this.writer = new BufferedWriter(new FileWriter(this.outputFile));
            try {
                List model = (List)this.csvEditor.getModel();
                int modelSize = model.size();
                int stepSize = modelSize / 10;
                monitor.beginTask("Save worksheet", modelSize);
                String comments = this.csvEditor.getComments(false);
                if (comments != null && comments.length() > 0) {
                    this.writer.append(comments.trim());
                    this.writer.newLine();
                }
                monitor.subTask("Writing headers");
                this.writer.append(this.rowToString(this.header));
                this.writer.newLine();
                this.csvEditor.getSite().getShell().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        CSVEditorSaveDocumentRunnable.this.outColumnIndices = CSVEditorSaveDocumentRunnable.this.csvEditor.getEditorUtils2().getColumnIndicesAsArray(CSVEditorSaveDocumentRunnable.this.header);
                    }
                });
                int counter = 1;
                int stepCounter = 0;
                for (List row : model) {
                    this.writer.append(this.rowToString((List<String>)row, this.outColumnIndices, true));
                    this.writer.newLine();
                    if (counter % stepSize == 0) {
                        monitor.worked(stepSize);
                        monitor.subTask("Writing " + ++stepCounter * 10 + "%");
                    }
                    ++counter;
                    if (!monitor.isCanceled()) continue;
                    throw new InterruptedException();
                }
            }
            finally {
                this.writer.close();
                monitor.done();
            }
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
    }

    private void saveSelection(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            this.writer = new BufferedWriter(new FileWriter(this.outputFile));
            try {
                List model = (List)this.csvEditor.getModel();
                int taskUnits = model.size();
                if (this.listRowIndices != null) {
                    taskUnits = this.listRowIndices.size();
                }
                monitor.beginTask("Save worksheet", taskUnits);
                String comments = this.csvEditor.getComments(false);
                if (comments != null && comments.length() > 0) {
                    this.writer.append(comments.trim());
                    this.writer.newLine();
                }
                monitor.subTask("Writing headers");
                this.saveHeaders();
                monitor.subTask("Writing rows");
                this.saveModel(model, monitor, taskUnits);
                monitor.subTask("Finished.");
            }
            finally {
                this.writer.close();
                monitor.done();
            }
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
    }

    private void saveHeaders() throws IOException {
        if (this.listColumnIndices != null) {
            this.writer.append(this.rowToString(this.header, this.listColumnIndices, false));
        } else {
            this.writer.append(this.rowToString(this.header));
        }
        this.writer.newLine();
    }

    private void saveModel(List<List<String>> model, IProgressMonitor monitor, int taskUnits) throws IOException, InterruptedException {
        int counter = 1;
        if (this.listRowIndices != null) {
            for (int r : this.listRowIndices) {
                this.writer.append(this.rowToString(model.get(r), this.listColumnIndices, true));
                this.writer.newLine();
                monitor.worked(1);
                monitor.subTask("Writing " + this.decimalFormat.format(counter++) + " row of " + this.decimalFormat.format(taskUnits) + " total rows");
                if (!monitor.isCanceled()) continue;
                throw new InterruptedException();
            }
        } else {
            for (List<String> row : model) {
                this.writer.append(this.rowToString(row, this.listColumnIndices, true));
                this.writer.newLine();
                monitor.worked(1);
                monitor.subTask("Writing " + this.decimalFormat.format(counter++) + " row of " + this.decimalFormat.format(taskUnits) + " total rows");
                if (!monitor.isCanceled()) continue;
                throw new InterruptedException();
            }
        }
    }

    private String rowToString(String[] row) {
        return this.rowToString(new ArrayList<String>(Arrays.asList(row)));
    }

    private String rowToString(List<String> row) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < row.size() - 1) {
            builder.append(this.delimiter);
            builder.append(row.get(i));
            builder.append(this.delimiter);
            builder.append(this.separator);
            ++i;
        }
        builder.append(this.delimiter);
        builder.append(row.get(row.size() - 1));
        builder.append(this.delimiter);
        return builder.toString();
    }

    private String rowToString(String[] row, List<Integer> listColumnIndices, boolean skipFirstColumns) {
        return this.rowToString(new ArrayList<String>(Arrays.asList(row)), listColumnIndices, skipFirstColumns);
    }

    private String rowToString(List<String> row, int[] listColumnIndices, boolean skipFirstColumns) {
        ArrayList<Integer> listColumns = new ArrayList<Integer>(listColumnIndices.length);
        int[] nArray = listColumnIndices;
        int n = listColumnIndices.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            listColumns.add(i);
            ++n2;
        }
        return this.rowToString(row, listColumns, skipFirstColumns);
    }

    private String rowToString(List<String> row, List<Integer> listColumnIndices, boolean skipFirstColumns) {
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < listColumnIndices.size() - 1) {
            int co = listColumnIndices.get(i);
            if (!skipFirstColumns || skipFirstColumns && co != 0 && co != 1) {
                builder.append(this.delimiter);
                builder.append(row.get(co));
                builder.append(this.delimiter);
                builder.append(this.separator);
            }
            ++i;
        }
        int co = listColumnIndices.get(listColumnIndices.size() - 1);
        if (!skipFirstColumns || skipFirstColumns && co != 0 && co != 1) {
            builder.append(this.delimiter);
            builder.append(row.get(co));
            builder.append(this.delimiter);
        }
        return builder.toString();
    }
}

